/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.VPUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class Catalyst
extends Vestige {
    List<MobEffectInstance> effectList = new ArrayList<MobEffectInstance>();

    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(17, ChatFormatting.GREEN, 2, 40, 1, 75, 1, 1, hasDamage, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.CATALYST1.get());
        for (LivingEntity entity : VPUtil.getEntities(player, 20.0, false)) {
            if (VPUtil.isProtectedFromHit(player, (Entity)entity)) continue;
            ArrayList<MobEffectInstance> list = new ArrayList<MobEffectInstance>(VPUtil.getEffectsHas(entity, false));
            VPUtil.clearEffects(entity, false);
            for (MobEffectInstance effectInstance : list) {
                int duration = (int)((double)effectInstance.m_19557_() * 1.15);
                int amplifier = effectInstance.m_19564_();
                Random random = new Random();
                if (random.nextDouble() < 0.2) {
                    ++amplifier;
                }
                entity.m_7292_(new MobEffectInstance(effectInstance.m_19544_(), duration, amplifier));
                this.addRadiance(3.0f, stack, player);
            }
            VPUtil.spawnParticles((Entity)player, (ParticleOptions)ParticleTypes.f_123795_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 8, 0.0, -0.5, 0.0);
        }
        if (Catalyst.isStellar(stack)) {
            player.getPersistentData().m_128405_("VPDebuffDefence", VPUtil.scalePower((Integer)ConfigHandler.COMMON.catalystDeffence.get(), 17, player));
        }
        Random random = new Random();
        int duration = random.nextInt(140) + 60;
        int power = random.nextInt(5);
        player.m_7292_(new MobEffectInstance(VPUtil.getRandomEffect(true), VPUtil.scalePower(duration * 20, 17, player), VPUtil.scalePower(power, 17, player)));
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.CATALYST2.get());
        Random random = new Random();
        int stolen = 0;
        for (LivingEntity entity : VPUtil.getEntities(player, 25.0, false)) {
            if (VPUtil.isProtectedFromHit(player, (Entity)entity)) continue;
            ArrayList<MobEffectInstance> list = new ArrayList<MobEffectInstance>();
            for (MobEffectInstance instance : VPUtil.getEffectsHas(entity, true)) {
                if (instance.m_19564_() > 4 && (!Catalyst.isStellar(stack) || instance.m_19564_() > (Integer)ConfigHandler.COMMON.catalystLvlLimit.get())) continue;
                list.add(instance);
                entity.m_21195_(instance.m_19544_());
                ++stolen;
            }
            for (MobEffectInstance effectInstance : list) {
                player.m_7292_(new MobEffectInstance(effectInstance.m_19544_(), effectInstance.m_19557_(), effectInstance.m_19564_()));
                entity.m_7292_(new MobEffectInstance(VPUtil.getRandomEffect(false), 200, random.nextInt(3)));
                this.addRadiance(3.0f, stack, player);
            }
            VPUtil.spawnParticles((Entity)player, (ParticleOptions)ParticleTypes.f_123774_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 8, 0.0, -0.5, 0.0);
        }
        if (stolen > 0) {
            ArrayList<MobEffectInstance> list = new ArrayList<MobEffectInstance>();
            for (MobEffectInstance instance : VPUtil.getEffectsHas((LivingEntity)player, true)) {
                if (instance.m_19564_() > 4 && !Catalyst.isStellar(stack)) continue;
                list.add(instance);
                player.m_21195_(instance.m_19544_());
            }
            for (MobEffectInstance effectInstance : list) {
                player.m_7292_(new MobEffectInstance(effectInstance.m_19544_(), effectInstance.m_19557_() * (1 + stolen / 10), effectInstance.m_19564_()));
            }
        }
        super.doUltimate(seconds, player, level, stack);
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player = (Player)slotContext.entity();
        int debuffDefence = player.getPersistentData().m_128451_("VPDebuffDefence");
        if (debuffDefence > 0) {
            if (player.getPersistentData().m_128454_("VPForbidden") > System.currentTimeMillis()) {
                player.getPersistentData().m_128356_("VPForbidden", 0L);
                --debuffDefence;
            }
            if (player.getPersistentData().m_128454_("VPDeath") > System.currentTimeMillis()) {
                player.getPersistentData().m_128356_("VPDeath", 0L);
                --debuffDefence;
            }
            if (VPUtil.getHealDebt((LivingEntity)player) > 0.0f) {
                VPUtil.setHealDebt((LivingEntity)player, 0.0f);
                --debuffDefence;
            }
            for (MobEffectInstance instance : VPUtil.getEffectsHas((LivingEntity)player, false)) {
                for (LivingEntity livingEntity : VPUtil.getEntitiesAround(player, 15.0, 15.0, 15.0, false)) {
                    livingEntity.m_7292_(new MobEffectInstance(instance.m_19544_(), instance.m_19557_(), instance.m_19564_()));
                }
                player.m_21195_(instance.m_19544_());
                --debuffDefence;
            }
            player.getPersistentData().m_128405_("VPDebuffDefence", debuffDefence);
        }
        super.curioTick(slotContext, stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand p_41434_) {
        if (this.effectList.isEmpty()) {
            ArrayList<MobEffectInstance> list = new ArrayList<MobEffectInstance>(player.m_21220_());
            this.effectList = list;
        } else {
            for (MobEffectInstance instance : this.effectList) {
                player.m_7292_(instance);
            }
            this.effectList.clear();
        }
        return super.m_7203_(level, player, p_41434_);
    }
}

