/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.VPUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Crown
extends Vestige {
    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(2, ChatFormatting.YELLOW, 5, 15, 1, 160, 1, 15, true, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.CROWN.get());
        for (LivingEntity entity : VPUtil.getMonstersAround(player, 15.0, 6.0, 15.0)) {
            if (VPUtil.isProtectedFromHit(player, (Entity)entity)) continue;
            entity.getPersistentData().m_128379_("VPCrownHit", true);
            entity.getPersistentData().m_128379_("VPCrownHitDeath", true);
            float shields = VPUtil.getShield((LivingEntity)player);
            if (VPUtil.canResurrect((Entity)entity) && shields > 10000.0f && Crown.isStellar(stack)) {
                VPUtil.dealParagonDamage(entity, player, VPUtil.scalePower(shields * 0.1f / 1000.0f, 2, player), 2, true);
                player.getPersistentData().m_128350_("VPShield", shields * 0.9f);
            }
            VPUtil.adaptiveDamageHurt(entity, player, VPUtil.scalePower(300, 2, player));
            VPUtil.spawnParticles((Entity)player, (ParticleOptions)ParticleTypes.f_175827_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 8, 0.0, 0.5, 0.0);
        }
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.CROWN_ULT.get());
        for (LivingEntity entity : VPUtil.ray(player, 3.0f, 128, false)) {
            if (VPUtil.isProtectedFromHit(player, (Entity)entity)) continue;
            VPUtil.antiResurrect(entity, this.ultimateMaxTime(stack));
            if (!(entity instanceof Player)) continue;
            Player target = (Player)entity;
            target.getPersistentData().m_128356_("VPForbidden", this.ultimateMaxTime(stack) + System.currentTimeMillis());
        }
        VPUtil.rayParticles(player, (ParticleOptions)ParticleTypes.f_175826_, 128.0, 3.0, 30, 0.0, 1.0, 0.0, 3.0, false);
        super.doUltimate(seconds, player, level, stack);
    }
}

