/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.VPUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class Devourer
extends Vestige {
    int souls = 0;

    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(15, ChatFormatting.DARK_RED, 1, 30, 1, 115, 5, 130, hasDamage, stack);
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        this.souls = stack.m_41784_().m_128451_("VPDevoured");
        super.curioTick(slotContext, stack);
    }

    @Override
    public int setSpecialActive(long seconds, Player player, ItemStack stack) {
        return super.setSpecialActive(seconds += 100L * (long)Math.min(150, this.souls), player, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.DEVOURER_BIND.get());
        for (LivingEntity entity : VPUtil.ray(player, 6.0f, 30, true)) {
            if (VPUtil.isProtectedFromHit(player, (Entity)entity)) continue;
            VPUtil.bindEntity(entity, seconds);
        }
        VPUtil.rayParticles(player, (ParticleOptions)ParticleTypes.f_123799_, 30.0, 6.0, 30, 0.0, -1.0, 0.0, 5.0, false);
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.SOUL2.get());
        player.getPersistentData().m_128405_("VPDevourerHits", VPUtil.scalePower((Integer)ConfigHandler.COMMON.devourer.get(), 15, player));
        VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_175826_, 8.0, 1, 0.0, 0.1, 0.0, 1.0, false);
        super.doUltimate(seconds, player, level, stack);
    }
}

