/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.VPUtil;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class Mark
extends Vestige {
    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(7, ChatFormatting.DARK_RED, 3, 5, 1, 120, 1, 5, hasDamage, stack);
    }

    private Multimap<Attribute, AttributeModifier> createAttributeMap() {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(UUID.fromString("4fc18d7a-9353-45b1-ad77-29117c1d9e6f"), "vp:attack_speed_modifier_mark", 2.0, AttributeModifier.Operation.MULTIPLY_BASE));
        attributesDefault.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(UUID.fromString("78cf254b-36df-41d6-be91-ad06220d9dd8"), "vp:speed_modifier_mark", 2.0, AttributeModifier.Operation.MULTIPLY_BASE));
        attributesDefault.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("54b7f5ed-0851-4745-b98c-e1f08a1a2f67"), "vp:speed_modifier_mark", 2.0, AttributeModifier.Operation.MULTIPLY_BASE));
        return attributesDefault;
    }

    private Multimap<Attribute, AttributeModifier> overdrive(int curses, Player player) {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(UUID.fromString("fd7417d3-ecd6-433c-8d76-6e0cb8bda70a"), "vp:mark1", (double)(curses *= VPUtil.scalePower((Integer)ConfigHandler.COMMON.markBonus.get(), 7, player)), AttributeModifier.Operation.ADDITION));
        attributesDefault.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(UUID.fromString("f1a19717-72ab-4f79-b8b8-0c0d3df8b7d9"), "vp:mark2", (double)curses, AttributeModifier.Operation.ADDITION));
        attributesDefault.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.fromString("d5206e9e-9b3c-4314-a7c2-b6097df335b5"), "vp:mark3", (double)curses, AttributeModifier.Operation.ADDITION));
        attributesDefault.put((Object)Attributes.f_22286_, (Object)new AttributeModifier(UUID.fromString("54caeb55-3e90-4661-a2f6-571c5583a629"), "vp:mark4", (double)curses, AttributeModifier.Operation.ADDITION));
        attributesDefault.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(UUID.fromString("a1dd7557-8941-4e78-abba-4a146bf1574f"), "vp:mark5", (double)curses, AttributeModifier.Operation.ADDITION));
        attributesDefault.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(UUID.fromString("0743d5eb-9657-48d6-b7a7-e72055084e16"), "vp:mark6", (double)curses, AttributeModifier.Operation.ADDITION));
        attributesDefault.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(UUID.fromString("5cc193b4-7513-43f3-9724-c3453b7681b2"), "vp:mark7", (double)curses, AttributeModifier.Operation.ADDITION));
        return attributesDefault;
    }

    @Override
    public int setUltimateActive(long seconds, Player player, ItemStack stack) {
        if ((double)player.m_21223_() < (double)player.m_21233_() * 0.3) {
            seconds += 15000L;
        } else if ((double)player.m_21223_() > (double)player.m_21233_() * 0.5) {
            seconds += (long)Math.min(10, player.getPersistentData().m_128451_("VPMadness")) * 1000L;
        }
        return super.setUltimateActive(seconds, player, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, SoundEvents.f_215762_);
        if ((double)player.m_21223_() > (double)player.m_21233_() * 0.2) {
            player.m_21153_(player.m_21223_() - player.m_21233_() * 0.2f);
        } else {
            player.m_21153_(1.0f);
        }
        if (player.getPersistentData().m_128451_("VPMadness") < (Integer)ConfigHandler.COMMON.markMaximum.get()) {
            player.getPersistentData().m_128405_("VPMadness", player.getPersistentData().m_128451_("VPMadness") + 1);
        }
        VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123798_, 1.0, 1, 0.0, -0.5, 0.0, 1.0, false);
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.RAGE.get());
        int curses = VPUtil.getCurseAmount(player);
        if (curses > 20 && Mark.isStellar(stack)) {
            player.getPersistentData().m_128350_("VPOverdrive", (float)curses);
            player.m_21204_().m_22178_(this.overdrive(curses, player));
        }
        if ((double)player.m_21223_() < (double)player.m_21233_() * 0.3) {
            player.m_21204_().m_22178_(this.createAttributeMap());
        }
        player.getPersistentData().m_128379_("VPMarkUlt", true);
        VPUtil.setHealDebt((LivingEntity)player, VPUtil.getHealDebt((LivingEntity)player) + player.m_21233_() / 100.0f * (float)((Integer)ConfigHandler.COMMON.markHealDebt.get()).intValue());
        VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123744_, 2.0, 1, 0.0, -0.5, 0.0, 1.0, false);
        super.doUltimate(seconds, player, level, stack);
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player = (Player)slotContext.entity();
        if (!this.isUltimateActive(stack)) {
            player.m_21204_().m_22161_(this.createAttributeMap());
            if (Mark.isStellar(stack)) {
                player.m_21204_().m_22161_(this.overdrive(0, player));
            }
            player.getPersistentData().m_128379_("VPMarkUlt", false);
        }
        super.curioTick(slotContext, stack);
    }

    @Override
    public void ultimateEnds(Player player, ItemStack stack) {
        player.getPersistentData().m_128379_("VPMarkUlt", false);
        float damage = player.getPersistentData().m_128457_("VPDamageReduced");
        float heal = player.getPersistentData().m_128457_("VPHealReduced");
        float damageFinal = damage - heal;
        if (damageFinal > 0.0f) {
            player.m_6469_(player.m_269291_().m_269341_(), damageFinal);
        } else {
            this.addRadiance(this.getMaxRadiance(stack) * 0.3f, stack, player);
        }
        player.m_21204_().m_22161_(this.createAttributeMap());
        if (Mark.isStellar(stack)) {
            player.m_21204_().m_22161_(this.overdrive(0, player));
        }
        player.getPersistentData().m_128350_("VPDamageReduced", 0.0f);
        player.getPersistentData().m_128350_("VPHealReduced", 0.0f);
        player.getPersistentData().m_128350_("VPOverdrive", 0.0f);
        super.ultimateEnds(player, stack);
    }
}

