/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.capability.PlayerCapabilityProviderVP;
import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.mixin.FishingHookMixin;
import com.pyding.vp.util.VPUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Pearl
extends Vestige {
    boolean later = false;

    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(23, ChatFormatting.DARK_BLUE, 4, 40, 1, 45, 30, 30, false, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.BUBBLE3.get());
        VPUtil.spawnSphere((Entity)player, (ParticleOptions)ParticleTypes.f_123816_, 30, 3.0f, 0.0f);
        VPUtil.spawnCircleParticles((Entity)player, 30, ParticleTypes.f_123816_, 3.0, 0.0);
        if (player.f_36083_ != null) {
            FishingHook hook = player.f_36083_;
            if (hook.m_37166_() && hook.isInFluidType()) {
                ((FishingHookMixin)hook).setTimeLured(100);
                ((FishingHookMixin)hook).setNibble(100);
                player.m_20301_(Math.max(0, player.m_20146_() - (int)((double)player.m_6062_() * 0.3)));
            } else {
                this.later = true;
            }
        } else {
            this.later = true;
        }
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void whileSpecial(Player player, ItemStack stack) {
        FishingHook hook;
        if (this.later && player.f_36083_ != null && (hook = player.f_36083_).m_37166_() && hook.isInFluidType()) {
            ((FishingHookMixin)hook).setTimeLured(100);
            ((FishingHookMixin)hook).setNibble(100);
            player.m_20301_(Math.max(0, player.m_20146_() - (int)((double)player.m_6062_() * 0.3)));
            this.later = false;
        }
        super.whileSpecial(player, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.BUBBLE4.get());
        VPUtil.spawnSphere((Entity)player, (ParticleOptions)ParticleTypes.f_123816_, 30, 3.0f, 0.0f);
        VPUtil.spawnCircleParticles((Entity)player, 30, ParticleTypes.f_123816_, 3.0, 0.0);
        player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> player.getPersistentData().m_128405_("VPLures", VPUtil.scalePower(Math.min(30, 10 + cap.getPearls() * 5), 23, player)));
        player.getPersistentData().m_128350_("VPDepth", (float)VPUtil.getWaterDepth(player));
        super.doUltimate(seconds, player, level, stack);
    }

    @Override
    public void ultimateRecharges(Player player, ItemStack stack) {
        player.getPersistentData().m_128405_("VPLures", 0);
        super.ultimateRecharges(player, stack);
    }

    @Override
    public void ultimateEnds(Player player, ItemStack stack) {
        player.getPersistentData().m_128350_("VPDepth", 0.0f);
        super.ultimateEnds(player, stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand p_41434_) {
        if (!level.f_46443_) {
            VPUtil.printFishDrop(player);
        }
        return super.m_7203_(level, player, p_41434_);
    }
}

