/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.network.PacketHandler;
import com.pyding.vp.network.packets.ParticlePacket;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.VPUtil;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import top.theillusivec4.curios.api.SlotContext;

public class Treasure
extends Vestige {
    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(26, ChatFormatting.GOLD, 3, 60, 1, 145, 3, 30, hasDamage, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        stack.m_41784_().m_128405_("VPTicks", player.f_19797_);
        stack.m_41784_().m_128405_("VPEarthquake", 0);
        super.doSpecial(seconds, player, level, stack);
    }

    public int getRadius(ItemStack stack) {
        return Math.min(11, Math.max(1, stack.m_41784_().m_128451_("VPRadius")));
    }

    @Override
    public void whileSpecial(Player player, ItemStack stack) {
        if ((player.f_19797_ - stack.m_41784_().m_128451_("VPTicks")) % 20 == 0) {
            int earthquake = stack.m_41784_().m_128451_("VPEarthquake");
            if (earthquake < 6) {
                stack.m_41784_().m_128405_("VPEarthquake", earthquake + 1);
            }
            for (LivingEntity entity : VPUtil.getEntitiesAround(player, Math.max(1, 3 * earthquake), Math.max(1, earthquake), Math.max(1, 3 * earthquake))) {
                if (entity == player) continue;
                VPUtil.dealDamage(entity, player, player.m_269291_().m_269318_(), player.m_21230_() * 4, 2, true);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Treasure.createOvalHoleUnderPlayer(serverPlayer, Math.max(1, 3 * earthquake), Math.max(1, earthquake));
            }
        }
        super.whileSpecial(player, stack);
    }

    @Override
    public void whileUltimate(Player player, ItemStack stack) {
        int radius;
        for (radius = stack.m_41784_().m_128451_("VPRadiusOst"); radius > 10; radius -= 10) {
            stack.m_41784_().m_128405_("VPRadius", stack.m_41784_().m_128451_("VPRadius") + 1);
        }
        stack.m_41784_().m_128405_("VPRadiusOst", radius);
        super.whileUltimate(player, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        stack.m_41784_().m_128405_("VPRadius", 0);
        super.doUltimate(seconds, player, level, stack);
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_21205_().m_41720_() instanceof PickaxeItem || player.m_21206_().m_41720_() instanceof PickaxeItem) {
                float armor = VPUtil.scalePower(Treasure.getOres(player) / 20.0f, 26, player);
                float tough = VPUtil.scalePower(Treasure.getMinerals(player) / 32.0f, 26, player);
                player.m_21204_().m_22178_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22284_, UUID.fromString("e6fdfccb-e294-481c-bd65-f464a9982e3f"), armor, AttributeModifier.Operation.ADDITION, "vp.treasure.armor"));
                player.m_21204_().m_22178_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22285_, UUID.fromString("c692ceea-e05b-441f-8c98-0ff7842fa89e"), tough, AttributeModifier.Operation.ADDITION, "vp.treasure.armor"));
            } else if (player.m_21204_().m_22154_(Attributes.f_22284_, UUID.fromString("e6fdfccb-e294-481c-bd65-f464a9982e3f"))) {
                player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22284_, UUID.fromString("e6fdfccb-e294-481c-bd65-f464a9982e3f"), 0.0f, AttributeModifier.Operation.ADDITION, "vp.treasure.armor"));
                player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22285_, UUID.fromString("c692ceea-e05b-441f-8c98-0ff7842fa89e"), 0.0f, AttributeModifier.Operation.ADDITION, "vp.treasure.armor"));
            }
        }
    }

    @Override
    public void curioSucks(Player player, ItemStack stack) {
        super.curioSucks(player, stack);
        if (player.m_21204_().m_22154_(Attributes.f_22284_, UUID.fromString("e6fdfccb-e294-481c-bd65-f464a9982e3f"))) {
            player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22284_, UUID.fromString("e6fdfccb-e294-481c-bd65-f464a9982e3f"), 0.0f, AttributeModifier.Operation.ADDITION, "vp.treasure.armor"));
            player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22285_, UUID.fromString("c692ceea-e05b-441f-8c98-0ff7842fa89e"), 0.0f, AttributeModifier.Operation.ADDITION, "vp.treasure.armor"));
        }
    }

    public static float getOres(Player player) {
        float ores = 0.0f;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!VPUtil.getOres().contains(stack.m_41778_())) continue;
            ores += (float)stack.m_41613_();
        }
        return ores;
    }

    public static float getMinerals(Player player) {
        float ores = 0.0f;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            for (String name : ConfigHandler.COMMON.mineralCluster.get().toString().split(",")) {
                if (!stack.m_41778_().equals(name)) continue;
                ores += (float)stack.m_41613_();
            }
        }
        return ores;
    }

    public static void createOvalHoleUnderPlayer(ServerPlayer player, int radius, int depth) {
        ServerLevel level = (ServerLevel)player.m_9236_();
        BlockPos playerPos = player.m_20183_();
        BlockPos center = playerPos.m_7495_();
        int minX = center.m_123341_() - radius;
        int maxX = center.m_123341_() + radius;
        int minZ = center.m_123343_() - radius;
        int maxZ = center.m_123343_() + radius;
        int minY = Math.max(level.m_141937_(), center.m_123342_() - depth);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (!Treasure.isPointInEllipse(x, z, center.m_123341_(), center.m_123343_(), radius, radius)) continue;
                Treasure.digColumnToDepth(level, new BlockPos(x, center.m_123342_(), z), minY, player);
            }
        }
        Treasure.spawnDestructionEffects(level, center, radius, player);
    }

    private static boolean isPointInEllipse(int x, int z, int centerX, int centerZ, int radiusX, int radiusZ) {
        double dx = (double)(x - centerX) / (double)radiusX;
        double dz = (double)(z - centerZ) / (double)radiusZ;
        return dx * dx + dz * dz <= 1.0;
    }

    private static void digColumnToDepth(ServerLevel level, BlockPos topPos, int minY, ServerPlayer serverPlayer) {
        BlockPos currentPos;
        BlockState state;
        for (int y = topPos.m_123342_(); y >= minY && !(state = level.m_8055_(currentPos = new BlockPos(topPos.m_123341_(), y, topPos.m_123343_()))).m_60713_(Blocks.f_50752_); --y) {
            if (state.m_60795_()) continue;
            level.m_5594_(null, currentPos, state.m_60827_().m_56775_(), SoundSource.BLOCKS, 0.8f, 1.0f);
            serverPlayer.f_8941_.m_9280_(currentPos);
        }
    }

    private static void spawnDestructionEffects(ServerLevel level, BlockPos center, int radius, ServerPlayer serverPlayer) {
        for (int i = 0; i < 360; i += 15) {
            double angle = Math.toRadians(i);
            double x = (double)center.m_123341_() + (double)radius * Math.cos(angle);
            double z = (double)center.m_123343_() + (double)radius * Math.sin(angle);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123759_, x, (double)(center.m_123342_() + 1), z, 10, 0.5, 0.1, 0.5, 0.05);
        }
        PacketHandler.sendToClient(new ParticlePacket(666, center.m_123341_(), center.m_123342_(), center.m_123343_(), 0.0, 0.0, 0.0), serverPlayer);
    }
}

