/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.mixin;

import com.pyding.vp.item.ModItems;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.VPUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMixin {
    @Inject(method={"setTarget"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void setTargetMixin(LivingEntity livingEntity, CallbackInfo ci) {
        Player player;
        if (livingEntity instanceof Player && (player = (Player)livingEntity).getPersistentData().m_128403_("VPSlave") && player.getPersistentData().m_128342_("VPSlave") != player.m_20148_() && VPUtil.hasVestige((Item)ModItems.SOULBLIGHTER.get(), player)) {
            ci.cancel();
        }
    }

    @Inject(method={"getTarget"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void getTargetMixin(CallbackInfoReturnable<LivingEntity> cir) {
        Mob mob = (Mob)this;
        if (VPUtil.isNightmareBoss((LivingEntity)mob) && !(cir.getReturnValue() instanceof Player)) {
            Player player = mob.m_20193_().m_45930_((Entity)mob, 45.0);
            if (player != null) {
                cir.setReturnValue((Object)player);
            }
        } else {
            Object object = cir.getReturnValue();
            if (object instanceof Player) {
                Player player = (Player)object;
                if (mob.getPersistentData().m_128403_("VPPlayer") && player.m_20148_().compareTo(mob.getPersistentData().m_128342_("VPPlayer")) == 0) {
                    cir.setReturnValue(null);
                }
            }
        }
    }

    @Inject(method={"getEquipmentDropChance"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void getEquipmentDropChanceMixin(EquipmentSlot p_21520_, CallbackInfoReturnable<Float> cir) {
        if (ConfigHandler.COMMON_SPEC.isLoaded() && ((Boolean)ConfigHandler.COMMON.cruelMode.get()).booleanValue()) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }
}

