/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.network.packets;

import com.pyding.vp.client.MysteryChestScreen;
import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.MysteryChest;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SendStackToClient {
    private UUID playerID;
    private ItemStack stack;
    private String info;

    public SendStackToClient(UUID playerID, ItemStack stack, String info) {
        this.playerID = playerID;
        this.stack = stack;
        this.info = info;
    }

    public static void encode(SendStackToClient msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.playerID);
        buf.writeItemStack(msg.stack, false);
        buf.m_130070_(msg.info);
    }

    public static SendStackToClient decode(FriendlyByteBuf buf) {
        return new SendStackToClient(buf.m_130259_(), buf.m_130267_(), buf.m_130277_());
    }

    public static void handle(SendStackToClient msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> SendStackToClient.handle2(msg.playerID, msg.stack, msg.info));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle2(UUID playerID, ItemStack stack, String info) {
        Minecraft.m_91087_().f_91073_.m_6907_().stream().filter(player -> player.m_20148_().equals(playerID)).findAny().ifPresent(player -> {
            MysteryChestScreen.drop = stack;
            if (!info.isEmpty()) {
                MysteryChestScreen.rarity = info;
                SoundEvent sound = switch (info) {
                    case "legendary" -> (SoundEvent)SoundRegistry.CHEST_LEGENDARY.get();
                    case "mythic" -> (SoundEvent)SoundRegistry.CHEST_MYTHIC.get();
                    case "rare" -> (SoundEvent)SoundRegistry.CHEST_RARE.get();
                    default -> (SoundEvent)SoundRegistry.CHEST_COMMON.get();
                };
                HashMap<ItemStack, String> mapList = new HashMap<ItemStack, String>();
                for (int i = 0; i < new Random().nextInt(10) + 15; ++i) {
                    mapList.putAll(MysteryChest.getRandomDrop());
                }
                MysteryChestScreen.randomItems.clear();
                MysteryChestScreen.randomItems.putAll(mapList);
                player.m_20193_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, SoundSource.MASTER, 1.0f, 1.0f, false);
            }
        });
    }
}

