/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.network.packets;

import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.VPUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class StackNbtSync {
    private UUID playerID;
    private CompoundTag tag;
    private ItemStack stack;

    public StackNbtSync(UUID playerID, CompoundTag tag, ItemStack stack) {
        this.playerID = playerID;
        this.tag = tag;
        this.stack = stack;
    }

    public static void encode(StackNbtSync msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.playerID);
        buf.m_130079_(msg.tag);
        buf.writeItemStack(msg.stack, false);
    }

    public static StackNbtSync decode(FriendlyByteBuf buf) {
        return new StackNbtSync(buf.m_130259_(), buf.m_130260_(), buf.m_130267_());
    }

    public static void handle(StackNbtSync msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> StackNbtSync.handle2(msg.playerID, msg.tag, msg.stack));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle2(UUID playerID, CompoundTag tag, ItemStack stack) {
        Minecraft.m_91087_().f_91073_.m_6907_().stream().filter(player -> player.m_20148_().equals(playerID)).findAny().ifPresent(player -> {
            Item patt1695$temp = stack.m_41720_();
            if (patt1695$temp instanceof Vestige) {
                Vestige vestige = (Vestige)patt1695$temp;
                ItemStack vestigeStack = VPUtil.getVestigeStack(vestige, (Player)player);
                vestigeStack.m_41784_().m_128391_(tag);
            }
        });
    }
}

