/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.util;

import com.pyding.vp.capability.PlayerCapabilityVP;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.LongValue vestigesCooldown;
        public final ForgeConfigSpec.BooleanValue cruelMode;
        public final ForgeConfigSpec.IntValue armorCruel;
        public final ForgeConfigSpec.DoubleValue damageCruel;
        public final ForgeConfigSpec.DoubleValue absorbCruel;
        public final ForgeConfigSpec.DoubleValue shieldCruel;
        public final ForgeConfigSpec.DoubleValue overShieldCruel;
        public final ForgeConfigSpec.BooleanValue easter;
        public final ForgeConfigSpec.DoubleValue ballShield;
        public final ForgeConfigSpec.DoubleValue ballOverShield;
        public final ForgeConfigSpec.DoubleValue ballDebuff;
        public final ForgeConfigSpec.DoubleValue healPercent;
        public final ForgeConfigSpec.BooleanValue anomaly;
        public final ForgeConfigSpec.IntValue cooldown;
        public final ForgeConfigSpec.DoubleValue bossHP;
        public final ForgeConfigSpec.DoubleValue bossAttack;
        public final ForgeConfigSpec.IntValue chaostime;
        public final ForgeConfigSpec.IntValue devourer;
        public final ForgeConfigSpec.IntValue blackhole;
        public final ForgeConfigSpec.IntValue stellarChanceIncrease;
        public final ForgeConfigSpec.DoubleValue armorAbsorbPercent;
        public final ForgeConfigSpec.IntValue anomalyBorder;
        public final ForgeConfigSpec.DoubleValue atlasChance;
        public final ForgeConfigSpec.IntValue catalystLvlLimit;
        public final ForgeConfigSpec.IntValue catalystDeffence;
        public final ForgeConfigSpec.DoubleValue catSpeed;
        public final ForgeConfigSpec.IntValue catEvadeCap;
        public final ForgeConfigSpec.IntValue chaosDamageCap;
        public final ForgeConfigSpec.DoubleValue chaosChance;
        public final ForgeConfigSpec.IntValue crownShield;
        public final ForgeConfigSpec.DoubleValue devourerChance;
        public final ForgeConfigSpec.DoubleValue flowerShield;
        public final ForgeConfigSpec.DoubleValue killerRes;
        public final ForgeConfigSpec.IntValue markMaximum;
        public final ForgeConfigSpec.IntValue markHealDebt;
        public final ForgeConfigSpec.IntValue maskRotAmount;
        public final ForgeConfigSpec.DoubleValue midasChance;
        public final ForgeConfigSpec.DoubleValue prismChance;
        public final ForgeConfigSpec.DoubleValue soulBlighterChance;
        public final ForgeConfigSpec.DoubleValue soulBlighterHeal;
        public final ForgeConfigSpec.DoubleValue trigonHeal;
        public final ForgeConfigSpec.IntValue donutMaxSaturation;
        public final ForgeConfigSpec.IntValue donutHealBonus;
        public final ForgeConfigSpec.IntValue markBonus;
        public final ForgeConfigSpec.IntValue chaosCharges;
        public final ForgeConfigSpec.LongValue devourerCdTime;
        public final ForgeConfigSpec.DoubleValue refresherChance;
        public final ForgeConfigSpec.IntValue vortexReduction;
        public final ForgeConfigSpec.IntValue easterChance;
        public final ForgeConfigSpec.ConfigValue bosses;
        public final ForgeConfigSpec.ConfigValue blacklistBosses;
        public final ForgeConfigSpec.ConfigValue repairObjects;
        public final ForgeConfigSpec.ConfigValue repairBlackList;
        public final ForgeConfigSpec.ConfigValue rareItems;
        public final ForgeConfigSpec.ConfigValue fishingBlacklist;
        public final ForgeConfigSpec.DoubleValue rareFishingDropChance;
        public final ForgeConfigSpec.DoubleValue nightmareBoxChance;
        public final ForgeConfigSpec.DoubleValue nightmareRefresherChance;
        public final ForgeConfigSpec.IntValue nightmareFrags;
        public final ForgeConfigSpec.IntValue nightmareLoot;
        public final ForgeConfigSpec.IntValue nightmareLootMin;
        public final ForgeConfigSpec.IntValue nightmareFragsMin;
        public final ForgeConfigSpec.IntValue nightmareBoxes;
        public final ForgeConfigSpec.IntValue nightmareBoxesMin;
        public final ForgeConfigSpec.IntValue eatingMinutes;
        public final ForgeConfigSpec.BooleanValue failFlowers;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> reduceChallenges;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> powerScale;
        public final ForgeConfigSpec.BooleanValue reduceChallengesPercent;
        public final ForgeConfigSpec.ConfigValue fishObjects;
        public final ForgeConfigSpec.DoubleValue nightmareDpsCap;
        public final ForgeConfigSpec.BooleanValue unlockHp;
        public final ForgeConfigSpec.BooleanValue eventMode;
        public final ForgeConfigSpec.DoubleValue rareItemChance;
        public final ForgeConfigSpec.DoubleValue empoweredChance;
        public final ForgeConfigSpec.DoubleValue healthBoost;
        public final ForgeConfigSpec.ConfigValue debuffBlacklist;
        public final ForgeConfigSpec.ConfigValue cloneBlackList;
        public final ForgeConfigSpec.ConfigValue cloneWhiteList;
        public final ForgeConfigSpec.ConfigValue mirrorUUIDList;
        public final ForgeConfigSpec.ConfigValue dupersList;
        public final ForgeConfigSpec.ConfigValue leaderboardHost;
        public final ForgeConfigSpec.ConfigValue leaderboardPort;
        public final ForgeConfigSpec.BooleanValue leaderboard;
        public final ForgeConfigSpec.DoubleValue chaosCoreStellarHpRes;
        public final ForgeConfigSpec.DoubleValue oysterChance;
        public final ForgeConfigSpec.DoubleValue seashellChance;
        public final ForgeConfigSpec.ConfigValue lootDrops;
        public final ForgeConfigSpec.BooleanValue strictOptimization;
        public final ForgeConfigSpec.DoubleValue mysteryChestAdvancementChance;
        public final ForgeConfigSpec.DoubleValue mysteryChestAdvancementBoost;
        public final ForgeConfigSpec.DoubleValue mysteryChestChallengeChance;
        public final ForgeConfigSpec.ConfigValue mineralCluster;
        public final ForgeConfigSpec.ConfigValue mineralClusterBlacklist;
        public final ForgeConfigSpec.BooleanValue lore;
        public final ForgeConfigSpec.DoubleValue powerBoost;
        public final ForgeConfigSpec.DoubleValue expMultiplier;
        public final ForgeConfigSpec.DoubleValue anomalyPlayerTeleportChance;
        public static final String DEFAULT_LOOT = "1<item.vp.corrupted_fragment,item.vp.box_saplings,item.irons_spellbooks.blank_rune4,item.irons_spellbooks.rare_ink5,block.minecraft.wither_skeleton_skull,item.minecraft.end_crystal4,item.minecraft.netherite_scrap2,block.aether.enchanted_gravitite8,item.irons_spellbooks.arcane_salvage,item.minecraft.diamond4,item.botania.black_lotus8,item.bloodmagic.blankslate16,item.bloodmagic.reinforcedslate8,item.bloodmagic.infusedslate4,item.eidolon.soul_shard8,item.alexscaves.darkened_apple,block.minecraft.glass32,block.minecraft.quartz_block16,block.minecraft.gold_block4>0.3<item.vp.corrupted_item,item.minecraft.totem_of_undying,item.vp.shard,item.vp.stellar,item.vp.corrupted_fragment16,item.aquamirae.ship_graveyard_echo4,item.enigmaticlegacy.earth_heart,item.enigmaticlegacy.etherium_ore5,item.skilltree.wisdom_scroll4,block.occultism.storage_stabilizer_tier3,item.celestisynth.supernal_netherite_ingot4,item.enigmaticlegacy.angel_blessing,item.enigmaticlegacy.ocean_stone,item.enigmaticlegacy.blazing_core,item.enigmaticlegacy.eye_of_nebula,item.irons_spellbooks.lightning_upgrade_orb,item.irons_spellbooks.ice_upgrade_orb,item.irons_spellbooks.protection_upgrade_orb,item.irons_spellbooks.mana_upgrade_orb,item.irons_spellbooks.ender_upgrade_orb,item.irons_spellbooks.cooldown_upgrade_orb,item.irons_spellbooks.nature_upgrade_orb,item.irons_spellbooks.evocation_upgrade_orb,item.irons_spellbooks.fire_upgrade_orb,item.irons_spellbooks.holy_upgrade_orb,item.irons_spellbooks.blood_upgrade_orb,item.irons_spellbooks.epic_ink5,item.vp.stellar2,item.vp.stellar3,item.botania.terrasteel_ingot,item.botania.blacker_lotus8,item.bloodmagic.demonslate8,item.bloodmagic.etherealslate4,item.bloodmagic.hellforgedparts4,item.eidolon.lesser_soul_gem4,item.twilightforest.charm_of_life_1,item.twilightforest.charm_of_life_2,item.twilightforest.charm_of_keeping_1>0.05<item.vp.hearty_pearl,item.vp.vortex,item.vp.seashell,item.vp.corrupted_item8,item.enigmaticlegacy.cosmic_heart,item.aquamirae.abyssal_amethyst8,item.enigmaticlegacy.astral_fruit,item.enigmaticlegacy.ichor_bottle,item.enigmaticlegacy.void_pearl,item.irons_spellbooks.legendary_ink5,item.vp.stellar10,item.vp.stellar16,block.occultism.storage_stabilizer_tier4,item.vp.chaos_orb,block.minecraft.dragon_egg,item.twilightforest.charm_of_keeping_64,item.vp.box,item.vp.box_eggs2,item.vp.refresher,item.mythicbotany.alfsteel_ingot,block.alexscaves.tremorzilla_egg,item.enigmaticlegacy.soul_crystal,item.enigmaticlegacy.abyssal_heart,item.vp.vip,item.alexsmobs.warped_mixture>0.001<item.vp.chaos_orb64,item.vp.celestial_mirror,item.vp.pinky_pearl20,item.enigmaticlegacy.the_cube>";

        public Common(ForgeConfigSpec.Builder builder) {
            this.lore = builder.comment("Set false to disable chat messages with Lore").define("lore", true);
            this.vestigesCooldown = builder.comment("Cooldown in milliseconds for any Vestiges abilities. 100 is 0.1 sec.").defineInRange("vestigesCooldown", 50L, 0L, Long.MAX_VALUE);
            ArrayList<Integer> reduceList = new ArrayList<Integer>();
            for (int i = 0; i < PlayerCapabilityVP.totalVestiges; ++i) {
                reduceList.add(0);
            }
            this.reduceChallenges = builder.comment("Those are numbers for each Challenge to reduce their maximum").define("reduceChallenges", reduceList);
            this.reduceChallengesPercent = builder.comment("If true, numbers above for reducing Challenges maximum number will count as Percent from maximum").define("reduceChallengesPercent", false);
            ArrayList<Integer> scaleList = new ArrayList<Integer>();
            for (int i = 0; i < PlayerCapabilityVP.totalVestiges; ++i) {
                scaleList.add(10);
            }
            this.powerScale = builder.comment("Each Vestige Power Scale in percents.").define("powerScale", reduceList);
            this.powerBoost = builder.comment("Power Scale increase by completing new challenges.").defineInRange("powerBoost", 5.0, 1.0, 2.1E9);
            this.cruelMode = builder.comment("Enables Cruel mode: all bosses will have x4 hp, x2 damage, 100 armor, Shields and Over Shield, Healing, damage absorption 90%").define("cruelMode", false);
            this.bossHP = builder.comment("Cruel mode Hp scale").defineInRange("bossHP", 1.5, 1.0, 2.1E9);
            this.bossAttack = builder.comment("Cruel mode attack scale").defineInRange("bossAttack", 3.0, 1.0, 2.1E9);
            this.armorCruel = builder.comment("Cruel mode armor and armor toughness").defineInRange("armorCruel", 60, 1, 2100000000);
            this.damageCruel = builder.comment("Cruel mode damage percent from maximum hp when starving, drowning. Set 0 to disable.").defineInRange("damageCruel", 0.15, 0.0, 2.1E9);
            this.absorbCruel = builder.comment("Cruel mode DPS cap from max health %, 0.1 is 10%").defineInRange("absorbCruel", 0.4, 0.0, 2.147483647E9);
            this.shieldCruel = builder.comment("Cruel mode Shield from hp percent 1 is 100%").defineInRange("shieldCruel", 0.75, 0.1, 2.1E9);
            this.overShieldCruel = builder.comment("Cruel mode Over Shield from hp percent").defineInRange("overShieldCruel", 0.25, 0.1, 2.1E9);
            this.healPercent = builder.comment("Cruel mode Heal percent from max hp").defineInRange("healPercent", 0.005, 0.0, 2.1E9);
            this.expMultiplier = builder.comment("Exp base multiplier from bosses in Cruel mode").defineInRange("expMultiplier", 10.0, 1.0, 2.1E9);
            this.empoweredChance = builder.comment("Chance to spawn Empowered mob in Hardcore mode").defineInRange("empoweredChance", 0.01, 0.0, 2.1E9);
            this.healthBoost = builder.comment("Health Boost for all monsters in Cruel Mode. Leave at 1.0 to disable.").defineInRange("healthBoost", 2.0, 0.0, 2.1E9);
            this.nightmareBoxChance = builder.comment("Nightmare Bosses boxes chance 0.5 is 50%").defineInRange("nightmareAllBoxChance", 1.0, 0.0, 1.0);
            this.nightmareRefresherChance = builder.comment("Nightmare Bosses Refresher chance 0.1 is 10%").defineInRange("nightmareRefresherChance", 0.1, 0.0, 1.0);
            this.nightmareFrags = builder.comment("Nightmare Bosses max fragments").defineInRange("nightmareFrags", 26, 1, 2100000000);
            this.nightmareFragsMin = builder.comment("Nightmare Bosses min fragments").defineInRange("nightmareFragsMin", 13, 1, 2100000000);
            this.nightmareLoot = builder.comment("Nightmare Bosses max loot multiplier").defineInRange("nightmareLoot", 20, 1, 2100000000);
            this.nightmareLootMin = builder.comment("Nightmare Bosses min loot multiplier").defineInRange("nightmareLootMin", 10, 1, 2100000000);
            this.nightmareBoxes = builder.comment("Nightmare Bosses max boxes").defineInRange("nightmareBoxes", 8, 1, 2100000000);
            this.nightmareBoxesMin = builder.comment("Nightmare Bosses min boxes").defineInRange("nightmareBoxesMin", 4, 1, 2100000000);
            this.refresherChance = builder.comment("Chance for Refresher after completing Stellar challenge. 1 is 100%, 0.25 is 25%.").defineInRange("refresherChance", 0.25, 0.0, 1.0);
            this.cooldown = builder.comment("Challenge cooldown in hours").defineInRange("cooldown", 8, 0, 2100000000);
            this.stellarChanceIncrease = builder.comment("How many % of stellar chance will you get on failure").defineInRange("stellarChanceIncrease", 10, 0, 100);
            this.armorAbsorbPercent = builder.comment("Martyr's Habergeon Pain Gauge increase % from Ultimate. 1 is 100%, 0.1 is 10%.").defineInRange("armorAbsorbPercent", 0.5, 0.0, 2.147483647E9);
            this.anomalyBorder = builder.comment("Borders for Anomaly's Ultimate teleportation. Leave at 0 for world's max border.").defineInRange("anomalyBorder", 0, 0, Integer.MAX_VALUE);
            this.atlasChance = builder.comment("Chance for Atlas to gain Gravity. 1 is 100%, 0.2 is 20%.").defineInRange("atlasChance", 0.2, 0.0, 1.0);
            this.catalystLvlLimit = builder.comment("Level limit for stellar Catalyst").defineInRange("catalystLvlLimit", 255, 0, 255);
            this.catalystDeffence = builder.comment("How many debuffs can Catalyst absorb.").defineInRange("catalystDefence", 20, 0, Integer.MAX_VALUE);
            this.catSpeed = builder.comment("How many speed will Cat Ears give.").defineInRange("catSpeed", 1.0, 0.0, 10.0);
            this.catEvadeCap = builder.comment("Cap for Cat Ears evasion.").defineInRange("catEvadeCap", 69, 0, 100);
            this.chaosDamageCap = builder.comment("Damage cap for Chaos Core").defineInRange("chaosDamageCap", Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            this.chaosChance = builder.comment("Chance for Chaos Core reflexion or damage change. 1 is 100%, 0.1 is 10%.").defineInRange("chaosChance", 0.1, 0.0, 1.0);
            this.crownShield = builder.comment("How many % from enemy's health will crown give upon kill").defineInRange("crownShield", 50, 0, Integer.MAX_VALUE);
            this.devourerChance = builder.comment("Chance for Devourer's Ultimate per 1 kill. 1 is 100%, 0.001 is 0.1%").defineInRange("devourerChance", 0.01, 0.0, 100.0);
            this.flowerShield = builder.comment("Multiplier for Shield that will Flower give by Ultimate.").defineInRange("flowerShield", 1.0, 0.0, 2.147483647E9);
            this.killerRes = builder.comment("Killer Queens' Special explosion damage resistance shred").defineInRange("killerRes", 70.0, 0.0, 2.147483647E9);
            this.markMaximum = builder.comment("Maximum value of Cursed Mark Madness stacks").defineInRange("markMaximum", 10, 0, Integer.MAX_VALUE);
            this.markHealDebt = builder.comment("Heal debt of stellar Cursed Mark Ultimate in max health %").defineInRange("markHealDebt", 2000, 0, Integer.MAX_VALUE);
            this.maskRotAmount = builder.comment("Mask of Demon's Special hp consumption value in max health %").defineInRange("maskRotAmount", 10, 0, Integer.MAX_VALUE);
            this.midasChance = builder.comment("Chance for Midas getting luck from Ultimate per 1 gold nugget.").defineInRange("midasChance", 1.0E-4, 0.0, 1.0);
            this.prismChance = builder.comment("Prism loot chance multiplier").defineInRange("prismChance", 1.0, 0.0, 2.147483647E9);
            this.soulBlighterChance = builder.comment("Soul Blighter's Ultimate catch chance multiplier").defineInRange("soulBlighterChance", 1.0, 0.0, 2.147483647E9);
            this.soulBlighterHeal = builder.comment("Soul Blighter Over Shield heal multiplier").defineInRange("soulBlighterHeal", 1.0, 0.0, 2.147483647E9);
            this.trigonHeal = builder.comment("Trigon Over Shield heal multiplier").defineInRange("trigonHeal", 1.0, 0.0, 2.147483647E9);
            this.donutMaxSaturation = builder.comment("Sweet Donut max Saturation stacks.").defineInRange("donutMaxSaturation", 400, 0, Integer.MAX_VALUE);
            this.donutHealBonus = builder.comment("Base heal bonus of Sweet Donut.").defineInRange("donutHealBonus", 40, 0, Integer.MAX_VALUE);
            this.ballShield = builder.comment("How many Shield % will Ball Lightning reduce").defineInRange("ballShield", 0.1, 0.01, 1.0);
            this.ballDebuff = builder.comment("How much Shield Bonus will Ball Lightning reduce in percent").defineInRange("ballDebuff", 75.0, 0.0, 2.147483647E9);
            this.ballOverShield = builder.comment("How many OverShield % will Ball Lightning reduce").defineInRange("ballOverShield", 0.2, 0.01, 1.0);
            this.chaosCharges = builder.comment("Amount of Chaos Core reflection hits from Special").defineInRange("chaosCharges", 20, 1, Integer.MAX_VALUE);
            this.devourerCdTime = builder.comment("Devourer cooldown time between rotting hits. 1000 is 1 sec").defineInRange("devourerCdTime", 200L, 1L, Long.MAX_VALUE);
            this.markBonus = builder.comment("Amount of stats per Curse for Mark's Overdrive").defineInRange("markBonus", 10, 1, Integer.MAX_VALUE);
            this.devourer = builder.comment("How many hits can cause Soul Rotting from Devourer").defineInRange("devourer", 30, 0, 2100000000);
            this.blackhole = builder.comment("How many ticks must pass before Black Hole hits").defineInRange("blackhole", 4, 0, 2100000000);
            this.anomaly = builder.comment("Should anomaly teleport only living entities").define("anomaly", false);
            this.chaostime = builder.comment("Minutes before Chaos Core challenge reset").defineInRange("chaostime", 15, 1, 2100000000);
            this.eatingMinutes = builder.comment("Minutes for fish to fed up").defineInRange("eatingMinutes", 1, 1, 2100000000);
            this.bosses = builder.comment("additional bosses: ").define("bosses", (Object)"hullbreaker,tremorzilla,nucleeper,luxtructosaurus,atlatitan,forsaken,void_worm,");
            this.blacklistBosses = builder.comment("blacklist for bosses: ").define("blacklistBosses", (Object)"void_worm_part,");
            this.repairObjects = builder.comment("repairObjectsId: ").define("repairObjects", (Object)"mending,repair,unbreak,restore,heal,ingot");
            this.repairBlackList = builder.comment("repairBlackListId: ").define("repairBlackList", (Object)"");
            this.vortexReduction = builder.comment("Reduction of maximum amount needed for Vortex").defineInRange("vortexReduction", 0, 0, Integer.MAX_VALUE);
            this.easter = builder.comment("Enables Easter event").define("easter", false);
            this.easterChance = builder.comment("Additional chance for Easter Egg 10 is 10%").defineInRange("easterChance", 0, 0, Integer.MAX_VALUE);
            this.fishObjects = builder.comment("fishObjects: ").define("fishObjects", (Object)"fish,shell,pearl,boot,treasure,sunken,drown,lure,prismarin,water,ocean,coral,shark,whale,manta,rain,abyss,deep,sea,pirate,ship,bottle,wet,river");
            this.rareItems = builder.comment("Rare Items for fishing by Abyssal Pearl: ").define("rareItems", (Object)"item.vp.hearty_pearl,item.vp.seashell,abyssal_heart,ichor_bottle,boot");
            this.fishingBlacklist = builder.comment("Fishing Blacklist for Abyssal Pearl: ").define("fishingBlacklist", (Object)"item.vp.pearl");
            this.rareFishingDropChance = builder.comment("Chance of rare drop in current biome from Fishing with Pearl or by defending Silly Seashell.").defineInRange("rareFishingDropChance", 0.001, 0.0, 1.0);
            this.failFlowers = builder.comment("Fails flowers Challenge when they are being placed.").define("failFlowers", false);
            this.nightmareDpsCap = builder.comment("Damage per second cap for Nightmare Bosses in max hp % -> 0.01 is 1%").defineInRange("nightmareDpsCap", 0.01, 0.0, 3.4028234663852886E38);
            this.unlockHp = builder.comment("For servers with maxed out desync and hp lock to 2048 or if you just have problems with MaxHp.").define("unlockHp", false);
            this.eventMode = builder.comment("Event mode that disables all teleportations and fly.").define("eventMode", false);
            this.rareItemChance = builder.comment("Chance for Item to define as rare for Prism challenge. For example carrot has 0.025 chance to drop from zobmie").defineInRange("rareItemChance", 0.025, 1.0E-4, 1.0);
            this.debuffBlacklist = builder.comment("Defines blacklist for random potion effects as from Heirloom's Special: ").define("debuffBlacklist", (Object)"crystallized,");
            this.cloneBlackList = builder.comment("Defines blacklist for items that cannot be cloned with Celestial Mirror: ").define("cloneBlackList2", (Object)"bundle,pouch,bag,backpack,chest,box,pocket,store,storage,satchel,knapsack,cargo,vault,locker,crate,trunk,barrel,bin,safe,drawer,compartment,cache,case,basket,haversack,receptacle,container,ghostly_pickaxe,soul_gem,horse_flute,sack,broom,jar,bottle");
            this.cloneWhiteList = builder.comment("Defines whitelist for items that can be cloned with Celestial Mirror with highest priority. F.e. chestplate to not be blocked by chest in blacklist: ").define("cloneWhiteList", (Object)"chestplate,box_eggs,box_saplings,item.vp.box,item.vp.mystery_chest");
            this.mirrorUUIDList = builder.comment("List of existing mirrors UUID: ").define("mirrorUUIDList", (Object)"");
            this.dupersList = builder.comment("List of dupers: ").define("dupersList", (Object)"");
            this.leaderboardHost = builder.comment("Ip address for leaderboard: ").define("leaderboardHost", (Object)"");
            this.leaderboardPort = builder.comment("Ip port for leaderboard: ").define("leaderboardPort", (Object)"");
            this.leaderboard = builder.comment("Defines if Leaderboard should be enabled: ").define("leaderboard", false);
            this.chaosCoreStellarHpRes = builder.comment("Reduce modifier for Chaos Core Stellar ability of max hp lowering from Healing Debt").defineInRange("chaosCoreStellarHpRes", 10.0, 0.0, 2.1E9);
            this.oysterChance = builder.comment("Base chance for spawning Hungry Oyster per 8000 ticks").defineInRange("oysterChance", 0.05, 0.0, 1.0);
            this.seashellChance = builder.comment("Base chance for spawning Silly Seashell per 8000 ticks").defineInRange("seashellChance", 0.05, 0.0, 1.0);
            this.lootDrops = builder.comment("Loot tables for Mystery Chest common/rare/mystic/legendary. All chances are independent so 0.7(70% chance) on common cause dropping air in 30% cases.").define("lootDrops", (Object)DEFAULT_LOOT);
            this.strictOptimization = builder.comment("Enables strict optimization that may increase performance but break a lot of mechanics. WIP ").define("strictOptimization", false);
            this.mysteryChestAdvancementChance = builder.comment("Chance to obtain Mystery Chest from advancement").defineInRange("mysteryChestAdvancementChance", 0.01, 0.0, 1.0);
            this.mysteryChestAdvancementBoost = builder.comment("Chance increase per each advancement").defineInRange("mysteryChestAdvancementBoost", 5.0E-4, 0.0, 1.0);
            this.mysteryChestChallengeChance = builder.comment("Chance to obtain Mystery Chest from challenge").defineInRange("mysteryChestChallengeChance", 0.33, 0.0, 1.0);
            this.mineralCluster = builder.comment("Id of items that drop of Mineral Cluster should contain: ").define("mineralClusterList", (Object)"_gem_,mineral,diamond,emerald,jadeite,quartz,feldspar,mica,fluorite,halite,gypsum,_talc,graphite,pyrite,_galena,hematite,magnetite,bauxite,corundum,sapphire,ruby,topaz,amethyst,citrine,agate,jasper,opal,garnet,zircon,olivine,tourmaline,beryl,aquamarine,biotite,muscovite,orthoclase,plagioclase,amphibole,pyroxene,apatite,barite,sulfur,malachite,azurite,bornite,chalcopyrite,sphalerite,cassiterite,rutile,ilmenite,chromite,kaolinite,serpentine,epidote,staurolite,kyanite,andalusite,sillimanite");
            this.mineralClusterBlacklist = builder.comment("Black list for items in Mineral Cluster: ").define("mineralClusterBlacklist", (Object)"");
            this.anomalyPlayerTeleportChance = builder.comment("Chance to teleport to random player on the server from Teleportation Anomaly's Stellar Ultimate").defineInRange("anomalyPlayerTeleportChance", 0.05, 0.0, 1.0);
        }

        public int getChallengeReduceByNumber(int number) {
            return (Integer)((List)this.reduceChallenges.get()).get(number - 1);
        }

        public int powerScale(int number) {
            return (Integer)((List)this.powerScale.get()).get(number);
        }
    }
}

