/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.util;

import com.pyding.vp.util.LeaderboardUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="vp")
public class GradientUtil {
    public static final int[] RAINBOW_COLORS = new int[]{16098424, 16104851, 16770244, 8087790, 9662683, 9109759, 6950317, 4525647, 6950317, 9109759, 9662683, 8087790, 16770244, 16104851, 16098424};
    public static final int[] GOLD_TO_WHITE = new int[]{16775910, 16775382, 16774064, 16772490, 16770396, 16766720, 16770396, 16772490, 16774064, 16775382, 16775910, 0xFFFFFF};
    public static final int[] PURPLE_DARK_PURPLE = new int[]{4922221, 5908090, 6960520, 8078485, 9262499, 10446768, 11696829, 12947146, 14197718, 12947146, 11696829, 10446768, 9262499, 8078485, 6960520, 5908090, 4922221};
    public static final int[] BLUE_LIGHT_BLUE = new int[]{139, 205, 255, 2003199, 49151, 8900331, 8900346, 11393254, 0xE0FFFF, 11393254, 8900346, 8900331, 49151, 2003199, 255, 205, 139};
    public static final int[] MYSTERY = new int[]{14725375, 13736942, 12748765, 11760588, 10772411, 9784234, 8796057, 7807880, 6819703, 5832806, 4849749, 3866692, 2883635, 1900578, 1703984, 8192, 12288, 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, 61440, 65280, 61440, 57344, 53248, 49152, 45056, 40960, 36864, 32768, 28672, 24576, 20480, 16384, 12288, 8192, 1703984, 2883635, 3866692, 4849749, 5832806, 6819703, 7807880, 8796057, 9784234, 10772411, 11760588, 12748765, 13736942, 14725375};

    @SubscribeEvent
    public static void onServerChat(ServerChatEvent event) {
        ServerPlayer player;
        if (event.getPlayer() != null && LeaderboardUtil.hasGoldenName((player = event.getPlayer()).m_20148_())) {
            String originalText = event.getMessage().getString();
            Component gradientMessage = GradientUtil.goldenGradient(originalText);
            event.setMessage(gradientMessage);
        }
    }

    public static Component goldenGradient(String message) {
        MutableComponent result = Component.m_237119_();
        int length = message.length();
        if (length == 0) {
            return result;
        }
        long time = System.currentTimeMillis();
        float progress = (float)(time % 1000L) / 1000.0f;
        for (int i = 0; i < length; ++i) {
            char c = message.charAt(i);
            float t = (float)i / (float)(length - 1);
            float animatedT = (t + progress) % 1.0f;
            int color = GradientUtil.getRainbowColor(animatedT, GOLD_TO_WHITE);
            result.m_7220_((Component)Component.m_237113_((String)String.valueOf(c)).m_130948_(Style.f_131099_.m_178520_(color)));
        }
        return result;
    }

    public static Component stellarGradient(String message) {
        MutableComponent result = Component.m_237119_();
        int length = message.length();
        if (length == 0) {
            return result;
        }
        long time = System.currentTimeMillis();
        float progress = (float)(time % 1000L) / 1000.0f;
        for (int i = 0; i < length; ++i) {
            char c = message.charAt(i);
            float t = (float)i / (float)(length - 1);
            float animatedT = (t + progress) % 1.0f;
            int color = GradientUtil.getRainbowColor(animatedT, RAINBOW_COLORS);
            result.m_7220_((Component)Component.m_237113_((String)String.valueOf(c)).m_130948_(Style.f_131099_.m_178520_(color)));
        }
        return result;
    }

    public static Component customGradient(String message, int[] colors) {
        MutableComponent result = Component.m_237119_();
        int length = message.length();
        if (length == 0) {
            return result;
        }
        long time = System.currentTimeMillis();
        float progress = (float)(time % 1000L) / 1000.0f;
        for (int i = 0; i < length; ++i) {
            char c = message.charAt(i);
            float t = (float)i / (float)(length - 1);
            float animatedT = (t + progress) % 1.0f;
            int color = GradientUtil.getRainbowColor(animatedT, colors);
            result.m_7220_((Component)Component.m_237113_((String)String.valueOf(c)).m_130948_(Style.f_131099_.m_178520_(color)));
        }
        return result;
    }

    private static int getRainbowColor(float t, int[] colors) {
        int colorCount = colors.length;
        float segment = 1.0f / (float)(colorCount - 1);
        int index1 = (int)(t / segment);
        int index2 = (index1 + 1) % colorCount;
        float localT = t % segment / segment;
        return GradientUtil.interpolateColor(colors[index1], colors[index2], localT);
    }

    public static int interpolateColor(int start, int end, float t) {
        int r1 = start >> 16 & 0xFF;
        int g1 = start >> 8 & 0xFF;
        int b1 = start & 0xFF;
        int r2 = end >> 16 & 0xFF;
        int g2 = end >> 8 & 0xFF;
        int b2 = end & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return r << 16 | g << 8 | b;
    }
}

