/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.client;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.util.ClientConfig;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NightmareScreen
extends Screen {
    private static final ResourceLocation FRAME = new ResourceLocation("vp", "textures/gui/frame.png");
    private static final ResourceLocation SHARD = new ResourceLocation("vp", "textures/item/shard.png");
    private static final ResourceLocation NIGHTMARE_SHARD = new ResourceLocation("vp", "textures/item/nightmare_shard.png");
    int page = 1;
    int maxPages = 8;

    public NightmareScreen() {
        super((Component)Component.m_237119_());
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonSize = 32;
        int padding = 5;
        int center = this.f_96543_ / 2 - buttonSize / 2;
        int top = this.f_96544_ - padding - buttonSize;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ImageButton nextPage = new ImageButton(center + (buttonSize - padding) * 2, top - this.f_96544_ / 8, buttonSize, buttonSize, 0, 0, 0, new ResourceLocation("vp", "textures/gui/point_r.png"), buttonSize, buttonSize, button -> {
            this.page = Math.min(this.maxPages, this.page + 1);
            player.m_20193_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistry.BOOK_PAGE1.get(), SoundSource.RECORDS, 1.0f, 1.0f, false);
        });
        ImageButton prevPage = new ImageButton(center - (buttonSize - padding) * 2, top - this.f_96544_ / 8, buttonSize, buttonSize, 0, 0, 0, new ResourceLocation("vp", "textures/gui/point_l.png"), buttonSize, buttonSize, button -> {
            this.page = Math.max(1, this.page - 1);
            player.m_20193_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistry.BOOK_PAGE1.get(), SoundSource.RECORDS, 1.0f, 1.0f, false);
        });
        this.m_142416_((GuiEventListener)nextPage);
        this.m_142416_((GuiEventListener)prevPage);
        int right = this.f_96543_ - padding - buttonSize;
        ImageButton zoomInButton = new ImageButton(right - buttonSize - padding, top, buttonSize, buttonSize, 0, 0, 0, new ResourceLocation("vp", "textures/gui/zoom-in.png"), buttonSize, buttonSize, button -> ClientConfig.COMMON.guiScaleGuide.set((Object)Math.min(2.0, (Double)ClientConfig.COMMON.guiScaleGuide.get() + 0.1)));
        ImageButton zoomOutButton = new ImageButton(right, top, buttonSize, buttonSize, 0, 0, 0, new ResourceLocation("vp", "textures/gui/zoom-out.png"), buttonSize, buttonSize, button -> ClientConfig.COMMON.guiScaleGuide.set((Object)Math.max(0.1, (Double)ClientConfig.COMMON.guiScaleGuide.get() - 0.1)));
        this.m_142416_((GuiEventListener)zoomInButton);
        this.m_142416_((GuiEventListener)zoomOutButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        double scale = (Double)ClientConfig.COMMON.guiScaleGuide.get();
        int infoWidth = (int)(512.0 * scale);
        int infoHeight = (int)(512.0 * scale);
        int infoPadding = (int)(60.0 * scale);
        Font font = this.f_96547_;
        int x = this.f_96543_ / 2 - infoWidth / 2;
        int y = this.f_96544_ / 2 - infoHeight / 2;
        guiGraphics.m_280163_(FRAME, x, y, 0.0f, 0.0f, infoWidth, infoHeight, infoWidth, infoHeight);
        MutableComponent comp = Component.m_237115_((String)("vp.nightmare." + (this.page - 1)));
        List lines = font.m_92923_((FormattedText)comp, infoWidth - 2 * infoPadding);
        for (int lineIndex = 0; lineIndex < lines.size(); ++lineIndex) {
            int textX = x + infoPadding + infoWidth / 25;
            Objects.requireNonNull(font);
            int textY = y + infoPadding + lineIndex * 9 + infoHeight / 6;
            guiGraphics.m_280648_(font, (FormattedCharSequence)lines.get(lineIndex), textX, textY, ChatFormatting.GRAY.m_126665_().intValue());
        }
        if (this.page == 1) {
            int size = (int)(64.0 * scale);
            int xPos = this.f_96543_ / 2 - size / 2;
            int yPos = this.f_96544_ / 2 - size / 2 + infoHeight / 4;
            guiGraphics.m_280163_(SHARD, xPos - size, yPos, 0.0f, 0.0f, size, size, size, size);
            guiGraphics.m_280163_(NIGHTMARE_SHARD, xPos + size, yPos, 0.0f, 0.0f, size, size, size, size);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 69 || keyCode == 87 || keyCode == 65 || keyCode == 83 || keyCode == 68 || keyCode == 256 || keyCode == 32) {
            this.m_7379_();
            return true;
        }
        return true;
    }

    public void m_7379_() {
        super.m_7379_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        player.m_20193_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistry.BOOK_CLOSE.get(), SoundSource.RECORDS, 1.0f, 1.0f, false);
    }
}

