/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.pyding.vp.item.Vortex;
import com.pyding.vp.util.ClientConfig;
import com.pyding.vp.util.VPUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VortexScreen
extends Screen {
    private float time;
    private static final ResourceLocation COMMON_TEXTURE = new ResourceLocation("vp", "textures/item/common.png");
    private static final ResourceLocation RARE_TEXTURE = new ResourceLocation("vp", "textures/item/rare.png");
    private static final ResourceLocation MYTHIC_TEXTURE = new ResourceLocation("vp", "textures/item/mythic.png");
    private static final ResourceLocation LEGENDARY_TEXTURE = new ResourceLocation("vp", "textures/item/legendary.png");
    int startY = 0;
    private Button zoomInButton;
    private Button zoomOutButton;

    public VortexScreen() {
        super((Component)Component.m_237119_());
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonSize = 32;
        int padding = 5;
        int right = this.f_96543_ - padding - buttonSize;
        int top = this.f_96544_ - padding - buttonSize;
        this.zoomInButton = new ImageButton(right - buttonSize - padding, top, buttonSize, buttonSize, 0, 0, 0, new ResourceLocation("vp", "textures/gui/zoom-in.png"), buttonSize, buttonSize, button -> ClientConfig.COMMON.guiScaleVortex.set((Object)Math.min(2.0, (Double)ClientConfig.COMMON.guiScaleVortex.get() + 0.1)));
        this.zoomOutButton = new ImageButton(right, top, buttonSize, buttonSize, 0, 0, 0, new ResourceLocation("vp", "textures/gui/zoom-out.png"), buttonSize, buttonSize, button -> ClientConfig.COMMON.guiScaleVortex.set((Object)Math.max(0.1, (Double)ClientConfig.COMMON.guiScaleVortex.get() - 0.1)));
        this.m_142416_((GuiEventListener)this.zoomInButton);
        this.m_142416_((GuiEventListener)this.zoomOutButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.time += partialTicks * 0.05f;
        float scaleMultiplier = (float)((Double)ClientConfig.COMMON.guiScaleVortex.get() + 0.0);
        float scale = 1.5f * scaleMultiplier;
        int scaledItemSize = (int)(16.0f * scale);
        int itemSpacing = (int)((float)(scaledItemSize + 2) * scale);
        int lineSpacing = (int)((float)(scaledItemSize * 2 + 2) * scale);
        int textOffsetY = (int)(20.0f * scale);
        int startX = scaledItemSize;
        this.startY = scaledItemSize;
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        this.renderCategory(guiGraphics, "Items for Vortex:", ChatFormatting.GRAY, Vortex.getItems(), startX, this.startY, screenWidth, scaledItemSize, itemSpacing, lineSpacing, textOffsetY, scale, "common");
        this.startY += 15;
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void renderCategory(GuiGraphics guiGraphics, String title, ChatFormatting color, List<ItemStack> items, int startX, int startY, int screenWidth, int itemSize, int itemSpacing, int lineSpacing, int textOffsetY, float scale, String rarity) {
        Font font = Minecraft.m_91087_().f_91062_;
        int currentX = startX;
        int currentY = startY + (int)(10.0f * scale);
        int maxInRow = (screenWidth - startX - itemSize) / (itemSize + itemSpacing);
        guiGraphics.m_280488_(font, title, startX, startY, color.m_126665_().intValue());
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = items.get(i);
            if (i > 0 && i % maxInRow == 0) {
                currentX = startX;
                currentY += lineSpacing;
            }
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)currentX, (float)currentY, 100.0f);
            poseStack.m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280480_(stack, 0, 0);
            poseStack.m_85849_();
            VortexScreen.renderBack(guiGraphics, (float)currentX + (float)itemSize / 2.0f, (float)currentY + (float)itemSize / 2.0f, 0.0f, rarity, this.time, scale / 2.0f, itemSize);
            Component name = VPUtil.filterAndTranslate(stack.m_41778_(), color);
            int maxWidth = (int)((float)(itemSpacing - 8) * scale);
            List lines = font.m_92923_((FormattedText)name, maxWidth);
            int textY = currentY + textOffsetY;
            for (FormattedCharSequence line : lines) {
                int textX = currentX + itemSize / 2 - font.m_92724_(line) / 2;
                guiGraphics.m_280648_(font, line, textX, textY, color.m_126665_().intValue());
                Objects.requireNonNull(font);
                textY += 9 + 2;
            }
            String count = "x" + stack.m_41613_();
            int countX = currentX + itemSize / 2 - font.m_92895_(count) / 2;
            guiGraphics.m_280488_(font, count, countX, textY, color.m_126665_().intValue());
            currentX += itemSize + itemSpacing;
        }
        this.startY = currentY;
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public static void renderBack(GuiGraphics guiGraphics, float centerX, float centerY, float zOffset, String rarity, float time, float baseScale, int size) {
        ResourceLocation texture = switch (rarity) {
            case "legendary" -> LEGENDARY_TEXTURE;
            case "mythic" -> MYTHIC_TEXTURE;
            case "rare" -> RARE_TEXTURE;
            default -> COMMON_TEXTURE;
        };
        PoseStack poseStack = guiGraphics.m_280168_();
        float scale = baseScale + Mth.m_14031_((float)(time * (float)Math.PI * 3.0f)) * 0.2f;
        float alpha = 1.0f + Mth.m_14031_((float)(time * (float)Math.PI * 3.0f)) * 0.3f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        poseStack.m_85836_();
        poseStack.m_252880_(centerX, centerY, zOffset);
        poseStack.m_85841_(scale, scale, 1.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(time * 240.0f));
        guiGraphics.m_280163_(texture, -size / 2, -size / 2, 0.0f, 0.0f, size, size, size, size);
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 69 || keyCode == 87 || keyCode == 65 || keyCode == 83 || keyCode == 68 || keyCode == 256 || keyCode == 32) {
            this.m_7379_();
            return true;
        }
        return true;
    }
}

