/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item;

import com.pyding.vp.capability.PlayerCapabilityProviderVP;
import com.pyding.vp.client.MysteryChestScreen;
import com.pyding.vp.client.MysteryDropScreen;
import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.VPUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MysteryChest
extends Item {
    public static List<ItemStack> commonItems = new ArrayList<ItemStack>();
    public static List<ItemStack> rareItems = new ArrayList<ItemStack>();
    public static List<ItemStack> mythicItems = new ArrayList<ItemStack>();
    public static List<ItemStack> legendaryItems = new ArrayList<ItemStack>();
    public static double commonChance = 0.0;
    public static double rareChance = 0.0;
    public static double mythicChance = 0.0;
    public static double legendaryChance = 0.0;
    public static int hold = 0;

    public MysteryChest(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public MysteryChest() {
        super(new Item.Properties().m_41487_(64));
    }

    public static void init() {
        String list = ConfigHandler.COMMON.lootDrops.get().toString();
        String[] segments = list.split(">");
        commonChance = Double.parseDouble(segments[0].split("<")[0]);
        rareChance = Double.parseDouble(segments[1].split("<")[0]);
        mythicChance = Double.parseDouble(segments[2].split("<")[0]);
        legendaryChance = Double.parseDouble(segments[3].split("<")[0]);
        commonItems.clear();
        rareItems.clear();
        mythicItems.clear();
        legendaryItems.clear();
        block0: for (Item item : VPUtil.getItems()) {
            List<String> cringe;
            boolean stop = false;
            boolean strictOptimization = VPUtil.strictOptimization();
            for (String id : segments[0].split("<")[1].split(",")) {
                cringe = MysteryChest.processString(id);
                if (!item.m_5524_().equals(cringe.get(0))) continue;
                commonItems.add(new ItemStack((ItemLike)item, Math.max(1, Integer.parseInt(cringe.get(1)))));
                stop = true;
                break;
            }
            if (stop && strictOptimization) continue;
            for (String id : segments[1].split("<")[1].split(",")) {
                cringe = MysteryChest.processString(id);
                if (!item.m_5524_().equals(cringe.get(0))) continue;
                rareItems.add(new ItemStack((ItemLike)item, Math.max(1, Integer.parseInt(cringe.get(1)))));
                stop = true;
                break;
            }
            if (stop && strictOptimization) continue;
            for (String id : segments[2].split("<")[1].split(",")) {
                cringe = MysteryChest.processString(id);
                if (!item.m_5524_().equals(cringe.get(0))) continue;
                mythicItems.add(new ItemStack((ItemLike)item, Math.max(1, Integer.parseInt(cringe.get(1)))));
                stop = true;
                break;
            }
            if (stop && strictOptimization) continue;
            for (String id : segments[3].split("<")[1].split(",")) {
                cringe = MysteryChest.processString(id);
                if (!item.m_5524_().equals(cringe.get(0))) continue;
                legendaryItems.add(new ItemStack((ItemLike)item, Math.max(1, Integer.parseInt(cringe.get(1)))));
                continue block0;
            }
        }
    }

    public static List<String> processString(String input) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(\\d+)$");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            list.add(input.substring(0, matcher.start(1)));
            list.add(matcher.group(1));
        } else {
            list.add(input);
            list.add("1");
        }
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand p_41434_) {
        if (p_41434_ != InteractionHand.MAIN_HAND || !level.f_46443_) {
            return super.m_7203_(level, player, p_41434_);
        }
        Minecraft.m_91087_().m_91152_((Screen)new MysteryChestScreen());
        player.m_20193_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistry.CHEST_FALL.get(), SoundSource.MASTER, 1.0f, 1.0f, false);
        return super.m_7203_(level, player, p_41434_);
    }

    public static Map<ItemStack, String> getRandomDrop() {
        if (commonItems.isEmpty() || rareItems.isEmpty() || mythicItems.isEmpty() || legendaryItems.isEmpty()) {
            MysteryChest.init();
        }
        for (ItemStack itemStack : commonItems) {
            if (itemStack.m_41613_() != 0 && !itemStack.m_150930_(Items.f_41852_)) continue;
            MysteryChest.init();
            break;
        }
        for (ItemStack itemStack : rareItems) {
            if (itemStack.m_41613_() != 0 && !itemStack.m_150930_(Items.f_41852_)) continue;
            MysteryChest.init();
            break;
        }
        for (ItemStack itemStack : mythicItems) {
            if (itemStack.m_41613_() != 0 && !itemStack.m_150930_(Items.f_41852_)) continue;
            MysteryChest.init();
            break;
        }
        for (ItemStack itemStack : legendaryItems) {
            if (itemStack.m_41613_() != 0 && !itemStack.m_150930_(Items.f_41852_)) continue;
            MysteryChest.init();
            break;
        }
        HashMap<ItemStack, String> map = new HashMap<ItemStack, String>();
        Random random = new Random();
        double randomNumber = random.nextDouble();
        if (randomNumber <= legendaryChance) {
            map.put(legendaryItems.get(random.nextInt(legendaryItems.size())), "legendary");
        } else if (randomNumber <= mythicChance) {
            map.put(mythicItems.get(random.nextInt(mythicItems.size())), "mythic");
        } else if (randomNumber <= rareChance) {
            map.put(rareItems.get(random.nextInt(rareItems.size())), "rare");
        } else if (randomNumber <= commonChance) {
            map.put(commonItems.get(random.nextInt(commonItems.size())), "common");
        } else {
            map.put(new ItemStack((ItemLike)Items.f_41852_), "common");
        }
        return map;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        if (!stack.m_41782_()) {
            stack.m_41784_().m_128405_("VPOpen", 0);
        }
        if (Screen.m_96638_()) {
            if (commonItems.isEmpty() || rareItems.isEmpty() || mythicItems.isEmpty() || legendaryItems.isEmpty()) {
                MysteryChest.init();
            }
            for (ItemStack itemStack : commonItems) {
                if (itemStack.m_41613_() != 0 && !itemStack.m_150930_(Items.f_41852_)) continue;
                MysteryChest.init();
                break;
            }
            for (ItemStack itemStack : rareItems) {
                if (itemStack.m_41613_() != 0 && !itemStack.m_150930_(Items.f_41852_)) continue;
                MysteryChest.init();
                break;
            }
            for (ItemStack itemStack : mythicItems) {
                if (itemStack.m_41613_() != 0 && !itemStack.m_150930_(Items.f_41852_)) continue;
                MysteryChest.init();
                break;
            }
            for (ItemStack itemStack : legendaryItems) {
                if (itemStack.m_41613_() != 0 && !itemStack.m_150930_(Items.f_41852_)) continue;
                MysteryChest.init();
                break;
            }
            components.add((Component)Component.m_237113_((String)((hold += 2) + "/100")).m_130940_(ChatFormatting.GRAY));
            if (hold >= 100) {
                Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_((Screen)new MysteryDropScreen()));
                hold = 0;
            }
        } else if (Screen.m_96637_()) {
            Minecraft.m_91087_().f_91074_.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> components.add((Component)Component.m_237110_((String)"vp.mystery.desc3", (Object[])new Object[]{((Double)ConfigHandler.COMMON.mysteryChestAdvancementChance.get() + (Double)ConfigHandler.COMMON.mysteryChestAdvancementBoost.get() * (double)cap.getAdvancements()) * 100.0 + "%", (Double)ConfigHandler.COMMON.mysteryChestAdvancementBoost.get() * 100.0 + "%", (Double)ConfigHandler.COMMON.mysteryChestChallengeChance.get() * 100.0 + "%"}).m_130940_(ChatFormatting.GRAY)));
        } else {
            components.add((Component)Component.m_237115_((String)"vp.mystery.desc").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"vp.mystery.desc2").m_130940_(ChatFormatting.GRAY));
        }
        if (hold > 0) {
            --hold;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerChick() {
        ItemProperties.register((Item)this, (ResourceLocation)new ResourceLocation("vp", "open"), (stack, world, entity, number) -> stack.m_41784_().m_128451_("VPOpen"));
    }
}

