/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.VPUtil;
import com.pyding.vp.util.Vector3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class Archlinx
extends Vestige {
    public static List<UUID> archUUIDs = Arrays.asList(UUID.fromString("d2850e71-4de0-46b4-baeb-0ba28fdc54a5"), UUID.fromString("f0a7a122-3f55-4d8f-a18c-31520f849f63"), UUID.fromString("9dcf47de-6a44-4dd7-a1b7-7cd9a7f42114"), UUID.fromString("4ec6182d-4af2-4b67-bd0e-c3a60a826cb2"), UUID.fromString("f6e8c51e-68d9-4e0b-b8d9-b05f7b1c9b9b"), UUID.fromString("c41b8a9b-23f0-4e08-b7e2-64f5178beff8"), UUID.fromString("0a1f0d5e-7ff4-4c64-99cd-9acda29416d6"), UUID.fromString("35727d98-1b21-453e-9e75-fcae1173e0b7"), UUID.fromString("6d96373c-02e7-4933-9734-7b5b1d35df10"), UUID.fromString("e7032e0f-f9aa-409b-a28a-6318e358964a"), UUID.fromString("02491729-4d26-4f7b-bd90-cdd2b1c3d4ea"));

    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(25, ChatFormatting.BLUE, 2, 25, 1, 275, 120, 9999, true, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        Random random = new Random();
        if (random.nextDouble() < 0.5) {
            VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.ARROW_READY_1.get());
        } else {
            VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.ARROW_READY_2.get());
        }
        VPUtil.spawnSphere((Entity)player, (ParticleOptions)ParticleTypes.f_175821_, 35, 1.5f, 0.2f);
        player.getPersistentData().m_128405_("VPArchShots", 5);
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public int setUltimateActive(long seconds, Player player, ItemStack stack) {
        if (this.isUltimateActive(stack) && !player.m_20193_().f_46443_) {
            if (this.currentChargeUltimate(stack) > 0) {
                if (!player.m_20193_().f_46443_) {
                    this.setTimeUlt(1L, stack);
                    this.setUltimateActive(true, stack);
                    Random random = new Random();
                    if (VPUtil.getSet(player) != 3 || !(random.nextDouble() < VPUtil.getChance(0.3, player)) || VPUtil.getSet(player) != 6 || !(random.nextDouble() < VPUtil.getChance(0.5, player)) || random.nextDouble() < VPUtil.getChance(player.getPersistentData().m_128457_("VPDepth") / 10.0f, player)) {
                        this.setCurrentChargeUltimate(this.currentChargeUltimate(stack) - 1, stack);
                    }
                    long bonus = 1L + (long)player.getPersistentData().m_128457_("VPDurationBonusDonut") / 1000L;
                    if (this.damageType == null) {
                        this.init(stack);
                    }
                    this.doUltimate(seconds * bonus, player, player.m_20193_(), stack);
                } else {
                    this.localSpecial(player);
                }
            }
            return 0;
        }
        return super.setUltimateActive(seconds, player, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.MAGIC_ARROW_1.get());
        VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123808_, 3.0, 1, 0.0, 0.1, 0.0, 0.7, 0.5, 1.0);
        super.doUltimate(seconds, player, level, stack);
    }

    @Override
    public void ultimateEnds(Player player, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.MAGIC_ARROW_2.get());
        float damage = player.getPersistentData().m_128451_("VPArchdamage");
        double range = 6.0;
        Vector3 target = Vector3.fromEntityCenter((Entity)player);
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        for (int distance = 1; distance < 50; ++distance) {
            target = target.add(new Vector3(player.m_20154_()).multiply(distance)).add(0.0, 0.5, 0.0);
            VPUtil.spawnParticles((Entity)player, (ParticleOptions)ParticleTypes.f_175826_, target.x, target.y, target.z, 10, 0.0, 0.0, 0.0);
            List list = player.m_20193_().m_45976_(LivingEntity.class, new AABB(target.x - range, target.y - range, target.z - range, target.x + range, target.y + range, target.z + range));
            list.removeIf(entity -> entity == player || !player.m_142582_((Entity)entity));
            for (LivingEntity entity2 : list) {
                if (entities.contains(entity2)) continue;
                entities.add(entity2);
                if (VPUtil.isProtectedFromHit(player, (Entity)entity2)) continue;
                VPUtil.spawnSphere((Entity)entity2, (ParticleOptions)ParticleTypes.f_175826_, 20, 2.0f, 0.4f);
                VPUtil.dealDamage(entity2, player, player.m_269291_().m_269104_((Entity)player, (Entity)player), VPUtil.scalePower(damage, 25, player), 3, true);
                VPUtil.addRadiance(((Object)((Object)this)).getClass(), VPUtil.getRadianceUltimate(), player);
            }
        }
        player.getPersistentData().m_128350_("VPArchdamage", 0.0f);
        super.ultimateEnds(player, stack);
    }

    @Override
    public void curioSucks(Player player, ItemStack stack) {
        Archlinx.removeModifiers(player);
        super.curioSucks(player, stack);
    }

    public static void removeModifiers(Player player) {
        AttributeMap map = player.m_21204_();
        List<Attribute> list = VPUtil.attributeList();
        for (int i = 0; i < list.size(); ++i) {
            if (!map.m_22171_(list.get(i))) continue;
            player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, list.get(i), archUUIDs.get(i), 0.0f, AttributeModifier.Operation.ADDITION, "vp:arch" + list.get(i).m_22087_()));
        }
    }
}

