/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.VPUtil;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class Midas
extends Vestige {
    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(9, ChatFormatting.GOLD, 1, 40, 1, 320, 40, 1, hasDamage, stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player player, InteractionHand p_41434_) {
        ItemStack stack = player.m_21205_();
        int kills = stack.m_41784_().m_128451_("VPKills");
        if (kills != 0) {
            if (player.m_6144_()) {
                if (kills > 81) {
                    player.m_36356_(new ItemStack((ItemLike)Items.f_41912_, 1));
                    stack.m_41784_().m_128350_("VPKills", (float)(kills - 81));
                }
            } else if (kills > 9) {
                player.m_36356_(new ItemStack((ItemLike)Items.f_42417_, 1));
                stack.m_41784_().m_128350_("VPKills", (float)(kills - 9));
            }
        }
        return super.m_7203_(p_41432_, player, p_41434_);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.MAGIC1.get());
        player.getPersistentData().m_128350_("VPMidasTouch", 10.0f);
        VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_175827_, 8.0, 1, 0.0, -0.1, 0.0, 1.0, false);
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_175827_, 8.0, 1, 0.0, -0.1, 0.0, 1.0, false);
        int kills = stack.m_41784_().m_128451_("VPKills");
        Random random = new Random();
        if (random.nextDouble() < VPUtil.getChance((Double)ConfigHandler.COMMON.midasChance.get() * (double)kills, player)) {
            stack.m_41784_().m_128405_("VPLuck", stack.m_41784_().m_128451_("VPLuck") + 1);
            VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.SUCCESS.get());
        } else {
            VPUtil.play((LivingEntity)player, SoundEvents.f_12059_);
        }
        while (kills > 0 && Midas.isStellar(stack)) {
            if (kills > 729) {
                player.m_36356_(new ItemStack((ItemLike)Items.f_41912_, 9));
                kills -= 729;
                continue;
            }
            if (kills > 81) {
                player.m_36356_(new ItemStack((ItemLike)Items.f_41912_, 1));
                kills -= 81;
                continue;
            }
            if (kills > 9) {
                player.m_36356_(new ItemStack((ItemLike)Items.f_42417_, 1));
                kills -= 9;
                continue;
            }
            player.m_36356_(new ItemStack((ItemLike)Items.f_42587_, 1));
            --kills;
        }
        stack.m_41784_().m_128405_("VPKills", 0);
        super.doUltimate(seconds, player, level, stack);
    }

    private Multimap<Attribute, AttributeModifier> createAttributeMap(ItemStack stack, Player player) {
        HashMultimap attributesDefault = HashMultimap.create();
        int luck = VPUtil.scalePower(stack.m_41784_().m_128451_("VPLuck"), 9, player);
        attributesDefault.put((Object)Attributes.f_22286_, (Object)new AttributeModifier(UUID.fromString("f55f3429-0399-4d9e-9f84-0d7156cc0593"), "vp:luck", (double)luck, AttributeModifier.Operation.ADDITION));
        return attributesDefault;
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player = (Player)slotContext.entity();
        if (player.f_19797_ % 20 == 0) {
            player.m_21204_().m_22178_(this.createAttributeMap(stack, player));
        }
        if (!this.isSpecialActive(stack)) {
            player.getPersistentData().m_128350_("VPMidasTouch", 0.0f);
        }
        super.curioTick(slotContext, stack);
    }
}

