/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.VPUtil;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class Trigon
extends Vestige {
    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(19, ChatFormatting.GOLD, 3, 13, 1, 135, 1, 1, true, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.MAGIC5.get());
        for (LivingEntity entity : VPUtil.ray(player, 6.0f, 30, true)) {
            if (VPUtil.isProtectedFromHit(player, (Entity)entity)) continue;
            VPUtil.dealParagonDamage(entity, player, VPUtil.scalePower(player.m_21233_() / 10.0f, 19, player), 2, true);
            VPUtil.addRadiance(Trigon.class, VPUtil.getRadianceSpecial(), player);
        }
        VPUtil.rayParticles(player, (ParticleOptions)ParticleTypes.f_175828_, 30.0, 3.0, 30, 0.0, -0.5, 0.0, 1.0, false);
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.TRIGON2.get());
        float overshields = 0.0f;
        List<LivingEntity> list = VPUtil.getEntities(player, 30.0, true);
        Random random = new Random();
        for (LivingEntity entity : list) {
            float shield = VPUtil.getShield(entity);
            overshields += shield * 0.3f;
            entity.getPersistentData().m_128350_("VPShield", shield * 0.6f);
            VPUtil.spawnParticles((Entity)player, (ParticleOptions)ParticleTypes.f_175828_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 8, 0.0, -0.5, 0.0);
        }
        int numba = random.nextInt(list.size());
        if (Trigon.isStellar(stack) && VPUtil.getOverShield((LivingEntity)player) > 0.0f && player.getPersistentData().m_128457_("VPOverShieldMax") > 0.0f) {
            float amount = 1.0f + (1.0f - VPUtil.getOverShield((LivingEntity)player) / player.getPersistentData().m_128457_("VPOverShieldMax")) / 2.0f;
            player.m_21204_().m_22178_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22276_, UUID.fromString("8dac9436-c37f-4b74-bf64-8666258605b9"), VPUtil.scalePower(amount, 19, player), AttributeModifier.Operation.MULTIPLY_TOTAL, "vp:trigon_hp_boost"));
        }
        VPUtil.addOverShield(list.get(numba), overshields, false);
        super.doUltimate(seconds, player, level, stack);
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player1 = (Player)slotContext.entity();
        if (VPUtil.getOverShield((LivingEntity)player1) > 0.0f) {
            player1.getPersistentData().m_128350_("VPTrigonBonus", VPUtil.scalePower((100.0f - VPUtil.getOverShield((LivingEntity)player1) / (player1.getPersistentData().m_128457_("VPOverShieldMax") / 100.0f)) * 2.0f, 19, player1));
        } else {
            player1.getPersistentData().m_128350_("VPTrigonBonus", 0.0f);
        }
        super.curioTick(slotContext, stack);
    }

    @Override
    public void ultimateRecharges(Player player, ItemStack stack) {
        player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22276_, UUID.fromString("8dac9436-c37f-4b74-bf64-8666258605b9"), 1.0f, AttributeModifier.Operation.MULTIPLY_TOTAL, "vp:trigon_hp_boost"));
        player.m_21153_(player.m_21233_());
        super.ultimateRecharges(player, stack);
    }
}

