/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.mixin;

import com.pyding.vp.util.GradientUtil;
import com.pyding.vp.util.LeaderboardUtil;
import com.pyding.vp.util.VPUtil;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class}, priority=0)
public class VPPlayerMixin {
    @Inject(method={"getName"}, at={@At(value="RETURN")}, cancellable=true, require=1)
    private void getNameMixin(CallbackInfoReturnable<Component> cir) {
        Player player = (Player)this;
        String name = ((Component)cir.getReturnValue()).getString();
        if (LeaderboardUtil.hasSpecialName(name)) {
            cir.setReturnValue((Object)GradientUtil.customGradient(name, GradientUtil.PURPLE_DARK_PURPLE));
        }
        if (LeaderboardUtil.hasGoldenName(player.m_20148_())) {
            cir.setReturnValue((Object)GradientUtil.goldenGradient(name));
        }
    }

    @Inject(method={"getInventory"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void getInv(CallbackInfoReturnable<Inventory> cir) {
        if (VPUtil.isRoflanEbalo((LivingEntity)((Player)this))) {
            cir.setReturnValue((Object)new Inventory((Player)this));
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void step(CallbackInfo ci) {
        if (VPUtil.isRoflanEbalo((LivingEntity)((Player)this))) {
            ci.cancel();
        }
    }

    @Inject(method={"getEnderChestInventory"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void getEndInv(CallbackInfoReturnable<PlayerEnderChestContainer> cir) {
        if (VPUtil.isRoflanEbalo((LivingEntity)((Player)this))) {
            cir.setReturnValue((Object)new PlayerEnderChestContainer());
        }
    }

    @Inject(method={"getArmorSlots"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void getArmor(CallbackInfoReturnable<Iterable<ItemStack>> cir) {
        if (VPUtil.isRoflanEbalo((LivingEntity)((Player)this))) {
            cir.setReturnValue(new ArrayList());
        }
    }

    @Inject(method={"getHandSlots"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void getHands(CallbackInfoReturnable<Iterable<ItemStack>> cir) {
        if (VPUtil.isRoflanEbalo((LivingEntity)((Player)this))) {
            cir.setReturnValue(new ArrayList());
        }
    }

    @Inject(method={"getSlot"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void getSlot(CallbackInfoReturnable<SlotAccess> cir) {
        if (VPUtil.isRoflanEbalo((LivingEntity)((Player)this))) {
            cir.setReturnValue((Object)SlotAccess.f_147290_);
        }
    }
}

