/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.network.packets;

import com.pyding.vp.capability.PlayerCapabilityProviderVP;
import com.pyding.vp.util.ClientConfig;
import com.pyding.vp.util.LeaderboardUtil;
import com.pyding.vp.util.VPUtil;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class PlayerFlyPacket {
    private final int number;

    public PlayerFlyPacket(int number) {
        this.number = number;
    }

    public static void encode(PlayerFlyPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.number);
    }

    public static PlayerFlyPacket decode(FriendlyByteBuf buf) {
        return new PlayerFlyPacket(buf.readInt());
    }

    public static void handle(PlayerFlyPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PlayerFlyPacket.handle2(msg.number));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle2(int number) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (number == 1) {
            Vec3 motion = new Vec3(0.0, 3.0, 0.0);
            player.m_6001_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
        } else if (number == 2) {
            player.m_150110_().f_35936_ = false;
            player.m_150110_().f_35935_ = false;
            player.m_6885_();
        } else if (number == -1) {
            VPUtil.fall((LivingEntity)player, -10.0);
        } else if (number == 69) {
            BlockPos pos = new BlockPos((int)player.getPersistentData().m_128459_("VPDevourerX"), (int)player.getPersistentData().m_128459_("VPDevourerY"), (int)player.getPersistentData().m_128459_("VPDevourerZ"));
            VPUtil.suckToPos((Entity)player, pos, 3.0);
        } else if (number == 3) {
            VPUtil.clearEffects((LivingEntity)player, true);
        } else if (number == 4) {
            VPUtil.clearEffects((LivingEntity)player, false);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 400, 4));
        } else if (number == 5) {
            player.m_7292_(new MobEffectInstance(VPUtil.getRandomEffect(false), 1200));
        } else if (number == 6) {
            player.m_150110_().f_35936_ = true;
            player.m_150110_().f_35935_ = true;
            player.m_6885_();
        } else if (number == 7) {
            LeaderboardUtil.refreshTopPlayers();
        } else if (number == 8) {
            if (Minecraft.m_91087_().f_91080_ != null) {
                Minecraft.m_91087_().f_91080_.m_7379_();
            }
            VPUtil.antiResurrect((LivingEntity)player, System.currentTimeMillis() + VPUtil.deathTime);
            VPUtil.setRoflanEbalo((LivingEntity)player, System.currentTimeMillis() + VPUtil.deathTime);
            VPUtil.setHealth((LivingEntity)player, 0.0f);
            player.m_6667_(player.m_269291_().m_287172_());
            VPUtil.despawn((LivingEntity)player);
            Minecraft.m_91087_().m_91346_((Screen)new DeathScreen((Component)Component.m_237113_((String)"Death by Paragon Damage"), false));
        } else if (number == 9) {
            VPUtil.roflan.put(player.m_20148_(), 0L);
        } else if (number == 10) {
            VPUtil.antiResurrect((LivingEntity)player, -1L);
        } else if (number == 11) {
            VPUtil.antiTp((LivingEntity)player, -1L);
        } else if (number == 12) {
            player.m_108711_(true);
        } else if (number == 13) {
            ClientConfig.COMMON.renderSoulIntegrity.set((Object)((Boolean)ClientConfig.COMMON.renderSoulIntegrity.get() == false ? 1 : 0));
        } else if (number == 278) {
            if (Minecraft.m_91087_().f_91073_ != null) {
                Set biomes = Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(Registries.f_256952_).m_214010_();
                VPUtil.biomeNames.addAll(biomes);
            }
        } else if (number > 300) {
            BlockPos pos = new BlockPos((int)player.getPersistentData().m_128459_("VPDevourerX"), (int)player.getPersistentData().m_128459_("VPDevourerY"), (int)player.getPersistentData().m_128459_("VPDevourerZ"));
            VPUtil.suckToPos((Entity)player, pos, number - 300);
        }
        player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> {});
    }
}

