/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.network.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SoundPacket {
    private final ResourceLocation soundLocation;
    private final float volume;
    private final float pitch;
    private final double x;
    private final double y;
    private final double z;

    public SoundPacket(ResourceLocation soundLocation, float volume, float pitch, double x, double y, double z) {
        this.soundLocation = soundLocation;
        this.volume = volume;
        this.pitch = pitch;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void encode(SoundPacket packet, FriendlyByteBuf buf) {
        buf.m_130085_(packet.soundLocation);
        buf.writeFloat(packet.volume);
        buf.writeFloat(packet.pitch);
        buf.writeDouble(packet.x);
        buf.writeDouble(packet.y);
        buf.writeDouble(packet.z);
    }

    public static SoundPacket decode(FriendlyByteBuf buf) {
        return new SoundPacket(buf.m_130281_(), buf.readFloat(), buf.readFloat(), buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void handle(SoundPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> SoundPacket.handle2(msg.soundLocation, msg.volume, msg.pitch, msg.x, msg.y, msg.z));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle2(ResourceLocation soundLocation, float volume, float pitch, double x, double y, double z) {
        LocalPlayer player;
        SoundEvent soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation);
        if (soundEvent != null && (player = Minecraft.m_91087_().f_91074_) != null) {
            if (x == 0.0 && y == 0.0 && z == 0.0) {
                player.m_20193_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, SoundSource.MASTER, volume, pitch, false);
            } else {
                player.m_20193_().m_7785_(x, y, z, soundEvent, SoundSource.MASTER, volume, pitch, false);
            }
        }
    }
}

