/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.AtomicDouble;
import com.pyding.vp.capability.PlayerCapabilityProviderVP;
import com.pyding.vp.capability.PlayerCapabilityVP;
import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.compat.NoGriefCompat;
import com.pyding.vp.entity.BlackHole;
import com.pyding.vp.entity.CloudEntity;
import com.pyding.vp.entity.EasterEggEntity;
import com.pyding.vp.entity.HunterKiller;
import com.pyding.vp.entity.VortexEntity;
import com.pyding.vp.item.CelestialMirror;
import com.pyding.vp.item.ChaosOrb;
import com.pyding.vp.item.CorruptFragment;
import com.pyding.vp.item.CorruptItem;
import com.pyding.vp.item.ModItems;
import com.pyding.vp.item.PinkyPearl;
import com.pyding.vp.item.TestItem;
import com.pyding.vp.item.accessories.Accessory;
import com.pyding.vp.item.vestiges.Archlinx;
import com.pyding.vp.item.vestiges.Armor;
import com.pyding.vp.item.vestiges.Book;
import com.pyding.vp.item.vestiges.Chaos;
import com.pyding.vp.item.vestiges.Crown;
import com.pyding.vp.item.vestiges.Lyra;
import com.pyding.vp.item.vestiges.Rune;
import com.pyding.vp.item.vestiges.SoulBlighter;
import com.pyding.vp.item.vestiges.SweetDonut;
import com.pyding.vp.item.vestiges.Trigon;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.item.vestiges.Whirlpool;
import com.pyding.vp.mixin.BucketVzlom;
import com.pyding.vp.mixin.EntityVzlom;
import com.pyding.vp.mixin.LivingEntityVzlom;
import com.pyding.vp.mixin.LootItemEnchantMixin;
import com.pyding.vp.mixin.LootItemMixin;
import com.pyding.vp.mixin.LootPoolMixin;
import com.pyding.vp.mixin.LootRandomItemMixin;
import com.pyding.vp.mixin.LootTableVzlom;
import com.pyding.vp.mixin.MobEntityVzlom;
import com.pyding.vp.mixin.PlayerListVzlom;
import com.pyding.vp.mixin.SmitingMixing;
import com.pyding.vp.mixin.VzlomJopiMixin;
import com.pyding.vp.network.PacketHandler;
import com.pyding.vp.network.packets.ParticlePacket;
import com.pyding.vp.network.packets.PlayerFlyPacket;
import com.pyding.vp.network.packets.SendEntityNbtToClient;
import com.pyding.vp.network.packets.SendPlayerNbtToClient;
import com.pyding.vp.network.packets.SoundPacket;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.LeaderboardUtil;
import com.pyding.vp.util.VPUtilParticles;
import com.pyding.vp.util.Vector3;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.block.CoralFanBlock;
import net.minecraft.world.level.block.CoralPlantBlock;
import net.minecraft.world.level.block.CoralWallFanBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class VPUtil {
    public static List<EntityType<?>> entities = new ArrayList();
    public static HashSet<Item> items = new HashSet();
    public static HashSet<ResourceKey<Biome>> biomeNames = new HashSet();
    private static final Pattern PATTERN = Pattern.compile("minecraft:(\\w+)");
    public static HashSet<String> foodItems = new HashSet();
    public static HashSet<String> toolItems = new HashSet();
    public static HashSet<String> templates = new HashSet();
    public static HashSet<String> musicDisks = new HashSet();
    public static HashSet<String> seaList = new HashSet();
    public static HashMap<MobBucketItem, HashSet<String>> bucketMap = new HashMap();
    public static HashSet<MobBucketItem> buckets = new HashSet();
    public static List<EntityType<?>> monsterList = new ArrayList();
    public static List<EntityType<?>> bossList = new ArrayList();
    public static HashSet<Block> blocks = new HashSet();
    public static HashSet<String> flowers = new HashSet();
    public static double commonPower = 3.0;
    public static long deathTime = 60000L;
    public static HashMap<String, List<Item>> rareDrops = new HashMap();
    public static HashSet<Item> hashRares = new HashSet();
    public static HashMap<SoundEvent, Long> soundCd = new HashMap();
    public static HashSet<MobEffect> effects = new HashSet();
    public static List<Item> fishList = new ArrayList<Item>();
    private static final Map<ResourceLocation, List<Item>> biomeFishMap = new HashMap<ResourceLocation, List<Item>>();
    public static Map<EntityType<?>, Float> zaebali = new HashMap();
    public static HashMap<UUID, String> osMap = new HashMap();
    public static HashMap<UUID, Long> roflan = new HashMap();
    public static HashMap<UUID, CompoundTag> temporaryData = new HashMap();
    public static List<Double> powerList = new ArrayList<Double>();

    public static long coolDown(Player player) {
        if (((Boolean)ConfigHandler.COMMON.leaderboard.get()).booleanValue()) {
            return 43200000L;
        }
        double reduce = 1.0;
        if (VPUtil.getSet(player) == 10) {
            reduce = 0.9;
        }
        return (long)((double)((Integer)ConfigHandler.COMMON.cooldown.get() * 60 * 60 * 1000) * reduce);
    }

    public static String getRainbowString(String text) {
        StringBuilder coloredText = new StringBuilder();
        Random random = new Random();
        ChatFormatting[] colors = ChatFormatting.values();
        for (char letter : text.toCharArray()) {
            ChatFormatting color = colors[random.nextInt(colors.length - 1) + 1];
            coloredText.append(color).append(letter);
        }
        return coloredText.toString();
    }

    public static String generateRandomString(int length) {
        String characters = "\u2263\u2264\u2265\u2266\u2267\u2268\u2269\u226a\u226b\u226c\u226d\u226e\u226f\u2270\u2271\u2272\u2273\u2274\u2275\u2276\u2277\u2278\u2279\u227a\u227b\u227c\u227d\u227e\u227f\u2280\u2281\u2282\u2283\u2284\u2285\u2286\u2287\u2288\u2289\u228a\u228b\u228c\u228d\u228e\u228f\u2290\u2291\u2292\u2293\u2294\u2295\u2296\u2297\u2298\u2299\u229a\u229b\u229c\u229d\u229e\u229f\u22a0\u22a1\u22a2\u22a3\u22a4\u22a5\u22a6\u22a7\u22a8\u22a9\u22aa\u22ab\u22ac\u22ad\u22ae\u22af\u22b0\u22b1\u22b2\u22b3\u22b4\u22b5\u22b6\u22b7\u22b8\u22b9\u22ba\u22bb\u22bc\u22bd\u22be\u22bf\u22c0\u22c1\u22c2\u22c3\u22c4\u22c5\u22c6\u22c7\u22c8\u22c9\u22ca\u22cb\u22cc\u22cd\u22ce\u22cf\u22d0\u22d1\u22d2\u22d3\u22d4\u22d5\u22d6\u22d7\u22d8\u22d9\u22da\u22db\u22dc\u22dd\u22de\u22df\u25b2\u25b3\u25b4\u25b5\u25b6\u25b7\u25b8\u25b9\u25ba\u25bb\u25bc\u25bd\u25be\u25bf\u25c0\u25c1\u25c2\u25c3\u25c4\u25c5\u25c6\u25c7\u25c8\u25c9\u25ca\u25cb\u25cc\u25cd\u25ce\u25cf\u25d0\u25d1\u25d2\u25d3\u25d4\u25d5\u25d6\u25d7\u25d8\u25d9\u25da\u25db\u25dc\u25dd\u25de\u25df\u25e0\u25e1\u25e2\u25e3\u25e4\u25e5\u25e6\u25e7\u25e8\u25e9\u25ea\u25eb\u25ec\u25ed\u25ee\u25ef\u2600\u2601\u2602\u2603\u2604\u2605\u2606\u2607\u2608\u2609\u260a\u260b\u260c\u260d\u260e\u260f\u2610\u2611\u2612\u2613\u2616\u2617\u261a\u261b\u261c\u261d\u261e\u261f\u2620\u2621\u2622\u2623\u2624\u2625\u2626\u2627\u2628\u2629\u262a\u262b\u262c\u262d\u262e\u262f\u2701\u2702\u2703\u2704\u2706\u2707\u2708\u2709\u270c\u270d\u270e\u270f\u2710\u2711\u2712\u2713\u2714\u2715\u2716\u2717\u2718\u2719\u271a\u271b\u271c\u271d\u271e\u271f\u2720\u2721\u2722\u2723\u2724\u2725\u2726\u2727\u2729\u272a\u272b\u272c\u272d\u272e\u272f\u2730\u2731\u2732\u2733\u2734\u2735\u2736\u2737\u2738\u2739\u273a\u273b\u273c\u273d\u273e\u273f\u2740\u2741\u2742\u2743\u2744\u2745\u2746\u2747\u2748\u2749\u274a\u274b\u274d\u274f\u2750\u2751\u2752\u2756\u2761\u2762\u2763\u2764\u2765\u2766\u2767\u2758\u2759\u275a\u275b\u275c\u275d\u275e\u27b1\u27b2\u27b3\u27b4\u27b5\u27b6\u27b7\u27b8\u2798\u2799\u279a\u279b\u279c\u279d\u279e\u279f\u27a0\u27a1\u27a2\u27a3\u27a4\u27a5\u27a6\u27a7\u27a8\u27a9\u27aa\u27ab\u27ac\u27ad\u27ae\u27af\u2789\u2794\u27b9\u27ba\u27bb\u27bc\u27bd\u27be\u27bf\u0d60\u0d61\u2022\u2023\u2011\u2012\u2013\u2014\u2015\u2016\u2017\u2018\u2019\u201a\u201b\u201c\u201d\u201e\u201f\u2020\u2021\u2030\u2032\u2033\u2034\u2035\u2036\u2037\u2038\u2039\u203a\u203b\u203c\u203d\u203e\u203f\u2040\u2041\u2042\u2043\u2044\u2045\u2046\u2050\u2051\u20b0\u20b1\u20b2\u20b3\u20b4\u20b5\u20d1\u20d2\u20d3\u20d4\u20d5\u20d6\u20d7\u20d8\u20d9\u20da\u20db\u20dc\u20dd\u20de\u20df\u20e0\u20e1\u20e2\u20e3\u2100\u2101\u2102\u2103\u2104\u2105\u2106\u2107\u2108\u2109\u210a\u210b\u210c\u210d\u210e\u210f\u2110\u2111\u2112\u2113\u2114\u2115\u2116\u2117\u2118\u2119\u211a\u211b\u211c\u211d\u211e\u211f\u2120\u2121\u2122\u2123\u2124\u2125\u03a9\u2127\u2128\u2129K\u00c5\u212c\u212d\u212e\u212f\u2130\u2131\u2132\u2133\u2134\u2153\u2154\u2155\u2156\u2157\u2158\u2159\u215a\u215b\u215c\u215d\u215e\u215f\u2160\u2161\u2162\u2163\u2164\u2165\u2166\u2167\u2168\u2169\u216a\u216b\u216c\u2135\u2136\u2137\u2138\u2139\u213b\u2145\u2146\u2147\u2148\u2149\u214d\u214e\u216d\u216e\u216f\u2170\u2171\u2172\u2173\u2174\u2175\u2176\u2177\u2178\u2179\u217a\u217b\u217c\u217d\u217e\u217f\u2180\u2181\u2182\u2184\u2190\u2191\u2192\u2193\u2194\u2195\u2196\u2197\u2198\u2199\u219a\u219b\u219c\u219d\u219e\u219f\u21a0\u21a1\u21a2\u21a3\u21a4\u21a5\u21a6\u21a7\u21a8\u21a9\u21aa\u21ab\u21ac\u21ad\u21ae\u21af\u21b0\u21b1\u21b2\u21b3\u21b4\u21b5\u21b6\u21b7\u21b8\u21b9\u21ba\u21bb\u21bc\u21bd\u21be\u21bf\u21c0\u21c1\u21c2\u21c3\u21c4\u21c5\u21c6\u21c7\u21c8\u21c9\u21ca\u21cb\u21cc\u21cd\u21ce\u21cf\u21d0\u21d1\u21d2\u21d3\u21d4\u21d5\u21d6\u21d7\u21d8\u21d9\u21da\u21db\u21dc\u21dd\u21de\u21df\u21e0\u21e1\u21e2\u21e3\u21e4\u21e5\u21e6\u21e7\u21e8\u21e9\u21ea\u2200\u2201\u2202\u2203\u2204\u2205\u2206\u2207\u2208\u2209\u220a\u220b\u220c\u220d\u220e\u220f\u2210\u2211\u2212\u2213\u2214\u2215\u2216\u2217\u2218\u2219\u221a\u221b\u221c\u221d\u221e\u221f\u2220\u2221\u2222\u2223\u2224\u2225\u2226\u2227\u2228\u2229\u222a\u222b\u222c\u222d\u222e\u222f\u2230\u2231\u2232\u2233\u2234\u2235\u2236\u2237\u2238\u2239\u223a\u223b\u223c\u223d\u223e\u223f\u2240\u2241\u2242\u2243\u2244\u2245\u2246\u2247\u2248\u2249\u224a\u224b\u224c\u224d\u224e\u224f\u2250\u2251\u2252\u2253\u2254\u2255\u2256\u2257\u2258\u2259\u225a\u225b\u225c\u225d\u225e\u225f\u2260\u2261\u2262";
        Random random = new Random();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int randomIndex = random.nextInt(characters.length());
            result.append(characters.charAt(randomIndex));
        }
        return result.toString();
    }

    public static float missingHealth(LivingEntity entity) {
        return (1.0f - entity.m_21223_() / entity.m_21233_()) * 100.0f;
    }

    public static List<LivingEntity> getEntities(Player player, double radius, boolean self) {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>(player.m_20193_().m_45976_(LivingEntity.class, new AABB(player.m_20185_() + radius, player.m_20186_() + radius, player.m_20189_() + radius, player.m_20185_() - radius, player.m_20186_() - radius, player.m_20189_() - radius)));
        if (!self) {
            list.remove(player);
        }
        return list;
    }

    public static float getAttack(Player player, boolean hasDurability) {
        float curseMultiplier;
        Item item;
        float attack = (float)player.m_21051_(Attributes.f_22281_).m_22135_();
        if (!hasDurability && (item = player.m_21205_().m_41720_()) instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            attack -= tieredItem.m_43314_().m_6631_();
        }
        if ((curseMultiplier = VPUtil.getCurseMultiplier(player, 4)) > 0.0f) {
            attack *= curseMultiplier;
        }
        return attack;
    }

    public static List<EntityType<?>> getEntitiesList() {
        return entities;
    }

    public static List<EntityType<?>> getEntitiesListOfType(MobCategory category) {
        return entities.stream().filter(entityType -> entityType.m_20674_() == category).collect(Collectors.toList());
    }

    public static void initEntities() {
        HashSet set = new HashSet(ForgeRegistries.ENTITY_TYPES.getValues());
        entities.addAll(set);
    }

    public static void initBiomes(Player player, Level level) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Set biomes = level.m_9598_().m_175515_(Registries.f_256952_).m_214010_();
            biomeNames.addAll(biomes);
        }
    }

    public static List<ResourceLocation> getBiomes() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (ResourceKey<Biome> key : biomeNames) {
            list.add(key.m_135782_());
        }
        return list;
    }

    public static HashSet<String> getBiomesLeft(String list, Player player) {
        HashSet<String> biomeList = new HashSet<String>(Arrays.asList(VPUtil.filterString(list).split(",")));
        HashSet<String> allList = new HashSet<String>();
        for (ResourceLocation location : VPUtil.getBiomes()) {
            allList.add(location.m_135815_().trim());
        }
        allList.removeAll(biomeList);
        player.getPersistentData().m_128359_("VPBiomesClient", VPUtil.filterAndTranslate(allList.toString(), ChatFormatting.GRAY).getString());
        return allList;
    }

    public static HashSet<String> getBiomesClient(Player player) {
        return new HashSet<String>(Arrays.asList(player.getPersistentData().m_128461_("VPBiomesClient").split(",")));
    }

    public static void initItems() {
        for (Item item : ForgeRegistries.ITEMS) {
            items.add(item);
        }
    }

    public static HashSet<Item> getItems() {
        return items;
    }

    public static HashSet<String> getEdibleItems() {
        if (foodItems.isEmpty()) {
            for (Item item : items) {
                if (!item.m_41472_()) continue;
                foodItems.add(item.m_5524_());
            }
        }
        return foodItems;
    }

    public static HashSet<String> getFoodLeft(String list) {
        HashSet<String> foodList = new HashSet<String>(Arrays.asList(VPUtil.filterString(list).split(",")));
        HashSet<String> allList = new HashSet<String>(VPUtil.getEdibleItems());
        allList.removeAll(foodList);
        return allList;
    }

    public static HashSet<String> getTools() {
        if (toolItems.isEmpty()) {
            for (Item item : items) {
                if (!(item instanceof TieredItem)) continue;
                toolItems.add(item.m_5524_());
            }
        }
        return toolItems;
    }

    public static HashSet<String> getTemplates() {
        if (templates.isEmpty()) {
            for (Item item : items) {
                SmithingTemplateItem templateItem;
                ComponentContents componentContents;
                if (!(item instanceof SmithingTemplateItem) || !((componentContents = ((SmitingMixing)(templateItem = (SmithingTemplateItem)item)).upgradeDescription().m_214077_()) instanceof TranslatableContents)) continue;
                TranslatableContents translatableContents = (TranslatableContents)componentContents;
                templates.add(translatableContents.m_237508_());
            }
        }
        return templates;
    }

    public static HashSet<String> getTemplatesLeft(String list) {
        HashSet<String> have = new HashSet<String>(Arrays.asList(VPUtil.filterString(list).split(",")));
        HashSet<String> allList = new HashSet<String>(VPUtil.getTemplates());
        allList.removeAll(have);
        return allList;
    }

    public static HashSet<String> getMusicDisks() {
        if (musicDisks.isEmpty()) {
            for (Item item : items) {
                if (!(item instanceof RecordItem)) continue;
                RecordItem recordItem = (RecordItem)item;
                musicDisks.add(item.m_5524_());
            }
        }
        return musicDisks;
    }

    public static HashSet<String> getMusicDisksLeft(String list) {
        HashSet<String> have = new HashSet<String>(Arrays.asList(VPUtil.filterString(list).split(",")));
        HashSet<String> allList = new HashSet<String>(VPUtil.getMusicDisks());
        allList.removeAll(have);
        return allList;
    }

    public static HashSet<MobBucketItem> getBuckets() {
        if (buckets.isEmpty()) {
            for (Item item : items) {
                if (!(item instanceof MobBucketItem)) continue;
                MobBucketItem bucketItem = (MobBucketItem)item;
                buckets.add(bucketItem);
            }
        }
        return buckets;
    }

    public static void initBuckets() {
        for (MobBucketItem bucketItem : VPUtil.getBuckets()) {
            EntityType<?> type = ((BucketVzlom)bucketItem).getFishSup().get();
            if (type.m_20675_().contains("entity.minecraft.tropical_fish")) {
                HashSet<String> tropicalFish = new HashSet<String>();
                for (TropicalFish.Variant variant : TropicalFish.f_30007_) {
                    tropicalFish.add(variant.f_262204_().m_7912_());
                }
                bucketMap.put(bucketItem, tropicalFish);
                continue;
            }
            if (type.m_20675_().contains("entity.minecraft.axolotl")) {
                HashSet<String> axolotl = new HashSet<String>();
                for (Axolotl.Variant variant : Axolotl.Variant.values()) {
                    axolotl.add(variant.m_149253_());
                }
                bucketMap.put(bucketItem, axolotl);
                continue;
            }
            seaList.add(bucketItem.m_5524_());
        }
    }

    public static HashSet<String> fishTypesFromBucket(MobBucketItem bucketItem) {
        if (bucketMap.isEmpty()) {
            VPUtil.initBuckets();
        }
        if (bucketMap.containsKey(bucketItem)) {
            return bucketMap.get(bucketItem);
        }
        return new HashSet<String>();
    }

    public static HashSet<String> getSeaList() {
        if (seaList.size() <= 10) {
            seaList.clear();
        }
        if (bucketMap.isEmpty()) {
            VPUtil.initBuckets();
        }
        for (Block block : blocks) {
            if (!(block instanceof CoralBlock) && !(block instanceof CoralPlantBlock) && !(block instanceof CoralWallFanBlock) && !(block instanceof CoralFanBlock)) continue;
            seaList.add(block.m_7705_());
        }
        for (MobBucketItem bucket : buckets) {
            EntityType<?> type = ((BucketVzlom)bucket).getFishSup().get();
            if (type.m_20675_().contains("entity.minecraft.axolotl") || type.m_20675_().contains("entity.minecraft.tropical_fish")) continue;
            seaList.add(bucket.m_5524_());
        }
        return seaList;
    }

    public static HashSet<String> getAxolotlVariantsLeft(String list) {
        HashSet<String> have = new HashSet<String>(Arrays.asList(VPUtil.filterString(list).split(",")));
        HashSet<String> allList = new HashSet<String>();
        for (MobBucketItem bucket : buckets) {
            EntityType<?> type = ((BucketVzlom)bucket).getFishSup().get();
            if (!type.m_20675_().contains("entity.minecraft.axolotl")) continue;
            allList.addAll((Collection<String>)bucketMap.get(bucket));
        }
        allList.removeAll(have);
        return allList;
    }

    public static HashSet<String> getTropiclVariantsLeft(String list) {
        HashSet<String> have = new HashSet<String>(Arrays.asList(VPUtil.filterString(list).split(",")));
        HashSet<String> allList = new HashSet<String>();
        for (MobBucketItem bucket : buckets) {
            EntityType<?> type = ((BucketVzlom)bucket).getFishSup().get();
            if (!type.m_20675_().contains("entity.minecraft.tropical_fish")) continue;
            allList.addAll((Collection<String>)bucketMap.get(bucket));
        }
        allList.removeAll(have);
        return allList;
    }

    public static int getSeaSize() {
        int size = 0;
        size += VPUtil.getSeaList().size();
        for (MobBucketItem bucket : buckets) {
            EntityType<?> type = ((BucketVzlom)bucket).getFishSup().get();
            if (!type.m_20675_().contains("entity.minecraft.tropical_fish") && !type.m_20675_().contains("entity.minecraft.axolotl")) continue;
            for (String id : bucketMap.get(bucket)) {
                ++size;
            }
        }
        return size;
    }

    public static HashSet<String> getSeaLeft(String list) {
        HashSet<String> have = new HashSet<String>(Arrays.asList(VPUtil.filterString(list).split(",")));
        HashSet<String> allList = new HashSet<String>(VPUtil.getSeaList());
        allList.removeAll(have);
        return allList;
    }

    public static void initMonstersAndBosses(Player player) {
        if (!monsterList.isEmpty() || !bossList.isEmpty()) {
            return;
        }
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (EntityType<?> type : VPUtil.getEntitiesListOfType(MobCategory.MONSTER)) {
            Entity entity = type.m_20615_(player.m_20193_());
            if (entity instanceof HunterKiller || !(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            float health = livingEntity.m_21233_();
            if ((health > 190.0f || VPUtil.isCustomBoss(type)) && !VPUtil.isBlacklistBoss(type, player)) {
                bossList.add(type);
                zaebali.put(type, Float.valueOf(health));
            } else {
                monsterList.add(type);
            }
            list.add(livingEntity);
        }
        VPUtil.initRareDrops(list, player.m_20194_());
    }

    public static boolean isBlacklistBoss(EntityType<?> type, Player player) {
        if (LeaderboardUtil.isLeaderboardsActive(player)) {
            int count = 0;
            for (String types : ConfigHandler.COMMON.blacklistBosses.get().toString().split(",")) {
                if (++count <= 3) {
                    if (!type.toString().contains(types)) continue;
                    return true;
                }
                break;
            }
        } else {
            for (String types : ConfigHandler.COMMON.blacklistBosses.get().toString().split(",")) {
                if (!type.toString().contains(types)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCustomBoss(EntityType<?> type) {
        for (String types : ConfigHandler.COMMON.bosses.get().toString().split(",")) {
            if (!type.toString().contains(types)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getMonsterLeft(String list, Player player) {
        ArrayList<String> mobsList = new ArrayList<String>(Arrays.asList(VPUtil.filterString(list).split(",")));
        ArrayList<String> allList = new ArrayList<String>();
        for (EntityType<?> type : monsterList) {
            allList.add(type.toString().trim());
        }
        allList.removeAll(mobsList);
        player.getPersistentData().m_128359_("VPMonsterClient", VPUtil.filterAndTranslate(((Object)allList).toString(), ChatFormatting.GRAY).getString());
        return allList;
    }

    public static List<String> getMonsterClient(Player player) {
        return new ArrayList<String>(Arrays.asList(player.getPersistentData().m_128461_("VPMonsterClient").split(",")));
    }

    public static List<String> getBossesLeft(String list, Player player) {
        ArrayList<String> mobsList = new ArrayList<String>(Arrays.asList(VPUtil.filterString(list).split(",")));
        ArrayList<String> allList = new ArrayList<String>();
        for (EntityType<?> type : bossList) {
            allList.add(type.toString());
        }
        allList.removeAll(mobsList);
        player.getPersistentData().m_128359_("VPBossClient", VPUtil.filterAndTranslate(((Object)allList).toString(), ChatFormatting.GRAY).getString());
        return allList;
    }

    public static List<String> getBossClient(Player player) {
        return new ArrayList<String>(Arrays.asList(player.getPersistentData().m_128461_("VPBossClient").split(",")));
    }

    public static List<String> getMobsLeft(String list, Player player) {
        ArrayList<String> mobsList = new ArrayList<String>(Arrays.asList(VPUtil.filterString(list).split(",")));
        ArrayList<String> allList = new ArrayList<String>();
        for (EntityType<?> type : VPUtil.getEntitiesListOfType(MobCategory.CREATURE)) {
            allList.add(type.toString());
        }
        allList.removeAll(mobsList);
        player.getPersistentData().m_128359_("VPMobsClient", VPUtil.filterAndTranslate(((Object)allList).toString(), ChatFormatting.GRAY).getString());
        return allList;
    }

    public static List<String> getMobsClient(Player player) {
        return new ArrayList<String>(Arrays.asList(player.getPersistentData().m_128461_("VPMobsClient").split(",")));
    }

    public static List<String> getOresClient(Player player) {
        return new ArrayList<String>(Arrays.asList(player.getPersistentData().m_128461_("VPOresClient").split(",")));
    }

    public static void initBlocks() {
        for (Block block : ForgeRegistries.BLOCKS) {
            blocks.add(block);
        }
    }

    public static void initFlowers() {
        for (Block block : blocks) {
            if (!(block instanceof FlowerBlock)) continue;
            flowers.add(block.m_7705_());
        }
    }

    public static HashSet<String> getFlowers() {
        return flowers;
    }

    public static List<String> getFlowersLeft(String list) {
        ArrayList<String> flowerList = new ArrayList<String>(Arrays.asList(VPUtil.filterString(list).split(",")));
        ArrayList<String> allList = new ArrayList<String>();
        for (String name : VPUtil.getFlowers()) {
            allList.add(name);
        }
        allList.removeAll(flowerList);
        return allList;
    }

    public static String formatMilliseconds(long milliseconds) {
        if (milliseconds < 0L) {
            return "Invalid input";
        }
        long seconds = milliseconds / 1000L;
        long days = seconds / 86400L;
        long hours = (seconds %= 86400L) / 3600L;
        long minutes = (seconds %= 3600L) / 60L;
        seconds %= 60L;
        StringBuilder formattedTime = new StringBuilder();
        if (days > 0L) {
            formattedTime.append(days).append("d ");
        }
        if (hours > 0L) {
            formattedTime.append(hours).append("h ");
        }
        if (minutes > 0L) {
            formattedTime.append(minutes).append("m ");
        }
        if (seconds > 0L || formattedTime.length() == 0) {
            formattedTime.append(seconds).append("s");
        }
        return formattedTime.toString().trim();
    }

    public static float damagePercentBonus(Player player, int type) {
        float percentBonus = 1.0f;
        Random random = new Random();
        if (type == 1) {
            percentBonus += 0.0f;
        } else if (type == 2) {
            if (VPUtil.getSet(player) == 2) {
                percentBonus += 400.0f;
            }
            if (player.getPersistentData().m_128454_("VPAcsSpecial") >= System.currentTimeMillis() && VPUtil.getSet(player) == 5 && random.nextDouble() < VPUtil.getChance(0.4, player)) {
                percentBonus += 600.0f;
            }
            percentBonus += player.getPersistentData().m_128457_("VPTrigonBonus");
        } else if (type == 3) {
            if (VPUtil.getSet(player) == 4) {
                percentBonus += 200.0f;
            }
            if (player.getPersistentData().m_128454_("VPAcsSpecial") >= System.currentTimeMillis() && VPUtil.getSet(player) == 5 && random.nextDouble() < VPUtil.getChance(0.4, player)) {
                percentBonus += 600.0f;
            }
            percentBonus += (float)(player.getPersistentData().m_128451_("VPGravity") * 20);
        }
        if (VPUtil.hasLyra((LivingEntity)player, 4)) {
            percentBonus += 50.0f;
        }
        return percentBonus;
    }

    public static void dealDamage(LivingEntity entity, Player player, DamageSource source, float percent, int type) {
        boolean hasDurability;
        if (VPUtil.isProtectedFromHit(player, (Entity)entity)) {
            return;
        }
        entity.getPersistentData().m_128405_("VPDealType", type);
        entity.f_19802_ = 0;
        ItemStack stack = player.m_21205_();
        boolean bl = hasDurability = stack.m_41763_() && stack.m_41773_() + 1 < stack.m_41776_();
        if (hasDurability) {
            stack.m_41622_(1, (LivingEntity)player, consumer -> consumer.m_21166_(EquipmentSlot.MAINHAND));
        }
        DamageSource damageSource = new DamageSource(source.m_269150_(), (Entity)player);
        player.getPersistentData().m_128379_("VPAttacked", true);
        entity.m_6469_(damageSource, VPUtil.getAttack(player, hasDurability) * ((percent + VPUtil.damagePercentBonus(player, type)) / 100.0f));
    }

    public static void dealDamage(LivingEntity entity, Player player, DamageSource source, float damage, int type, boolean invulPierce) {
        float curseMultiplier;
        ItemStack stack;
        boolean hasDurability;
        if (VPUtil.isProtectedFromHit(player, (Entity)entity)) {
            return;
        }
        entity.getPersistentData().m_128405_("VPDealType", type);
        if (invulPierce) {
            entity.f_19802_ = 0;
        }
        boolean bl = hasDurability = (stack = player.m_21205_()).m_41763_() && stack.m_41773_() + 1 < stack.m_41776_();
        if (hasDurability) {
            stack.m_41622_(1, entity, consumer -> consumer.m_21166_(EquipmentSlot.MAINHAND));
        }
        if ((curseMultiplier = VPUtil.getCurseMultiplier(player, 4)) > 0.0f) {
            damage *= curseMultiplier;
        }
        DamageSource damageSource = new DamageSource(source.m_269150_(), (Entity)player);
        player.getPersistentData().m_128379_("VPAttacked", true);
        entity.m_6469_(damageSource, damage * (1.0f + VPUtil.damagePercentBonus(player, type) / 100.0f));
    }

    public static void spawnLightning(ServerLevel world, double x, double y, double z) {
        LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)world);
        if (lightningBolt != null) {
            lightningBolt.m_6027_(x, y, z);
            world.m_7967_((Entity)lightningBolt);
        }
    }

    public static boolean isEvent(Entity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return false;
        }
        return (Boolean)ConfigHandler.COMMON.eventMode.get();
    }

    public static void setHealth(LivingEntity entity, float amount) {
        ((EntityVzlom)entity).getEntityData().m_135381_(((LivingEntityVzlom)entity).getDataHealth(), (Object)Float.valueOf(amount));
    }

    public static void despawn(LivingEntity livingEntity) {
        if (VPUtil.isNpc(livingEntity.m_6095_())) {
            return;
        }
        VPUtil.spawnSphere((Entity)livingEntity, (ParticleOptions)ParticleTypes.f_123783_, 50, 2.0f, 0.01f);
        VPUtil.spawnSphere((Entity)livingEntity, (ParticleOptions)ParticleTypes.f_123790_, 50, 2.0f, 0.01f);
        VPUtil.play(livingEntity, (SoundEvent)SoundRegistry.DESPAWN.get());
        VPUtil.setDead(livingEntity, livingEntity.m_269291_().m_269483_());
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            ((PlayerListVzlom)player.m_20194_().m_6846_()).getPlayers().remove(player);
        } else {
            VPUtil.setHealth(livingEntity, 0.0f);
            livingEntity.m_6274_().m_276084_();
            ((EntityVzlom)livingEntity).setPersistentData(null);
        }
        livingEntity.invalidateCaps();
        ((EntityVzlom)livingEntity).getLevelCallback().m_142472_(Entity.RemovalReason.DISCARDED);
    }

    public static void setDead(LivingEntity corpse, DamageSource source) {
        if (corpse.m_6084_() || !corpse.getPersistentData().m_128471_("VPWasDrop")) {
            Entity entity = source.m_7639_();
            if (corpse.m_5803_()) {
                corpse.m_5796_();
            }
            VPUtil.setHealth(corpse, 0.0f);
            ((LivingEntityVzlom)corpse).setDead(true);
            corpse.m_21231_().m_19296_();
            Level level = corpse.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                if (entity == null || entity.m_214076_(serverlevel, corpse)) {
                    corpse.m_146850_(GameEvent.f_223707_);
                    ((LivingEntityVzlom)corpse).invokeDropAllDeathLoot(source);
                }
                corpse.m_9236_().m_7605_((Entity)corpse, (byte)3);
            }
            corpse.m_20124_(Pose.DYING);
        }
    }

    public static void syncEntity(Entity entity) {
        CompoundTag sendNudes = new CompoundTag();
        for (String key : entity.getPersistentData().m_128431_()) {
            if (!key.startsWith("VP") || entity.getPersistentData().m_128423_(key) == null) continue;
            sendNudes.m_128365_(key, entity.getPersistentData().m_128423_(key));
        }
        if (!entity.m_20193_().f_46443_) {
            PacketHandler.sendToClients(PacketDistributor.TRACKING_ENTITY.with(() -> entity), new SendEntityNbtToClient(sendNudes, entity.m_19879_()));
        }
    }

    public static final String damageSubtypes() {
        Object damage = "";
        damage = (String)damage + "bypassArmor,";
        damage = (String)damage + "damageHelmet,";
        damage = (String)damage + "bypassEnchantments,";
        damage = (String)damage + "explosion,";
        damage = (String)damage + "bypassInvul,";
        damage = (String)damage + "bypassMagic,";
        damage = (String)damage + "fall,";
        damage = (String)damage + "magic,";
        damage = (String)damage + "noAggro,";
        damage = (String)damage + "projectile,";
        return damage;
    }

    public static void printDamage(Player player, LivingDamageEvent event) {
        player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> {
            if (cap.getDebug() && !player.m_20193_().f_46443_) {
                player.m_213846_(event.getEntity().m_6095_().m_20676_());
                player.m_213846_((Component)Component.m_237113_((String)("Damage source:\u00a75 " + event.getSource().m_19385_() + "\u00a7r, amount after absorption:\u00a75" + event.getAmount())));
                for (TagKey<DamageType> type : VPUtil.damageTypes(false)) {
                    if (!event.getSource().m_269533_(type)) continue;
                    player.m_213846_((Component)Component.m_237115_((String)type.f_203868_().m_214298_()));
                }
                float shield = VPUtil.getShield(event.getEntity());
                float overshield = VPUtil.getOverShield(event.getEntity());
                if (shield > 0.0f) {
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7cHas Shields: " + shield)));
                }
                if (overshield > 0.0f) {
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7dHas Over Shields: " + overshield)));
                }
                if (event.getEntity().getPersistentData().m_128451_("VPPrismDamage") > 0) {
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a75Has Prism with weak point: " + String.valueOf(VPUtil.playerDamageSources((LivingEntity)player, (LivingEntity)player).get(event.getEntity().getPersistentData().m_128451_("VPPrismDamage") - 1)))));
                }
                player.m_213846_((Component)Component.m_237113_((String)"\n"));
            }
        });
    }

    public static List<TagKey<DamageType>> getTypes(DamageSource source) {
        ArrayList<TagKey<DamageType>> types = new ArrayList<TagKey<DamageType>>();
        for (TagKey<DamageType> type : VPUtil.damageTypes(false)) {
            if (!source.m_269533_(type)) continue;
            types.add(type);
        }
        return types;
    }

    public static EntityType getRandomEntity() {
        Random random = new Random();
        ArrayList allEntities = new ArrayList();
        allEntities.addAll(VPUtil.getEntitiesListOfType(MobCategory.CREATURE));
        allEntities.addAll(VPUtil.getEntitiesListOfType(MobCategory.MONSTER));
        return (EntityType)allEntities.get(random.nextInt(allEntities.size()));
    }

    public static EntityType getRandomMonster() {
        Random random = new Random();
        ArrayList allEntities = new ArrayList();
        allEntities.addAll(VPUtil.getEntitiesListOfType(MobCategory.MONSTER));
        return (EntityType)allEntities.get(random.nextInt(allEntities.size()));
    }

    public static int getChaosTime() {
        return (Integer)ConfigHandler.COMMON.chaostime.get() * 60 * 1000;
    }

    public static boolean hasVestige(Item item, Player player) {
        if (!(item instanceof Vestige)) {
            return false;
        }
        ArrayList result = new ArrayList();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> result.addAll(handler.findCurios(item)));
        return result.size() > 0;
    }

    public static ItemStack getVestigeStack(Vestige vestige, Player player) {
        ArrayList result = new ArrayList();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> result.addAll(handler.findCurios(itemStack -> itemStack.m_41720_() == vestige)));
        return ((SlotResult)result.get(0)).stack();
    }

    public static ItemStack getVestigeStack(Class vestige, Player player) {
        ArrayList result = new ArrayList();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> result.addAll(handler.findCurios(itemStack -> itemStack.m_41720_().getClass() == vestige)));
        if (result.size() > 0) {
            return ((SlotResult)result.get(0)).stack();
        }
        return null;
    }

    public static List<ItemStack> getFirstVestige(Player player) {
        ArrayList result = new ArrayList();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.findFirstCurio(itemStack -> itemStack.m_41720_() instanceof Vestige).ifPresent(result::add));
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (SlotResult hitResult : result) {
            stacks.add(hitResult.stack());
        }
        return stacks;
    }

    public static List<ItemStack> getVestigeList(Player player) {
        ArrayList result = new ArrayList();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> result.addAll(handler.findCurios(itemStack -> itemStack.m_41720_() instanceof Vestige)));
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (SlotResult hitResult : result) {
            stacks.add(hitResult.stack());
        }
        return stacks;
    }

    public static List<ItemStack> getCurioList(Player player) {
        ArrayList result = new ArrayList();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> result.addAll(handler.findCurios(itemStack -> itemStack.m_41720_() instanceof ICurioItem)));
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (SlotResult hitResult : result) {
            stacks.add(hitResult.stack());
        }
        return stacks;
    }

    public static List<ItemStack> getAccessoryList(Player player) {
        ArrayList result = new ArrayList();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> result.addAll(handler.findCurios(itemStack -> itemStack.m_41720_() instanceof Accessory)));
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (SlotResult hitResult : result) {
            stacks.add(hitResult.stack());
        }
        return stacks;
    }

    public static boolean hasStellarVestige(Item item, Player player) {
        if (!(item instanceof Vestige)) {
            return false;
        }
        ArrayList result = new ArrayList();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> result.addAll(handler.findCurios(item)));
        for (SlotResult stack : result) {
            Item item2 = stack.stack().m_41720_();
            if (!(item2 instanceof Vestige)) continue;
            Vestige vestige = (Vestige)item2;
            if (!Vestige.isStellar(stack.stack())) continue;
            return true;
        }
        return false;
    }

    public static void equipmentDurability(float percentage, LivingEntity entity) {
        ItemStack stackLeft;
        int damage;
        percentage /= 100.0f;
        for (ItemStack stack2 : entity.m_6168_()) {
            damage = (int)((float)stack2.m_41776_() * percentage);
            stack2.m_41622_(damage, entity, consumer -> consumer.m_21166_(EquipmentSlot.CHEST));
        }
        ItemStack stack = entity.m_21205_();
        if (stack.m_41763_()) {
            int damage2 = (int)((float)stack.m_41776_() * percentage);
            stack.m_41622_(damage2, entity, consumer -> consumer.m_21166_(EquipmentSlot.MAINHAND));
        }
        if ((stackLeft = entity.m_21206_()).m_41763_()) {
            damage = (int)((float)stackLeft.m_41776_() * percentage);
            stackLeft.m_41622_(damage, entity, consumer -> consumer.m_21166_(EquipmentSlot.OFFHAND));
        }
    }

    public static float equipmentDurability(float percentage, LivingEntity entity, Player dealer, boolean stellar) {
        ItemStack stackLeft;
        if (VPUtil.hasVestige((Item)ModItems.RUNE.get(), dealer)) {
            VPUtil.addRadiance(Rune.class, 15, dealer);
        }
        percentage /= 100.0f;
        int totalDamage = 0;
        for (ItemStack stack2 : entity.m_6168_()) {
            int damage = (int)((float)stack2.m_41776_() * percentage);
            stack2.m_41622_(damage, entity, consumer -> consumer.m_21166_(EquipmentSlot.CHEST));
            totalDamage += damage;
        }
        ItemStack stack = entity.m_21205_();
        if (stack.m_41763_()) {
            int damage = (int)((float)stack.m_41776_() * percentage);
            ItemStack finalStack = stack;
            stack.m_41622_(damage, entity, consumer -> consumer.m_21166_(EquipmentSlot.MAINHAND));
            totalDamage += damage;
        }
        if ((stackLeft = entity.m_21206_()).m_41763_()) {
            int damage = (int)((float)stackLeft.m_41776_() * percentage);
            stackLeft.m_41622_(damage, entity, consumer -> consumer.m_21166_(EquipmentSlot.OFFHAND));
            totalDamage += damage;
        }
        if (stellar) {
            totalDamage /= 10;
            for (ItemStack stack2 : dealer.m_150109_().f_35975_) {
                int damage = stack2.m_41773_();
                if (damage < totalDamage) {
                    stack2.m_41721_(0);
                    totalDamage -= damage;
                    continue;
                }
                stack2.m_41721_(damage - totalDamage);
                totalDamage = 0;
            }
            ItemStack stack2 = dealer.m_21205_();
            if (stack2.m_41763_()) {
                int damage = stack2.m_41773_();
                if (damage < totalDamage) {
                    stack2.m_41721_(0);
                    totalDamage -= damage;
                } else {
                    stack2.m_41721_(damage - totalDamage);
                    totalDamage = 0;
                }
            }
            if ((stack = dealer.m_21206_()).m_41763_()) {
                int damage = stack2.m_41773_();
                if (damage < totalDamage) {
                    stack2.m_41721_(0);
                    totalDamage -= damage;
                } else {
                    stack2.m_41721_(damage - totalDamage);
                    totalDamage = 0;
                }
            }
            if (totalDamage > 0) {
                dealer.m_5634_((float)totalDamage);
            }
        }
        return totalDamage;
    }

    public static void liftEntity(LivingEntity entity, double power) {
        Random random = new Random();
        Vec3 motion = new Vec3(0.0, power, 0.0);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PacketHandler.sendToClient(new PlayerFlyPacket(1), player);
        } else {
            entity.m_6001_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 140));
        if (random.nextDouble() < 0.5) {
            VPUtil.play(entity, (SoundEvent)SoundRegistry.WIND1.get());
        } else {
            VPUtil.play(entity, (SoundEvent)SoundRegistry.WIND2.get());
        }
    }

    public static void suckEntity(Entity entity, Player player, int scale, boolean items) {
        if (entity instanceof ItemEntity) {
            if (!items) {
                return;
            }
            Vec3 playerPos = player.m_20182_();
            Vec3 entityPos = entity.m_20182_();
            Vec3 direction = playerPos.m_82546_(entityPos).m_82541_();
            Vec3 motion = direction.m_82490_((double)scale);
            entity.m_6001_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
        } else {
            if (entity == player) {
                return;
            }
            if (VPUtil.isProtectedFromHit(player, entity)) {
                return;
            }
            Vec3 playerPos = player.m_20182_();
            Vec3 entityPos = entity.m_20182_();
            Vec3 direction = playerPos.m_82546_(entityPos).m_82541_();
            Vec3 motion = direction.m_82490_((double)scale);
            entity.m_6001_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
            if (entity instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)entity;
                PacketHandler.sendToClient(new PlayerFlyPacket(1), player2);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 60));
            }
        }
    }

    public static List<Attribute> attributeList() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        list.add(Attributes.f_22281_);
        list.add(Attributes.f_22279_);
        list.add(Attributes.f_22283_);
        list.add(Attributes.f_22284_);
        list.add(Attributes.f_22285_);
        list.add(Attributes.f_22282_);
        list.add(Attributes.f_22280_);
        list.add(Attributes.f_22288_);
        list.add(Attributes.f_22286_);
        list.add(Attributes.f_22276_);
        list.add(Attributes.f_22278_);
        return list;
    }

    public static int compareStats(LivingEntity owner, LivingEntity victim, boolean self) {
        int selfStats = 0;
        int enemyStats = 0;
        AttributeMap map = owner.m_21204_();
        AttributeMap map2 = victim.m_21204_();
        List<Attribute> list = VPUtil.attributeList();
        for (int i = 0; i < list.size(); ++i) {
            if (map.m_22171_(list.get(i)) && map2.m_22171_(list.get(i))) {
                if (map.m_22181_(list.get(i)) > map2.m_22181_(list.get(i))) {
                    ++selfStats;
                    continue;
                }
                ++enemyStats;
                continue;
            }
            if (map.m_22171_(list.get(i)) && !map2.m_22171_(list.get(i))) {
                ++selfStats;
                continue;
            }
            ++enemyStats;
        }
        if (self) {
            return selfStats;
        }
        return enemyStats;
    }

    public static List<LivingEntity> getEntitiesAround(Player player, double x, double y, double z) {
        return player.m_20193_().m_45976_(LivingEntity.class, new AABB(player.m_20185_() + x, player.m_20186_() + y, player.m_20189_() + z, player.m_20185_() - x, player.m_20186_() - y, player.m_20189_() - z));
    }

    public static List getEntitiesAroundOfType(Class entityClass, Player player, double x, double y, double z, boolean self) {
        if (self) {
            return player.m_20193_().m_45976_(entityClass, new AABB(player.m_20185_() + x, player.m_20186_() + y, player.m_20189_() + z, player.m_20185_() - x, player.m_20186_() - y, player.m_20189_() - z));
        }
        ArrayList list = new ArrayList();
        for (Object entity : player.m_20193_().m_45976_(entityClass, new AABB(player.m_20185_() + x, player.m_20186_() + y, player.m_20189_() + z, player.m_20185_() - x, player.m_20186_() - y, player.m_20189_() - z))) {
            if (entity == player) continue;
            list.add(entity);
        }
        return list;
    }

    public static List<LivingEntity> getEntitiesAround(Player player, double x, double y, double z, boolean self) {
        if (self) {
            return player.m_20193_().m_45976_(LivingEntity.class, new AABB(player.m_20185_() + x, player.m_20186_() + y, player.m_20189_() + z, player.m_20185_() - x, player.m_20186_() - y, player.m_20189_() - z));
        }
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (LivingEntity entity : player.m_20193_().m_45976_(LivingEntity.class, new AABB(player.m_20185_() + x, player.m_20186_() + y, player.m_20189_() + z, player.m_20185_() - x, player.m_20186_() - y, player.m_20189_() - z))) {
            if (entity == player) continue;
            list.add(entity);
        }
        return list;
    }

    public static List<LivingEntity> getEntitiesAround(LivingEntity player, double x, double y, double z, boolean self) {
        if (self) {
            return player.m_20193_().m_45976_(LivingEntity.class, new AABB(player.m_20185_() + x, player.m_20186_() + y, player.m_20189_() + z, player.m_20185_() - x, player.m_20186_() - y, player.m_20189_() - z));
        }
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (LivingEntity entity : player.m_20193_().m_45976_(LivingEntity.class, new AABB(player.m_20185_() + x, player.m_20186_() + y, player.m_20189_() + z, player.m_20185_() - x, player.m_20186_() - y, player.m_20189_() - z))) {
            if (entity == player) continue;
            list.add(entity);
        }
        return list;
    }

    public static List<LivingEntity> getEntitiesAround(Entity player, double x, double y, double z, boolean self) {
        if (self) {
            return player.m_20193_().m_45976_(LivingEntity.class, new AABB(player.m_20185_() + x, player.m_20186_() + y, player.m_20189_() + z, player.m_20185_() - x, player.m_20186_() - y, player.m_20189_() - z));
        }
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (LivingEntity entity : player.m_20193_().m_45976_(LivingEntity.class, new AABB(player.m_20185_() + x, player.m_20186_() + y, player.m_20189_() + z, player.m_20185_() - x, player.m_20186_() - y, player.m_20189_() - z))) {
            if (entity == player) continue;
            list.add(entity);
        }
        return list;
    }

    public static void adaptiveDamageHurt(LivingEntity entity, Player player, float percent) {
        boolean adopted = entity.getPersistentData().m_128471_("VPCrownDR");
        int damage = entity.getPersistentData().m_128451_("VPCrownDamage");
        if (damage >= VPUtil.playerDamageSources((LivingEntity)player, (LivingEntity)player).size()) {
            damage = 0;
        }
        if (adopted) {
            VPUtil.addRadiance(Crown.class, 5, player);
            if (++damage >= VPUtil.playerDamageSources((LivingEntity)player, (LivingEntity)player).size()) {
                damage = 0;
            }
            entity.getPersistentData().m_128405_("VPCrownDamage", damage);
        }
        DamageSource source = new DamageSource(VPUtil.playerDamageSources((LivingEntity)player, entity).get(damage).m_269150_(), (Entity)player);
        VPUtil.dealDamage(entity, player, source, percent, 2);
        VPUtil.addRadiance(Crown.class, VPUtil.getRadianceSpecial(), player);
    }

    public static DamageSource randomizeDamageType(Player player) {
        List<DamageSource> sources = VPUtil.playerDamageSources((LivingEntity)player, (LivingEntity)player);
        int numba = new Random().nextInt(sources.size());
        return sources.get(numba);
    }

    public static float getShieldBonus(LivingEntity entity) {
        float curseMultiplier = 0.0f;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            curseMultiplier = VPUtil.getCurseMultiplier(player, 2);
        }
        float shieldBonus = entity.getPersistentData().m_128457_("VPShieldBonusDonut") + entity.getPersistentData().m_128457_("VPShieldBonusFlower") + entity.getPersistentData().m_128457_("VPAcsShields") + entity.getPersistentData().m_128457_("VPRuneBonus") - entity.getPersistentData().m_128457_("VPIgnis") - curseMultiplier;
        if (entity.getPersistentData().m_128454_("VPBallDebuff") > System.currentTimeMillis()) {
            shieldBonus = (float)((double)shieldBonus - (Double)ConfigHandler.COMMON.ballDebuff.get());
        }
        if (VPUtil.hasLyra(entity, 6)) {
            shieldBonus += 70.0f;
        }
        return shieldBonus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addShield(LivingEntity entity, float amount, boolean add) {
        Player player;
        float curseShield;
        float shield;
        if (entity.getPersistentData().m_128454_("VPSoulRottingStellar") >= System.currentTimeMillis() && (double)VPUtil.getSoulIntegrity(entity) < (double)VPUtil.getMaxSoulIntegrity(entity) * 0.9) {
            return;
        }
        CompoundTag tag = entity.getPersistentData();
        float shieldBonus = VPUtil.getShieldBonus(entity);
        if (!add) {
            if (!(amount * (1.0f + shieldBonus / 100.0f) > tag.m_128457_("VPShield"))) return;
            shield = amount * (1.0f + shieldBonus / 100.0f);
        } else {
            shield = tag.m_128457_("VPShield") + amount * (1.0f + shieldBonus / 100.0f);
        }
        if (entity instanceof Player && (curseShield = VPUtil.getCurseMultiplier(player = (Player)entity, 5)) != 0.0f) {
            VPUtil.cursedShield(player, curseShield, shield);
            return;
        }
        Random random = new Random();
        if (tag.m_128454_("VPAntiShield") < System.currentTimeMillis()) {
            if (entity instanceof Player) {
                Player player2 = (Player)entity;
                if (VPUtil.hasVestige((Item)ModItems.SOULBLIGHTER.get(), player2) && random.nextDouble() < VPUtil.getChance(0.2, player2)) {
                    VPUtil.addOverShield((LivingEntity)player2, shield * 0.05f, false);
                }
            }
            tag.m_128350_("VPShield", shield);
            if (entity instanceof Player) {
                Player player3 = (Player)entity;
                if (VPUtil.hasVestige((Item)ModItems.DONUT.get(), player3)) {
                    VPUtil.addRadiance(SweetDonut.class, 10, player3);
                }
            }
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player4 = (ServerPlayer)entity;
            PacketHandler.sendToClient(new SendPlayerNbtToClient(player4.m_20148_(), player4.getPersistentData()), player4);
        } else if (!entity.m_20193_().f_46443_) {
            PacketHandler.sendToClients(PacketDistributor.TRACKING_ENTITY.with(() -> entity), new SendEntityNbtToClient(entity.getPersistentData(), entity.m_19879_()));
        }
        if (tag.m_128457_("VPShieldInit") != 0.0f) return;
        tag.m_128350_("VPShieldInit", shield);
        VPUtil.play(entity, (SoundEvent)SoundRegistry.SHIELD.get());
    }

    public static float getShield(LivingEntity entity) {
        return entity.getPersistentData().m_128457_("VPShield");
    }

    public static float getOverShield(LivingEntity entity) {
        return entity.getPersistentData().m_128457_("VPOverShield");
    }

    public static void deadInside(LivingEntity entity, Player player) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            PacketHandler.sendToClient(new PlayerFlyPacket(8), serverPlayer);
        }
        if (VPUtil.isNpc(entity.m_6095_())) {
            return;
        }
        Random random = new Random();
        if (entity instanceof Player || VPUtil.isBoss(entity) || VPUtil.isEmpoweredMob(entity)) {
            if (random.nextDouble() < 0.5) {
                VPUtil.play(entity, (SoundEvent)SoundRegistry.DEATH1.get());
            } else {
                VPUtil.play(entity, (SoundEvent)SoundRegistry.DEATH2.get());
            }
        }
        entity.f_19802_ = 0;
        entity.m_6469_(player.m_269291_().m_269075_(player), 0.0f);
        entity.m_6598_(player);
        VPUtil.antiResurrect(entity, deathTime + System.currentTimeMillis());
        VPUtil.setRoflanEbalo(entity, deathTime + System.currentTimeMillis());
        if (VPUtil.hasVestige((Item)ModItems.SOULBLIGHTER.get(), player)) {
            ItemStack stack = VPUtil.getVestigeStack(SoulBlighter.class, player);
            stack.m_41784_().m_128350_("VPSoulPool", stack.m_41784_().m_128457_("VPSoulPool") + SoulBlighter.getPrice(entity.m_21233_()));
        }
        VPUtil.setHealth(entity, 0.0f);
        entity.m_6667_(new DamageSource(player.m_269291_().m_287172_().m_269150_(), (Entity)player));
        VPUtil.despawn(entity);
    }

    public static void deadInside(LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            PacketHandler.sendToClient(new PlayerFlyPacket(8), serverPlayer);
        }
        if (VPUtil.isNpc(entity.m_6095_()) || entity.m_213877_()) {
            return;
        }
        Random random = new Random();
        if (entity instanceof Player || VPUtil.isBoss(entity) || VPUtil.isEmpoweredMob(entity)) {
            if (random.nextDouble() < 0.5) {
                VPUtil.play(entity, (SoundEvent)SoundRegistry.DEATH1.get());
            } else {
                VPUtil.play(entity, (SoundEvent)SoundRegistry.DEATH2.get());
            }
        }
        entity.f_19802_ = 0;
        entity.m_6469_(entity.m_269291_().m_287172_(), 0.0f);
        VPUtil.antiResurrect(entity, deathTime + System.currentTimeMillis());
        VPUtil.setRoflanEbalo(entity, deathTime + System.currentTimeMillis());
        VPUtil.setHealth(entity, 0.0f);
        entity.m_6667_(entity.m_269291_().m_287172_());
        VPUtil.despawn(entity);
    }

    public static List<LivingEntity> ray(Player player, float range, int maxDist, boolean stopWhenFound) {
        Vector3 target = Vector3.fromEntityCenter((Entity)player);
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        for (int distance = 1; distance < maxDist; ++distance) {
            target = target.add(new Vector3(player.m_20154_()).multiply(distance)).add(0.0, 0.5, 0.0);
            List list = player.m_20193_().m_45976_(LivingEntity.class, new AABB(target.x - (double)range, target.y - (double)range, target.z - (double)range, target.x + (double)range, target.y + (double)range, target.z + (double)range));
            list.removeIf(entity -> entity == player || !player.m_142582_((Entity)entity));
            for (LivingEntity entity2 : list) {
                if (entities.contains(entity2)) continue;
                entities.add(entity2);
            }
            if (stopWhenFound && entities.size() > 0) break;
        }
        return entities;
    }

    public static List<LivingEntity> rayClass(Class clas, Player player, float range, int maxDist, boolean stopWhenFound) {
        Vector3 target = Vector3.fromEntityCenter((Entity)player);
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        for (int distance = 1; distance < maxDist; ++distance) {
            target = target.add(new Vector3(player.m_20154_()).multiply(distance)).add(0.0, 0.5, 0.0);
            List list = player.m_20193_().m_45976_(clas, new AABB(target.x - (double)range, target.y - (double)range, target.z - (double)range, target.x + (double)range, target.y + (double)range, target.z + (double)range));
            list.removeIf(entity -> entity == player || !player.m_142582_((Entity)entity));
            for (Object entity2 : list) {
                if (entities.contains(entity2)) continue;
                entities.add((LivingEntity)entity2);
            }
            if (stopWhenFound && entities.size() > 0) break;
        }
        return entities;
    }

    public static void fall(LivingEntity entity, double power) {
        Vec3 motion = new Vec3(0.0, power, 0.0);
        entity.m_6001_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PacketHandler.sendToClient(new PlayerFlyPacket(-1), player);
        }
    }

    public static float getHealBonus(LivingEntity entity) {
        CompoundTag tag = entity.getPersistentData();
        float poison = 0.0f;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (VPUtil.isPoisonedByNightmare(player)) {
                poison = 150.0f;
            }
            poison += VPUtil.getCurseMultiplier(player, 2);
        }
        float healBonus = Math.max(-300.0f, tag.m_128457_("VPHealResMask") + tag.m_128457_("VPHealResFlower") + tag.m_128457_("VPHealBonusDonut") + tag.m_128457_("VPHealBonusDonutPassive") + tag.m_128457_("VPAcsHeal") - entity.getPersistentData().m_128457_("VPIgnis") - poison);
        if (entity.getPersistentData().m_128454_("VPLyra3") > System.currentTimeMillis()) {
            healBonus += 90.0f;
        }
        return healBonus;
    }

    public static double calculatePercentageDifference(double number1, double number2) {
        if (number1 == number2) {
            return 0.0;
        }
        double average = (number1 + number2) / 2.0;
        double difference = Math.abs(number1 - number2);
        return difference / average * 100.0;
    }

    public static boolean isBoss(LivingEntity entity) {
        for (EntityType<?> type : bossList) {
            if (entity.m_6095_() != type) continue;
            return true;
        }
        return VPUtil.isCustomBoss(entity.m_6095_());
    }

    public static boolean isNightmareBoss(LivingEntity entity) {
        return entity.getPersistentData().m_128471_("VPNightmareBoss");
    }

    public static boolean isNpc(EntityType<?> type) {
        return type.toString().contains("easy_npc");
    }

    public static boolean isNightmareBoss(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return VPUtil.isBoss(livingEntity) && entity.getPersistentData().m_128471_("VPNightmareBoss");
        }
        return false;
    }

    public static void dropEntityLoot(LivingEntity entity, Player player, boolean drop) {
        if (entity instanceof Player) {
            return;
        }
        Level level = player.m_20193_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ResourceLocation lootTableLocation = entity.m_5743_();
            LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(lootTableLocation);
            HashMap<LootContextParam, Object> lootparams = new HashMap<LootContextParam, Object>();
            lootparams.put(LootContextParams.f_81460_, entity.m_20182_());
            lootparams.put(LootContextParams.f_81455_, entity);
            lootparams.put(LootContextParams.f_81457_, player.m_269291_().m_269075_(player));
            LootParams params = new LootParams(serverLevel, lootparams, null, 1.0f);
            ObjectArrayList list = lootTable.m_287195_(params);
            for (ItemStack stack : list) {
                ItemEntity itemEntity = new ItemEntity((Level)serverLevel, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack);
                if (drop) {
                    serverLevel.m_7967_((Entity)itemEntity);
                    continue;
                }
                VPUtil.giveStack(stack, player);
            }
        }
    }

    public static void initWorlds() {
    }

    public static ResourceKey<Level> getWorldKey(String path, String directory) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(directory, path));
        return key;
    }

    public static HashMap<String, List<Item>> getRareDrops() {
        return rareDrops;
    }

    public static List<Item> getRareDrops(LivingEntity livingEntity) {
        return rareDrops.get(livingEntity.m_6095_().m_20675_());
    }

    public static void initRareDrops(List<LivingEntity> list, MinecraftServer server) {
        for (LivingEntity livingEntity : list) {
            LootTable lootTable = server.m_278653_().m_278676_(livingEntity.m_5743_());
            ArrayList<Item> rareList = new ArrayList<Item>();
            for (LootPool pool : ((LootTableVzlom)lootTable).getPools()) {
                for (LootPoolEntryContainer entry : ((LootPoolMixin)pool).getEntries()) {
                    if (!(entry instanceof LootItem)) continue;
                    LootItem lootItemEntry = (LootItem)entry;
                    Item item = ((LootItemMixin)lootItemEntry).getItem();
                    for (LootItemCondition condition : ((LootPoolMixin)pool).getConditions()) {
                        LootItemRandomChanceWithLootingCondition lootingCondition;
                        float chance;
                        if (condition instanceof LootItemRandomChanceCondition) {
                            LootItemRandomChanceCondition itemCondition = (LootItemRandomChanceCondition)condition;
                            chance = ((LootRandomItemMixin)itemCondition).getChance();
                            if (!((double)chance <= (Double)ConfigHandler.COMMON.rareItemChance.get() + 0.001)) continue;
                            rareList.add(item);
                            continue;
                        }
                        if (!(condition instanceof LootItemRandomChanceWithLootingCondition) || !((double)(chance = ((LootItemEnchantMixin)(lootingCondition = (LootItemRandomChanceWithLootingCondition)condition)).getChance()) <= (Double)ConfigHandler.COMMON.rareItemChance.get() + 0.001)) continue;
                        rareList.add(item);
                    }
                }
            }
            rareDrops.put(livingEntity.m_6095_().m_20675_(), rareList);
            hashRares.addAll(rareList);
        }
        hashRares.add((Item)ModItems.CORRUPT_FRAGMENT.get());
        hashRares.add((Item)ModItems.CORRUPT_ITEM.get());
        hashRares.add((Item)ModItems.CHAOS_ORB.get());
    }

    public static MobEffect getRandomEffect(boolean isBenefit) {
        ArrayList<String> blacklist = new ArrayList<String>(Arrays.asList(ConfigHandler.COMMON.debuffBlacklist.get().toString().split(",")));
        Random random = new Random();
        ArrayList<MobEffect> effects = new ArrayList<MobEffect>();
        for (MobEffect element : ForgeRegistries.MOB_EFFECTS) {
            if (element.m_19486_() != isBenefit || blacklist.contains(element.m_19481_())) continue;
            effects.add(element);
        }
        int numba = random.nextInt(effects.size());
        MobEffect effect = (MobEffect)effects.get(numba);
        return effect;
    }

    public static List<MobEffectInstance> getEffectsHas(LivingEntity entity, boolean isBenefit) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (MobEffectInstance effectInstance : entity.m_21220_()) {
            MobEffect effect = effectInstance.m_19544_();
            if (effect.m_19486_() != isBenefit) continue;
            effects.add(effectInstance);
        }
        return effects;
    }

    public static void clearEffects(LivingEntity entity, boolean isBeneficial) {
        ArrayList list = new ArrayList(entity.m_21220_());
        for (MobEffectInstance instance : list) {
            MobEffect effect = instance.m_19544_();
            if (effect.m_19486_() != isBeneficial) continue;
            entity.m_21195_(effect);
        }
    }

    public static List<ItemStack> getAllEquipment(LivingEntity entity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : entity.m_6168_()) {
            list.add(stack);
        }
        list.add(entity.m_21205_());
        list.add(entity.m_21206_());
        return list;
    }

    public static void repairAll(Player player, int totalDamage) {
        for (ItemStack stack : VPUtil.getAllEquipment((LivingEntity)player)) {
            int damage = stack.m_41773_();
            if (damage < totalDamage) {
                stack.m_41721_(0);
                totalDamage -= damage;
                continue;
            }
            stack.m_41721_(damage - totalDamage);
            totalDamage = 0;
        }
        if (totalDamage > 0) {
            player.m_6756_(totalDamage);
        }
    }

    public static void negativnoEnchant(LivingEntity entity, Player player) {
        int count = 0;
        for (ItemStack stack : VPUtil.getAllEquipment(entity)) {
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
            HashSet copy = new HashSet(enchantments.keySet());
            if (enchantments.isEmpty()) continue;
            for (Enchantment enchantment : copy) {
                if (stack.getEnchantmentLevel(enchantment) < 0 || enchantment.m_6589_()) continue;
                int lvl = (Integer)enchantments.get(enchantment);
                enchantments.remove(enchantment);
                enchantments.put(enchantment, lvl * -1);
                ++count;
            }
            stack.m_41784_().m_128379_("VPEnchant", true);
        }
        entity.getPersistentData().m_128356_("VPEnchant", System.currentTimeMillis() + 15000L);
        VPUtil.addRadiance(Book.class, count * 3, player);
    }

    public static void negativnoDisenchant(LivingEntity entity) {
        for (ItemStack stack : VPUtil.getAllEquipment(entity)) {
            Map enchantments;
            if (!stack.m_41784_().m_128471_("VPEnchant") || (enchantments = EnchantmentHelper.m_44831_((ItemStack)stack)).isEmpty()) continue;
            for (Enchantment enchantment : enchantments.keySet()) {
                if (stack.getEnchantmentLevel(enchantment) < 0 || enchantment.m_6589_()) continue;
                int lvl = (Integer)enchantments.get(enchantment);
                enchantments.remove(enchantment);
                enchantments.put(enchantment, lvl * -1);
            }
            stack.m_41784_().m_128379_("VPEnchant", false);
        }
    }

    public static void enchantCurseAll(LivingEntity entity) {
        for (ItemStack stack : VPUtil.getAllEquipment(entity)) {
            stack.m_41785_().clear();
            ArrayList list = new ArrayList(ForgeRegistries.ENCHANTMENTS.getValues());
            for (Enchantment enchantment : list) {
                if (!enchantment.m_6589_()) continue;
                stack.m_41663_(enchantment, 1);
            }
        }
    }

    public static String generateRandomDamageType() {
        Random random = new Random();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(VPUtil.damageSubtypes().split(",")));
        return (String)list.get(random.nextInt(list.size()));
    }

    public static void damageAdoption(LivingEntity entity, LivingDamageEvent event) {
        int damage = entity.getPersistentData().m_128451_("VPPrismDamage");
        if (damage == 0) {
            return;
        }
        List<DamageSource> sources = VPUtil.playerDamageSources(entity, entity);
        DamageSource weak = sources.get(damage - 1);
        if (event.getSource().m_19385_().equals(weak.m_19385_())) {
            event.setAmount(event.getAmount() * 2.0f);
        } else {
            event.setAmount(0.0f);
        }
    }

    public static void suckToPos(Entity entity, BlockPos targetPos, double maxPullStrength) {
        Vec3 targetVec = Vec3.m_82512_((Vec3i)targetPos);
        Vec3 entityVec = entity.m_20182_();
        Vec3 direction = targetVec.m_82546_(entityVec);
        double distance = direction.m_82553_();
        Vec3 normalizedDirection = direction.m_82541_();
        double pullStrength = Math.min(maxPullStrength, distance / 10.0);
        Vec3 pullVelocity = normalizedDirection.m_82490_(pullStrength);
        entity.m_20334_(pullVelocity.f_82479_, pullVelocity.f_82480_, pullVelocity.f_82481_);
    }

    public static Multimap<Attribute, AttributeModifier> createAttributeMap(LivingEntity entity, Attribute attribute, UUID uuid, float amount, AttributeModifier.Operation operation, String name) {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)attribute, (Object)new AttributeModifier(uuid, name, (double)amount, operation));
        return attributesDefault;
    }

    public static List<LivingEntity> getMonstersAround(Player player, double x, double y, double z) {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (LivingEntity entity : player.m_20193_().m_45976_(LivingEntity.class, new AABB(player.m_20185_() + x, player.m_20186_() + y, player.m_20189_() + z, player.m_20185_() - x, player.m_20186_() - y, player.m_20189_() - z))) {
            if (entity instanceof Animal || entity == player) continue;
            list.add(entity);
        }
        return list;
    }

    public static List<LivingEntity> getCreaturesAround(Player player, double x, double y, double z) {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (LivingEntity entity : player.m_20193_().m_45976_(LivingEntity.class, new AABB(player.m_20185_() + x, player.m_20186_() + y, player.m_20189_() + z, player.m_20185_() - x, player.m_20186_() - y, player.m_20189_() - z))) {
            if (!(entity instanceof Animal)) continue;
            list.add(entity);
        }
        return list;
    }

    public static boolean isDamagePhysical(DamageSource source) {
        return !source.m_276093_(DamageTypes.f_268724_) && !source.m_276093_(DamageTypes.f_268722_) && !source.m_276093_(DamageTypes.f_268546_) && !source.m_276093_(DamageTypes.f_268450_) && !source.m_276093_(DamageTypes.f_268444_) && !source.m_276093_(DamageTypes.f_268631_) && !source.m_276093_(DamageTypes.f_268515_) && !source.m_269533_(DamageTypeTags.f_268738_) && !source.m_269533_(DamageTypeTags.f_268413_) && !source.m_269533_(DamageTypeTags.f_268437_);
    }

    public static boolean isFriendlyFireBetween(Entity attacker, Entity target) {
        if (attacker == null || target == null) {
            return false;
        }
        Team team = attacker.m_5647_();
        if (team != null) {
            return team.m_83536_(target.m_5647_()) && !team.m_6260_();
        }
        return attacker.m_7307_(target);
    }

    public static boolean isProtectedFromHit(Player attacker, Entity target) {
        Player player;
        LivingEntity livingEntity;
        if (attacker == null || target == null) {
            return false;
        }
        if (NoGriefCompat.ngLoaded() && target instanceof LivingEntity && !NoGriefCompat.canHurt(livingEntity = (LivingEntity)target, attacker)) {
            return true;
        }
        if (attacker == target) {
            return false;
        }
        if (target instanceof Player && (player = (Player)target).m_7500_()) {
            return true;
        }
        if (VPUtil.isNpc(target.m_6095_())) {
            return true;
        }
        if (attacker.getPersistentData().m_128403_("VPSlave") && attacker.getPersistentData().m_128342_("VPSlave").compareTo(target.m_20148_()) == 0) {
            return true;
        }
        if (target.getPersistentData().m_128403_("VPPlayer") && target.getPersistentData().m_128342_("VPPlayer").compareTo(attacker.m_20148_()) == 0) {
            return true;
        }
        boolean[] friend = new boolean[]{false};
        if (VPUtil.isFriendlyFireBetween((Entity)attacker, target)) {
            return true;
        }
        attacker.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> {
            for (String name : cap.getFriends().split(",")) {
                Player targetPlayer;
                if ((name.isEmpty() || !target.m_5446_().equals(name) && !target.m_6095_().m_20675_().equals(name) && !target.m_6095_().m_20675_().contains(name) && (!target.m_8077_() || !target.m_7770_().getString().contains(name))) && (!(target instanceof Player) || !(targetPlayer = (Player)target).m_7755_().getString().equals(name))) continue;
                friend[0] = true;
            }
        });
        return friend[0];
    }

    public static void spawnParticles(Entity player, ParticleOptions particle, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ) {
        Random random = new Random();
        for (int i = 0; i < count; ++i) {
            x = random.nextDouble() < 0.5 ? (x += random.nextDouble()) : (x -= random.nextDouble());
            y = random.nextDouble() < 0.5 ? (y += random.nextDouble()) : (y -= random.nextDouble());
            z = random.nextDouble() < 0.5 ? (z += random.nextDouble()) : (z -= random.nextDouble());
            for (LivingEntity entity : VPUtil.getEntitiesAround(player, 20.0, 20.0, 20.0, true)) {
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketHandler.sendToClient(new ParticlePacket(VPUtilParticles.getParticleId(particle), x, y, z, deltaX, deltaY, deltaZ), serverPlayer);
            }
        }
    }

    public static void spawnParticle(Entity entity, ParticleOptions particle, double x, double y, double z, double deltaX, double deltaY, double deltaZ) {
        for (LivingEntity livingEntity : VPUtil.getEntitiesAround(entity, 30.0, 30.0, 30.0, true)) {
            if (!(livingEntity instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            PacketHandler.sendToClient(new ParticlePacket(VPUtilParticles.getParticleId(particle), x, y, z, deltaX, deltaY, deltaZ), serverPlayer);
        }
    }

    public static void spawnParticles(Player player, ParticleOptions particle, double radius, int count, double deltaX, double deltaY, double deltaZ, double speed, boolean force) {
        double startX = player.m_20185_() - radius;
        double startY = player.m_20186_() - radius;
        double startZ = player.m_20189_() - radius;
        double endX = player.m_20185_() + radius;
        double endY = player.m_20186_() + radius;
        double endZ = player.m_20189_() + radius;
        Random random = new Random();
        if (count == 1) {
            count = random.nextInt(10) + 20;
        }
        for (int i = 0; i < count; ++i) {
            double x = startX + (endX - startX) * random.nextDouble();
            double y = startY + (endY - startY) * random.nextDouble();
            double z = startZ + (endZ - startZ) * random.nextDouble();
            for (LivingEntity entity : VPUtil.getEntitiesAround(player, 20.0, 20.0, 20.0, true)) {
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketHandler.sendToClient(new ParticlePacket(VPUtilParticles.getParticleId(particle), x, y, z, deltaX, deltaY, deltaZ), serverPlayer);
            }
        }
    }

    public static void spawnParticles(Player player, ParticleOptions particle, double radius, int count, double deltaX, double deltaY, double deltaZ, double color1, double color2, double color3) {
        double startX = player.m_20185_() - radius;
        double startY = player.m_20186_() - radius;
        double startZ = player.m_20189_() - radius;
        double endX = player.m_20185_() + radius;
        double endY = player.m_20186_() + radius;
        double endZ = player.m_20189_() + radius;
        Random random = new Random();
        if (count == 1) {
            count = random.nextInt(10) + 20;
        }
        for (int i = 0; i < count; ++i) {
            double x = startX + (endX - startX) * random.nextDouble();
            double y = startY + (endY - startY) * random.nextDouble();
            double z = startZ + (endZ - startZ) * random.nextDouble();
            for (LivingEntity entity : VPUtil.getEntitiesAround(player, 20.0, 20.0, 20.0, true)) {
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketHandler.sendToClient(new ParticlePacket(VPUtilParticles.getParticleId(particle), x, y, z, deltaX, deltaY, deltaZ, color1, color2, color3), serverPlayer);
            }
        }
    }

    public static List<LivingEntity> getCreaturesAndPlayersAround(Player player, double x, double y, double z) {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (LivingEntity entity : player.m_20193_().m_45976_(LivingEntity.class, new AABB(player.m_20185_() + x, player.m_20186_() + y, player.m_20189_() + z, player.m_20185_() - x, player.m_20186_() - y, player.m_20189_() - z))) {
            if (!(entity instanceof Animal) && !(entity instanceof Player)) continue;
            list.add(entity);
        }
        return list;
    }

    public static void rayParticles(Player player, ParticleOptions particle, double distance, double radius, int count, double deltaX, double deltaY, double deltaZ, double speed, boolean force) {
        Random random = new Random();
        BlockPos pos = VPUtil.rayCords((LivingEntity)player, player.m_20193_(), distance);
        double startX = (double)pos.m_123341_() - radius;
        double startY = (double)pos.m_123342_() - radius;
        double startZ = (double)pos.m_123343_() - radius;
        double endX = (double)pos.m_123341_() + radius;
        double endY = (double)pos.m_123342_() + radius;
        double endZ = (double)pos.m_123343_() + radius;
        for (int i = 0; i < count; ++i) {
            double x = startX + (endX - startX) * random.nextDouble();
            double y = startY + (endY - startY) * random.nextDouble();
            double z = startZ + (endZ - startZ) * random.nextDouble();
            for (LivingEntity entity : VPUtil.getEntitiesAround(player, 20.0, 20.0, 20.0, true)) {
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketHandler.sendToClient(new ParticlePacket(VPUtilParticles.getParticleId(particle), x, y, z, deltaX, deltaY, deltaZ), serverPlayer);
            }
        }
    }

    public static BlockPos rayCords(LivingEntity entity, Level level, double distance) {
        BlockPos finalBlockPos;
        Vec3 eyePosition = entity.m_20299_(1.0f);
        Vec3 viewDirection = entity.m_20252_(1.0f);
        Vec3 targetPosition = eyePosition.m_82520_(viewDirection.f_82479_ * distance, viewDirection.f_82480_ * distance, viewDirection.f_82481_ * distance);
        BlockHitResult hitResult = level.m_45547_(new ClipContext(eyePosition, targetPosition, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity));
        Vec3i what = new Vec3i((int)(viewDirection.f_82479_ * distance), (int)(viewDirection.f_82480_ * distance), (int)(viewDirection.f_82481_ * distance));
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            finalBlockPos = hitResult.m_82425_();
        } else {
            Vec3 end = eyePosition.m_82549_(entity.m_20154_().m_82490_(distance));
            finalBlockPos = new BlockPos((int)end.f_82479_, (int)end.f_82480_, (int)end.f_82481_);
        }
        return finalBlockPos;
    }

    public static void play(LivingEntity main, SoundEvent sound, double x, double y, double z, float volume) {
        for (LivingEntity entity : VPUtil.getEntitiesAround(main, 20.0, 20.0, 20.0, true)) {
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity;
            PacketHandler.sendToClient(new SoundPacket(sound.m_11660_(), volume, 1.0f, x, y, z), player);
        }
    }

    public static void play(LivingEntity main, SoundEvent sound) {
        for (LivingEntity entity : VPUtil.getEntitiesAround(main, 20.0, 20.0, 20.0, true)) {
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity;
            if (!soundCd.containsKey(sound)) {
                soundCd.put(sound, 0L);
            }
            if (soundCd.get(sound) < System.currentTimeMillis()) {
                PacketHandler.sendToClient(new SoundPacket(sound.m_11660_(), 1.0f, 1.0f, 0.0, 0.0, 0.0), player);
            }
            soundCd.put(sound, System.currentTimeMillis() + 100L);
        }
    }

    public static void cursedShield(Player player, float curseMultiplier, float shield) {
        for (LivingEntity livingEntity : VPUtil.getEntities(player, 30.0, false)) {
            if (VPUtil.isProtectedFromHit(player, (Entity)livingEntity)) continue;
            CompoundTag tag = livingEntity.getPersistentData();
            float entityShield = VPUtil.getShield(livingEntity);
            float entityOverShield = VPUtil.getOverShield(livingEntity);
            if (entityShield > shield * curseMultiplier) {
                tag.m_128350_("VPShield", entityShield - shield * curseMultiplier);
            } else {
                tag.m_128350_("VPShield", 0.0f);
            }
            if (entityOverShield > shield * curseMultiplier) {
                tag.m_128350_("VPOverShield", entityOverShield - shield * curseMultiplier);
                continue;
            }
            tag.m_128350_("VPOverShield", 0.0f);
        }
        VPUtil.sync(player);
    }

    public static void addOverShield(LivingEntity entity, float amount, boolean applyBonus) {
        Player player;
        if (entity.getPersistentData().m_128454_("VPSoulRottingStellar") >= System.currentTimeMillis() && (double)VPUtil.getSoulIntegrity(entity) < (double)VPUtil.getMaxSoulIntegrity(entity) * 0.9) {
            return;
        }
        CompoundTag tag = entity.getPersistentData();
        if (tag.m_128457_("VPOverShield") <= 0.0f) {
            VPUtil.play(entity, (SoundEvent)SoundRegistry.OVERSHIELD.get());
            tag.m_128350_("VPOverShieldMax", 0.0f);
        }
        float shieldBonus = VPUtil.getShieldBonus(entity);
        if (!applyBonus) {
            shieldBonus = 0.0f;
        }
        float shield = tag.m_128457_("VPOverShield") + amount * (1.0f + shieldBonus / 100.0f);
        if (tag.m_128454_("VPAntiShield") < System.currentTimeMillis()) {
            float curseShield;
            if (entity instanceof Player && (curseShield = VPUtil.getCurseMultiplier(player = (Player)entity, 5)) != 0.0f) {
                VPUtil.cursedShield(player, curseShield, shield);
                return;
            }
            tag.m_128350_("VPOverShield", shield);
            if (entity instanceof Player) {
                player = (Player)entity;
                if (VPUtil.hasVestige((Item)ModItems.RUNE.get(), player)) {
                    VPUtil.addRadiance(Rune.class, 5, player);
                }
            }
        }
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            PacketHandler.sendToClient(new SendPlayerNbtToClient(player.m_20148_(), player.getPersistentData()), (ServerPlayer)player);
        } else if (!entity.m_20193_().f_46443_) {
            PacketHandler.sendToClients(PacketDistributor.TRACKING_ENTITY.with(() -> entity), new SendEntityNbtToClient(entity.getPersistentData(), entity.m_19879_()));
        }
        if (tag.m_128457_("VPOverShieldMax") < shield || tag.m_128457_("VPOverShieldMax") <= 0.0f) {
            tag.m_128350_("VPOverShieldMax", shield);
        }
    }

    public static void regenOverShield(LivingEntity entity, float amount) {
        Player player;
        if (entity.getPersistentData().m_128454_("VPSoulRottingStellar") >= System.currentTimeMillis() && (double)VPUtil.getSoulIntegrity(entity) < (double)VPUtil.getMaxSoulIntegrity(entity) * 0.9) {
            return;
        }
        CompoundTag tag = entity.getPersistentData();
        float shieldBonus = VPUtil.getShieldBonus(entity);
        if (tag.m_128457_("VPOverShield") <= 0.0f) {
            return;
        }
        float shield = tag.m_128457_("VPOverShield") + amount * (1.0f + shieldBonus / 100.0f);
        if (tag.m_128454_("VPAntiShield") < System.currentTimeMillis()) {
            float curseShield;
            if (entity instanceof Player && (curseShield = VPUtil.getCurseMultiplier(player = (Player)entity, 5)) != 0.0f) {
                VPUtil.cursedShield(player, curseShield, shield);
                return;
            }
            if (tag.m_128457_("VPOverShieldMax") <= 0.0f) {
                tag.m_128350_("VPOverShield", shield);
                tag.m_128350_("VPOverShieldMax", shield);
            } else {
                tag.m_128350_("VPOverShield", Math.min(tag.m_128457_("VPOverShieldMax"), shield));
            }
        }
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            PacketHandler.sendToClient(new SendPlayerNbtToClient(player.m_20148_(), player.getPersistentData()), (ServerPlayer)player);
        } else if (!entity.m_20193_().f_46443_) {
            PacketHandler.sendToClients(PacketDistributor.TRACKING_ENTITY.with(() -> entity), new SendEntityNbtToClient(entity.getPersistentData(), entity.m_19879_()));
        }
    }

    public static void stealShields(LivingEntity entity, LivingEntity stealer, float percent, boolean applyBonus) {
        ServerPlayer player;
        if (stealer.getPersistentData().m_128451_("VPSoulRotting") >= 10) {
            return;
        }
        CompoundTag tag = entity.getPersistentData();
        float shieldBonus = VPUtil.getShieldBonus(stealer);
        if (!applyBonus) {
            shieldBonus = 0.0f;
        }
        float stolenShield = tag.m_128457_("VPShield") * (percent / 100.0f) * (1.0f + shieldBonus / 100.0f);
        float shield = stealer.getPersistentData().m_128457_("VPShield") + stolenShield;
        float stolenOverShield = tag.m_128457_("VPOverShield") * (percent / 100.0f) * (1.0f + shieldBonus / 100.0f);
        float overShield = stealer.getPersistentData().m_128457_("VPOverShield") + stolenOverShield;
        if (stealer.getPersistentData().m_128457_("VPOverShield") <= 0.0f && overShield > 0.0f) {
            VPUtil.play(entity, (SoundEvent)SoundRegistry.OVERSHIELD.get());
        }
        if (stealer.getPersistentData().m_128457_("VPShield") <= 0.0f && shield > 0.0f) {
            VPUtil.play(entity, (SoundEvent)SoundRegistry.SHIELD.get());
        }
        if (stealer.getPersistentData().m_128454_("VPAntiShield") < System.currentTimeMillis()) {
            float curseShield;
            tag.m_128350_("VPShield", Math.max(0.0f, tag.m_128457_("VPShield") - stolenShield));
            tag.m_128350_("VPOverShield", Math.max(0.0f, tag.m_128457_("VPOverShield") - stolenOverShield));
            if (stealer instanceof Player && (curseShield = VPUtil.getCurseMultiplier((Player)(player = (Player)stealer), 5)) != 0.0f) {
                VPUtil.cursedShield((Player)player, curseShield, shield);
                VPUtil.cursedShield((Player)player, curseShield, overShield);
                return;
            }
            stealer.getPersistentData().m_128350_("VPShield", shield);
            stealer.getPersistentData().m_128350_("VPOverShield", overShield);
        }
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            PacketHandler.sendToClient(new SendPlayerNbtToClient(player.m_20148_(), player.getPersistentData()), player);
        } else if (!entity.m_20193_().f_46443_) {
            PacketHandler.sendToClients(PacketDistributor.TRACKING_ENTITY.with(() -> entity), new SendEntityNbtToClient(entity.getPersistentData(), entity.m_19879_()));
        }
        if (stealer.getPersistentData().m_128457_("VPOverShieldMax") < shield) {
            stealer.getPersistentData().m_128350_("VPOverShieldMax", shield);
        }
    }

    public static ResourceLocation getCurrentBiome(Player player) {
        Level level = player.m_20193_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = player.m_20183_();
            return ((ResourceKey)serverLevel.m_7062_().m_204214_(pos).m_203543_().get()).m_135782_();
        }
        return null;
    }

    public static void initEffects() {
        for (MobEffect effect : ForgeRegistries.MOB_EFFECTS) {
            effects.add(effect);
        }
    }

    public static HashSet<MobEffect> getEffects() {
        return effects;
    }

    public static List<String> getEffectsLeft(String list) {
        ArrayList<String> effectList = new ArrayList<String>(Arrays.asList(VPUtil.filterString(list).split(",")));
        ArrayList<String> allList = new ArrayList<String>();
        for (MobEffect effect : effects) {
            allList.add(effect.m_19481_());
        }
        allList.removeAll(effectList);
        return allList;
    }

    public static List<String> getDamageKinds() {
        ArrayList<String> damageSourceNames = new ArrayList<String>();
        damageSourceNames.add("inFire");
        damageSourceNames.add("lightningBolt");
        damageSourceNames.add("onFire");
        damageSourceNames.add("lava");
        damageSourceNames.add("hotFloor");
        damageSourceNames.add("inWall");
        damageSourceNames.add("drown");
        damageSourceNames.add("starve");
        damageSourceNames.add("cactus");
        damageSourceNames.add("fall");
        damageSourceNames.add("flyIntoWall");
        damageSourceNames.add("outOfWorld");
        damageSourceNames.add("generic");
        damageSourceNames.add("magic");
        damageSourceNames.add("wither");
        damageSourceNames.add("anvil");
        damageSourceNames.add("fallingBlock");
        damageSourceNames.add("dragonBreath");
        damageSourceNames.add("sweetBerryBush");
        damageSourceNames.add("freeze");
        damageSourceNames.add("fallingStalactite");
        damageSourceNames.add("stalagmite");
        damageSourceNames.add("sting");
        damageSourceNames.add("mob");
        damageSourceNames.add("player");
        damageSourceNames.add("arrow");
        damageSourceNames.add("trident");
        damageSourceNames.add("fireworks");
        damageSourceNames.add("witherSkull");
        damageSourceNames.add("indirectMagic");
        damageSourceNames.add("thorns");
        damageSourceNames.add("explosion");
        damageSourceNames.add("sonic_boom");
        return damageSourceNames;
    }

    public static List<String> getDamageKindsLeft(String list) {
        ArrayList<String> damageList = new ArrayList<String>(Arrays.asList(VPUtil.filterString(list).split(",")));
        ArrayList<String> allList = new ArrayList<String>(VPUtil.getDamageKinds());
        allList.removeAll(damageList);
        return allList;
    }

    public static List<String> getRareItemsLeft(String list, Player player) {
        ArrayList<String> rareList = new ArrayList<String>(Arrays.asList(VPUtil.filterString(list).split(",")));
        ArrayList<String> allList = new ArrayList<String>();
        for (Item item : hashRares) {
            allList.add(item.m_5524_());
        }
        allList.removeAll(rareList);
        player.getPersistentData().m_128359_("VPRaresClient", VPUtil.filterString(((Object)allList).toString()));
        return allList;
    }

    public static List<String> getOres() {
        ArrayList<String> ores = new ArrayList<String>();
        TagKey forgeOreTag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation("forge", "ores"));
        for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(forgeOreTag)) {
            ores.add(((Item)holder.m_203334_()).m_5524_());
        }
        for (Block block : blocks) {
            String name = block.m_7705_();
            if (!name.contains("_ore") || ores.contains(name)) continue;
            ores.add(name);
        }
        return ores;
    }

    public static List<String> getOresLeft(String list, Player player) {
        ArrayList<String> oreList = new ArrayList<String>(Arrays.asList(VPUtil.filterString(list).split(",")));
        ArrayList<String> allList = new ArrayList<String>();
        for (String item : VPUtil.getOres()) {
            allList.add(item);
        }
        allList.removeAll(oreList);
        player.getPersistentData().m_128359_("VPOresClient", VPUtil.filterString(((Object)allList).toString()));
        return allList;
    }

    public static List<String> getRaresClient(Player player) {
        return new ArrayList<String>(Arrays.asList(player.getPersistentData().m_128461_("VPRaresClient").split(",")));
    }

    public static double calculateCatchChance(float playerHealth, float entityMaxHealth, float entityHealth) {
        float base = 0.6f + (1.0f - entityHealth / entityMaxHealth);
        double probability = playerHealth >= entityMaxHealth ? (double)base : (double)(base * (float)Math.pow(0.95f, Math.abs(playerHealth - entityMaxHealth) / 10.0f));
        return probability * (Double)ConfigHandler.COMMON.soulBlighterChance.get();
    }

    public static EntityType<?> entityTypeFromNbt(CompoundTag nbtTagCompound) {
        ResourceLocation typeId = new ResourceLocation(nbtTagCompound.m_128461_("id"));
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(typeId);
    }

    public static void teleportRandomly(Entity entity, int radius) {
        Random random = new Random();
        Level world = entity.m_20193_();
        double originalX = entity.m_20185_();
        double originalY = entity.m_20186_();
        double originalZ = entity.m_20189_();
        for (int i = 0; i < 100 + radius; ++i) {
            double targetZ;
            double targetY;
            double targetX = originalX + (random.nextDouble() - 0.5) * 2.0 * (double)radius;
            if (!VPUtil.isSafeLocation(world, targetX, targetY = Math.min(Math.max(originalY + (double)(random.nextInt(2 * radius) - radius), 0.0), (double)(world.m_151558_() - 1)), targetZ = originalZ + (random.nextDouble() - 0.5) * 2.0 * (double)radius)) continue;
            entity.m_6021_(targetX, targetY, targetZ);
            break;
        }
    }

    public static boolean teleportRandomly(Entity entity, int radius, boolean water) {
        Random random = new Random();
        Level world = entity.m_20193_();
        double originalX = entity.m_20185_();
        double originalY = entity.m_20186_();
        double originalZ = entity.m_20189_();
        for (int i = 0; i < 100 + radius; ++i) {
            double targetZ;
            double targetY;
            double targetX = originalX + (random.nextDouble() - 0.5) * 2.0 * (double)radius;
            BlockPos blockPos = new BlockPos((int)targetX, (int)(targetY = Math.min(Math.max(originalY + (double)(random.nextInt(2 * radius) - radius), 0.0), (double)(world.m_151558_() - 1))), (int)(targetZ = originalZ + (random.nextDouble() - 0.5) * 2.0 * (double)radius));
            if (!world.m_46801_(blockPos.m_6630_(3)) || !world.m_46801_(blockPos) || !world.m_46801_(blockPos.m_122029_()) || !world.m_46801_(blockPos.m_122024_()) || !world.m_46801_(blockPos.m_122012_()) || !world.m_46801_(blockPos.m_122019_())) continue;
            entity.m_6021_(targetX, targetY, targetZ);
            return true;
        }
        return false;
    }

    public static BlockPos randomPos(Entity entity, int radius) {
        Random random = new Random();
        Level world = entity.m_20193_();
        double originalX = entity.m_20185_();
        double originalY = entity.m_20186_();
        double originalZ = entity.m_20189_();
        for (int i = 0; i < 100 + radius; ++i) {
            double targetZ;
            double targetY;
            double targetX = originalX + (random.nextDouble() - 0.5) * 2.0 * (double)radius;
            if (!VPUtil.isSafeLocation(world, targetX, targetY = Math.min(Math.max(originalY + (double)(random.nextInt(2 * radius) - radius), 0.0), (double)(world.m_151558_() - 1)), targetZ = originalZ + (random.nextDouble() - 0.5) * 2.0 * (double)radius)) continue;
            return new BlockPos((int)targetX, (int)targetY, (int)targetZ);
        }
        return null;
    }

    private static boolean isSafeLocation(Level world, double x, double y, double z) {
        BlockPos blockPos = new BlockPos((int)x, (int)y, (int)z);
        return world.m_46859_(blockPos) && world.m_46859_(blockPos.m_7494_()) && !world.m_46859_(blockPos.m_7495_());
    }

    public static void dealParagonDamage(LivingEntity entity, Player player, float damage, int type, boolean hurt) {
        float curseMultiplier;
        Armor armor;
        ItemStack stack;
        Item item;
        if (VPUtil.isProtectedFromHit(player, (Entity)entity) || entity.m_21224_()) {
            return;
        }
        player.getPersistentData().m_128379_("VPAttacked", true);
        entity.m_6598_(player);
        float health = damage * (1.0f + VPUtil.damagePercentBonus(player, type) / 100.0f);
        float overShields = VPUtil.getOverShield(entity);
        if (type != 5 && entity instanceof Player && VPUtil.hasStellarVestige((Item)ModItems.ARMOR.get(), player) && (item = (stack = VPUtil.getVestigeStack(Armor.class, player)).m_41720_()) instanceof Armor && (armor = (Armor)item).isUltimateActive(stack)) {
            VPUtil.dealParagonDamage((LivingEntity)player, entity, VPUtil.scalePower(damage * (3.0f + Armor.getPain(stack) / 10.0f), 11, player), 5, true);
        }
        if (entity.getPersistentData().m_128454_("VPBubble") > System.currentTimeMillis()) {
            Vestige vestige;
            ItemStack stack2;
            Item item2;
            VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.BUBBLE1.get());
            entity.getPersistentData().m_128356_("VPBubble", 0L);
            VPUtil.dealDamage(entity, player, player.m_269291_().m_269063_(), 1000.0f, 3);
            VPUtil.addRadiance(Whirlpool.class, VPUtil.getRadianceUltimate(), player);
            entity.getPersistentData().m_128356_("VPWet", System.currentTimeMillis() + 20000L);
            entity.getPersistentData().m_128350_("VPOverShield", overShields /= 2.0f);
            long time = 10000L;
            if (VPUtil.hasStellarVestige((Item)ModItems.WHIRLPOOL.get(), player) && (item2 = (stack2 = VPUtil.getVestigeStack(Whirlpool.class, player)).m_41720_()) instanceof Vestige && (vestige = (Vestige)item2).ultimateMaxTime(stack2) - vestige.ultimateDurationBase(stack2) > 0L) {
                time *= vestige.ultimateMaxTime(stack2) - vestige.ultimateDurationBase(stack2);
            }
            entity.getPersistentData().m_128356_("VPWhirlParagon", System.currentTimeMillis() + time);
        }
        if (entity.getPersistentData().m_128451_("VPBossType") == 7) {
            for (LivingEntity livingEntity : VPUtil.getEntitiesAround(entity, 20.0, 20.0, 20.0, false)) {
                if (!livingEntity.getPersistentData().m_128471_("VPSummoned")) continue;
                return;
            }
        }
        if (overShields > 0.0f) {
            if (entity.getPersistentData().m_128454_("VPWhirlParagon") > System.currentTimeMillis()) {
                health *= 8.0f;
            }
            if (overShields > health) {
                entity.getPersistentData().m_128350_("VPOverShield", overShields - health);
                return;
            }
            entity.getPersistentData().m_128350_("VPOverShield", 0.0f);
            health -= overShields;
        }
        if ((curseMultiplier = VPUtil.getCurseMultiplier(player, 4)) > 0.0f) {
            health *= curseMultiplier;
        }
        if (entity.m_21223_() - health > 0.0f) {
            VPUtil.setHealth(entity, entity.m_21223_() - health);
            if (hurt) {
                entity.m_6469_(player.m_269291_().m_269264_(), 0.0f);
            }
            if (entity instanceof Player) {
                Player deb = (Player)entity;
                if (VPUtil.hasVestige((Item)ModItems.RUNE.get(), deb) && (VPUtil.getShield((LivingEntity)deb) <= 0.0f || VPUtil.getOverShield((LivingEntity)deb) <= 0.0f)) {
                    if (VPUtil.getShield((LivingEntity)deb) <= 0.0f) {
                        VPUtil.addShield((LivingEntity)deb, health * 0.5f, false);
                    }
                    if (VPUtil.getOverShield((LivingEntity)deb) <= 0.0f) {
                        VPUtil.addOverShield((LivingEntity)deb, health * 0.5f, true);
                    }
                }
            }
        } else {
            if (VPUtil.hasVestige((Item)ModItems.TRIGON.get(), player)) {
                VPUtil.addRadiance(Trigon.class, 25, player);
            }
            VPUtil.deadInside(entity, player);
        }
    }

    public static void dealParagonDamage(LivingEntity entity, LivingEntity player, float damage, int type, boolean hurt) {
        Player playerEntity;
        float curseMultiplier;
        if (entity.m_21224_()) {
            return;
        }
        player.getPersistentData().m_128379_("VPAttacked", true);
        float health = damage;
        float overShields = VPUtil.getOverShield(entity);
        if (overShields > 0.0f) {
            if (overShields > health) {
                entity.getPersistentData().m_128350_("VPOverShield", overShields - health);
                return;
            }
            entity.getPersistentData().m_128350_("VPOverShield", 0.0f);
            health -= overShields;
        }
        if (player instanceof Player && (curseMultiplier = VPUtil.getCurseMultiplier(playerEntity = (Player)player, 4)) > 0.0f) {
            health *= curseMultiplier;
        }
        if (entity.m_21223_() - health > 0.0f) {
            if (hurt) {
                entity.m_6469_(player.m_269291_().m_269264_(), 0.0f);
            }
            entity.m_21153_(entity.m_21223_() - health);
            if (entity instanceof Player) {
                Player deb = (Player)entity;
                if (VPUtil.hasVestige((Item)ModItems.RUNE.get(), deb) && (VPUtil.getShield((LivingEntity)deb) <= 0.0f || VPUtil.getOverShield((LivingEntity)deb) <= 0.0f)) {
                    if (VPUtil.getShield((LivingEntity)deb) <= 0.0f) {
                        VPUtil.addShield((LivingEntity)deb, health * 0.5f, false);
                    }
                    if (VPUtil.getOverShield((LivingEntity)deb) <= 0.0f) {
                        VPUtil.addOverShield((LivingEntity)deb, health * 0.5f, true);
                    }
                }
            }
        } else {
            VPUtil.deadInside(entity);
        }
    }

    public static List<TagKey<DamageType>> damageTypes(boolean warden) {
        ArrayList<TagKey<DamageType>> damageTypes = new ArrayList<TagKey<DamageType>>();
        damageTypes.add(DamageTypeTags.f_268627_);
        damageTypes.add(DamageTypeTags.f_268490_);
        damageTypes.add(DamageTypeTags.f_276146_);
        damageTypes.add(DamageTypeTags.f_268738_);
        damageTypes.add(DamageTypeTags.f_268437_);
        damageTypes.add(DamageTypeTags.f_268630_);
        damageTypes.add(DamageTypeTags.f_268413_);
        if (!warden) {
            damageTypes.add(DamageTypeTags.f_268745_);
        }
        damageTypes.add(DamageTypeTags.f_268524_);
        damageTypes.add(DamageTypeTags.f_268731_);
        damageTypes.add(DamageTypeTags.f_268415_);
        damageTypes.add(DamageTypeTags.f_268549_);
        damageTypes.add(DamageTypeTags.f_268581_);
        damageTypes.add(DamageTypeTags.f_268419_);
        damageTypes.add(DamageTypeTags.f_268725_);
        if (!warden) {
            damageTypes.add(DamageTypeTags.f_268718_);
        }
        damageTypes.add(DamageTypeTags.f_268467_);
        damageTypes.add(DamageTypeTags.f_268518_);
        damageTypes.add(DamageTypeTags.f_268484_);
        if (!warden) {
            damageTypes.add(DamageTypeTags.f_268727_);
        }
        if (!warden) {
            damageTypes.add(DamageTypeTags.f_268711_);
        }
        damageTypes.add(DamageTypeTags.f_268640_);
        damageTypes.add(DamageTypeTags.f_268750_);
        damageTypes.add(DamageTypeTags.f_273821_);
        return damageTypes;
    }

    public static List<DamageSource> playerDamageSources(LivingEntity player, LivingEntity entity) {
        ArrayList<DamageSource> damageSources = new ArrayList<DamageSource>();
        damageSources.add(player.m_269291_().m_269548_());
        damageSources.add(player.m_269291_().m_269318_());
        damageSources.add(player.m_269291_().m_269354_());
        damageSources.add(player.m_269291_().m_269063_());
        damageSources.add(player.m_269291_().m_269064_());
        damageSources.add(player.m_269291_().m_269325_());
        damageSources.add(player.m_269291_().m_268989_());
        damageSources.add(player.m_269291_().m_269515_());
        damageSources.add(player.m_269291_().m_269341_());
        damageSources.add(player.m_269291_().m_269264_());
        damageSources.add(player.m_269291_().m_269425_());
        damageSources.add(player.m_269291_().m_269251_());
        damageSources.add(player.m_269291_().m_269254_());
        damageSources.add(player.m_269291_().m_269555_());
        damageSources.add(player.m_269291_().m_269109_());
        damageSources.add(player.m_269291_().m_269571_());
        damageSources.add(player.m_269291_().m_269564_((Entity)player));
        damageSources.add(player.m_269291_().m_269230_((Entity)player));
        damageSources.add(player.m_269291_().m_269103_((Entity)player));
        damageSources.add(player.m_269291_().m_269396_(player));
        damageSources.add(player.m_269291_().m_269333_(player));
        damageSources.add(player.m_269291_().m_269525_((Entity)player, (Entity)entity));
        damageSources.add(player.m_269291_().m_269299_((Entity)player, entity));
        damageSources.add(player.m_269291_().m_269374_((Entity)player));
        damageSources.add(player.m_269291_().m_269036_((Entity)player, (Entity)entity));
        damageSources.add(player.m_269291_().m_269285_((Entity)player));
        damageSources.add(player.m_269291_().m_269387_());
        damageSources.add(player.m_269291_().m_269549_());
        damageSources.add(player.m_269291_().m_269233_());
        damageSources.add(player.m_269291_().m_269047_());
        return damageSources;
    }

    public static void vestigeNullify(Player player) {
        Archlinx.removeModifiers(player);
        player.getPersistentData().m_128379_("VPMarkUlt", false);
        player.getPersistentData().m_128350_("VPShield", 0.0f);
        player.getPersistentData().m_128350_("VPOverShield", 0.0f);
        player.getPersistentData().m_128405_("VPDevourerHits", 0);
        player.getPersistentData().m_128350_("VPHealResFlower", 0.0f);
        player.getPersistentData().m_128350_("VPShieldBonusFlower", 0.0f);
        HashMultimap mark = HashMultimap.create();
        mark.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(UUID.fromString("4fc18d7a-9353-45b1-ad77-29117c1d9e6f"), "vp:attack_speed_modifier_mark", 2.0, AttributeModifier.Operation.MULTIPLY_BASE));
        mark.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(UUID.fromString("78cf254b-36df-41d6-be91-ad06220d9dd8"), "vp:speed_modifier_mark", 2.0, AttributeModifier.Operation.MULTIPLY_BASE));
        mark.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("54b7f5ed-0851-4745-b98c-e1f08a1a2f67"), "vp:speed_modifier_mark", 2.0, AttributeModifier.Operation.MULTIPLY_BASE));
        player.m_21204_().m_22161_((Multimap)mark);
        HashMultimap mask = HashMultimap.create();
        mask.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(UUID.fromString("ec62548c-5b26-401e-83fd-693e4aafa532"), "vp:attack_speed_modifier", 0.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        mask.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("f4ece564-d2c0-40d2-a96a-dc68b493137c"), "vp:speed_modifier", 0.0, AttributeModifier.Operation.MULTIPLY_BASE));
        player.m_21204_().m_22161_((Multimap)mask);
        HashMultimap midas = HashMultimap.create();
        midas.put((Object)Attributes.f_22286_, (Object)new AttributeModifier(UUID.fromString("f55f3429-0399-4d9e-9f84-0d7156cc0593"), "vp:luck", 0.0, AttributeModifier.Operation.ADDITION));
        player.getPersistentData().m_128405_("VPPrism", 0);
        player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22276_, UUID.fromString("55ebb7f1-2368-4b6f-a123-f3b1a9fa30ea"), 0.0f, AttributeModifier.Operation.ADDITION, "vp:soulblighter_hp_boost"));
        player.getPersistentData().m_128379_("VPSweetUlt", false);
        player.getPersistentData().m_128350_("VPSaturation", 0.0f);
        player.getPersistentData().m_128350_("VPHealBonusDonut", 0.0f);
        player.getPersistentData().m_128350_("VPShieldBonusDonut", 0.0f);
        player.getPersistentData().m_128350_("VPHealBonusDonutPassive", 0.0f);
        player.getPersistentData().m_128350_("VPTrigonBonus", 0.0f);
        player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22276_, UUID.fromString("8dac9436-c37f-4b74-bf64-8666258605b9"), 1.0f, AttributeModifier.Operation.MULTIPLY_TOTAL, "vp:trigon_hp_boost"));
        if (player.m_6084_() && player.m_21223_() > player.m_21233_()) {
            player.m_21153_(player.m_21233_());
        }
        VPUtil.sync(player);
        if (player.m_7500_()) {
            return;
        }
        player.m_150110_().f_35936_ = false;
        player.m_150110_().f_35935_ = false;
        player.m_6885_();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.sendToClient(new PlayerFlyPacket(2), serverPlayer);
        }
    }

    public static void sync(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CompoundTag sendNudes = new CompoundTag();
            for (String key : player.getPersistentData().m_128431_()) {
                if (!key.startsWith("VP") || player.getPersistentData().m_128423_(key) == null) continue;
                sendNudes.m_128365_(key, player.getPersistentData().m_128423_(key));
            }
            PacketHandler.sendToClient(new SendPlayerNbtToClient(player.m_20148_(), sendNudes), serverPlayer);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int getSet(Player player) {
        void var4_7;
        int set = 0;
        ArrayList<Integer> types = new ArrayList<Integer>();
        for (ItemStack itemStack : VPUtil.getAccessoryList(player)) {
            Item item = itemStack.m_41720_();
            if (!(item instanceof Accessory)) continue;
            Accessory accessory = (Accessory)item;
            types.add(Accessory.getType(itemStack));
        }
        if (types.isEmpty()) {
            return set;
        }
        ArrayList<Integer> counts = new ArrayList<Integer>(Collections.nCopies(6, 0));
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            int type = (Integer)iterator.next();
            counts.set(type, (Integer)counts.get(type) + 1);
        }
        boolean bl = false;
        Iterator iterator2 = counts.iterator();
        while (iterator2.hasNext()) {
            int count = (Integer)iterator2.next();
            if (count <= 0) continue;
            ++var4_7;
        }
        if ((Integer)counts.get(1) >= 2 && (Integer)counts.get(4) >= 2) {
            set = 1;
        } else if ((Integer)counts.get(2) >= 2 && (Integer)counts.get(3) >= 2) {
            set = 2;
        } else if ((Integer)counts.get(5) >= 2 && (Integer)counts.get(4) >= 2) {
            set = 3;
        } else if ((Integer)counts.get(3) >= 4) {
            set = 4;
        } else if ((Integer)counts.get(2) >= 4) {
            set = 5;
        } else if ((Integer)counts.get(5) >= 4) {
            set = 6;
        } else if ((Integer)counts.get(1) >= 4) {
            set = 7;
        } else if ((Integer)counts.get(4) >= 4) {
            set = 8;
        } else if (var4_7 == 4) {
            set = 9;
        } else if (types.size() == 4) {
            set = 10;
        }
        return set;
    }

    public static int getCurseAmount(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        int totalCurses = 0;
        for (Enchantment enchantment : enchantments.keySet()) {
            if (!enchantment.m_6589_() || (Integer)enchantments.get(enchantment) <= 0) continue;
            ++totalCurses;
        }
        return totalCurses;
    }

    public static int getCurseAmount(Player player) {
        int count = 0;
        for (ItemStack theStack : VPUtil.getFullEquipment(player)) {
            if (theStack == null) continue;
            count += VPUtil.getCurseAmount(theStack);
        }
        return count;
    }

    public static List<ItemStack> getFullEquipment(Player player) {
        ArrayList equipmentStacks = Lists.newArrayList();
        equipmentStacks.add(player.m_21205_());
        equipmentStacks.add(player.m_21206_());
        equipmentStacks.addAll(player.m_150109_().f_35975_);
        equipmentStacks.addAll(VPUtil.getCurioList(player));
        return equipmentStacks;
    }

    public static boolean isEasterEvent() {
        if (((Boolean)ConfigHandler.COMMON.easter.get()).booleanValue()) {
            return true;
        }
        LocalDate today = LocalDate.now();
        int year = today.getYear();
        int a = year % 19;
        int b = year / 100;
        int c = year % 100;
        int d = b / 4;
        int e = b % 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int i = c / 4;
        int k = c % 4;
        int l = (32 + 2 * e + 2 * i - h - k) % 7;
        int m = (a + 11 * h + 22 * l) / 451;
        int i1 = h + l - 7 * m + 114;
        int month = i1 / 31;
        int day = i1 % 31 + 1;
        LocalDate easterDate = LocalDate.of(year, month, day);
        return today.equals(easterDate);
    }

    public static boolean spawnEgg(Player player) {
        BlockPos pos = player.m_20097_();
        EasterEggEntity easterEggEntity = new EasterEggEntity(player.m_20193_());
        easterEggEntity.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        VPUtil.teleportRandomly((Entity)easterEggEntity, 60);
        int x = player.getPersistentData().m_128451_("VPEggX");
        int y = player.getPersistentData().m_128451_("VPEggY");
        int z = player.getPersistentData().m_128451_("VPEggZ");
        double distance = pos.m_203193_((Position)new Vec3((double)x, (double)y, (double)z));
        if (VPUtil.isSafeLocation(player.m_20193_(), easterEggEntity.m_20185_(), easterEggEntity.m_20186_(), easterEggEntity.m_20189_()) && distance > 20000.0) {
            player.m_20193_().m_7967_((Entity)easterEggEntity);
            player.getPersistentData().m_128405_("VPEggX", (int)player.m_20185_());
            player.getPersistentData().m_128405_("VPEggY", (int)player.m_20186_());
            player.getPersistentData().m_128405_("VPEggZ", (int)player.m_20189_());
            VPUtil.play((LivingEntity)player, SoundEvents.f_11877_);
            return true;
        }
        return false;
    }

    public static void giveStack(ItemStack stack, Player player) {
        if (player.m_150109_().m_36062_() != -1) {
            player.m_36356_(stack);
        } else {
            player.m_36176_(stack, false);
        }
    }

    public static void resync(PlayerCapabilityVP cap, Player player) {
        if (!player.m_20193_().f_46443_) {
            VPUtil.getBiomesLeft(cap.getBiomesFound(), player);
            VPUtil.getMonsterLeft(cap.getMonstersKilled(), player);
            VPUtil.getBossesLeft(cap.getBosses(), player);
            VPUtil.getMobsLeft(cap.getMobsTamed(), player);
            VPUtil.getRareItemsLeft(cap.getrareItems(), player);
            VPUtil.getOresLeft(cap.getOres(), player);
        }
    }

    public static boolean notContains(String list, String word) {
        boolean notContains = true;
        if (list.isEmpty()) {
            return true;
        }
        for (String element : list.split(",")) {
            if (!element.equals(word)) continue;
            notContains = false;
            break;
        }
        return notContains;
    }

    public static float dreadAbsorbtion(float number, float capAbsorb) {
        float maxCap = (float)((Double)ConfigHandler.COMMON.nightmareDpsCap.get() + 0.0);
        float baseAbsorb = 0.05f;
        float cap = Math.max(1.0f, maxCap - capAbsorb);
        float damage = number <= cap ? number * baseAbsorb : baseAbsorb * 100.0f + 10.0f * (float)Math.log10(number);
        return damage * maxCap / (maxCap + cap * baseAbsorb * 100.0f);
    }

    public static float dpsAbsorption(LivingEntity entity, float damage) {
        if (damage < 0.0f) {
            return damage;
        }
        float buffer = entity.getPersistentData().m_128457_("VPDPSAbsorb");
        int type = entity.getPersistentData().m_128451_("VPDealType");
        if (damage > buffer) {
            damage = buffer * 0.75f;
        }
        entity.getPersistentData().m_128350_("VPDPSAbsorb", buffer - damage);
        entity.getPersistentData().m_128405_("VPDealType", 0);
        return damage * (float)(1 + type * 2);
    }

    public static boolean hasLyra(LivingEntity entity, int number) {
        return entity.getPersistentData().m_128454_("VPLyra" + number) > System.currentTimeMillis();
    }

    public static void initFishItems() {
        for (Item item : items) {
            for (String name : ConfigHandler.COMMON.fishObjects.get().toString().split(",")) {
                if (!item.m_5524_().contains(name) || VPUtil.isBlackListed(item)) continue;
                fishList.add(item);
            }
        }
    }

    public static boolean isBlackListed(Item item) {
        for (String name : ConfigHandler.COMMON.fishingBlacklist.get().toString().split(",")) {
            if (!item.m_5524_().contains(name)) continue;
            return true;
        }
        return false;
    }

    public static void initFishDrops(List<ResourceLocation> biomes) {
        Random random = new Random();
        for (ResourceLocation biome : biomes) {
            biomeFishMap.put(biome, new ArrayList());
        }
        int index = 0;
        for (Item item : fishList) {
            ResourceLocation biome = biomes.get(index % biomes.size());
            biomeFishMap.get(biome).add(item);
            ++index;
        }
        for (ResourceLocation biome : biomes) {
            List<Item> items = biomeFishMap.get(biome);
            while (items.size() < 8) {
                items.add(fishList.get(random.nextInt(fishList.size())));
            }
        }
    }

    public static ItemStack getFishDrop(Player player) {
        ItemStack stack = ItemStack.f_41583_;
        Random random = new Random();
        Level level = player.m_20193_();
        if (level instanceof ServerLevel) {
            List items;
            ServerLevel serverLevel = (ServerLevel)level;
            if (fishList.isEmpty()) {
                VPUtil.initFishItems();
            }
            if (biomeFishMap.isEmpty()) {
                VPUtil.initFishDrops(VPUtil.getBiomes());
            }
            if (!(items = (List)biomeFishMap.getOrDefault(VPUtil.getCurrentBiome(player), new ArrayList())).isEmpty()) {
                Item randomItem = (Item)items.get(random.nextInt(items.size() - 1));
                while (ConfigHandler.COMMON.fishingBlacklist.get().toString().contains(randomItem.m_5524_())) {
                    randomItem = (Item)items.get(random.nextInt(items.size() - 1));
                }
                if (stack.m_41720_() instanceof PinkyPearl && random.nextDouble() > VPUtil.getChance((Double)ConfigHandler.COMMON.rareFishingDropChance.get(), player) / 10.0) {
                    randomItem = (Item)items.get(random.nextInt(items.size() - 1));
                } else if (VPUtil.isRare(stack) && random.nextDouble() > VPUtil.getChance((Double)ConfigHandler.COMMON.rareFishingDropChance.get(), player)) {
                    randomItem = (Item)items.get(random.nextInt(items.size() - 1));
                }
                stack = new ItemStack((ItemLike)randomItem);
            }
        }
        return stack;
    }

    public static boolean isRare(ItemStack stack) {
        for (String name : ConfigHandler.COMMON.rareItems.get().toString().split(",")) {
            if (!stack.m_41778_().contains(name)) continue;
            return true;
        }
        return false;
    }

    public static void initFishMap() {
        if (fishList.isEmpty()) {
            VPUtil.initFishItems();
        }
        if (biomeFishMap.isEmpty()) {
            VPUtil.initFishDrops(VPUtil.getBiomes());
        }
    }

    public static void printFishDrop(Player player) {
        if (fishList.isEmpty()) {
            VPUtil.initFishItems();
        }
        if (biomeFishMap.isEmpty()) {
            VPUtil.initFishDrops(VPUtil.getBiomes());
        }
        List items = biomeFishMap.getOrDefault(VPUtil.getCurrentBiome(player), new ArrayList());
        Random random = new Random();
        player.m_213846_((Component)Component.m_237113_((String)""));
        player.m_213846_((Component)Component.m_237113_((String)""));
        for (int i = 0; i < items.size(); ++i) {
            ChatFormatting style;
            int numba = random.nextInt(3);
            Item item = (Item)items.get(i);
            if (VPUtil.isRare(new ItemStack((ItemLike)item))) {
                style = ChatFormatting.RED;
                player.m_213846_((Component)Component.m_237113_((String)(i + 1 + ") ")).m_7220_((Component)Component.m_237115_((String)item.m_5524_())).m_130940_(style).m_130940_(ChatFormatting.BOLD));
                continue;
            }
            style = numba == 1 ? ChatFormatting.BLUE : (numba == 2 ? ChatFormatting.AQUA : ChatFormatting.DARK_AQUA);
            player.m_213846_((Component)Component.m_237113_((String)(i + 1 + ") ")).m_7220_((Component)Component.m_237115_((String)item.m_5524_())).m_130940_(style));
        }
    }

    public static int getWaterDepth(Player player) {
        Level level = player.m_20193_();
        BlockPos playerPos = player.m_20183_();
        if (!player.m_20071_()) {
            return 0;
        }
        int depth = 0;
        BlockPos checkPos = playerPos;
        while (level.m_8055_(checkPos).m_60734_() == Blocks.f_49990_) {
            ++depth;
            checkPos = checkPos.m_7494_();
        }
        return depth;
    }

    public static String filterString(String string) {
        if (string.isEmpty()) {
            return string;
        }
        StringBuilder builder = new StringBuilder(string);
        if (string.startsWith("[")) {
            builder.deleteCharAt(0);
        }
        if (string.endsWith("]")) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static Component translateString(String string, ChatFormatting color) {
        ArrayList<String> list = new ArrayList<String>(List.of(string.split(",")));
        StringBuilder translatedText = new StringBuilder();
        for (String name : list) {
            MutableComponent translatedComponent = Component.m_237115_((String)name.trim());
            String plain = translatedComponent.getString().replaceAll("\u00a7.", "");
            translatedText.append(plain).append(", ");
        }
        if (translatedText.length() > 2) {
            translatedText.setLength(translatedText.length() - 2);
        }
        return Component.m_237113_((String)translatedText.toString()).m_130940_(color);
    }

    public static Component filterAndTranslate(String string, ChatFormatting color) {
        return VPUtil.translateString(VPUtil.filterString(string), color);
    }

    public static Component filterAndTranslate(String string) {
        return VPUtil.translateString(VPUtil.filterString(string), ChatFormatting.GRAY);
    }

    public static List<String> filterList(List<String> list) {
        ArrayList<String> filtered = new ArrayList<String>();
        for (String element : list) {
            filtered.add(element.trim());
        }
        return filtered;
    }

    public static float getBaseHealth(EntityType<?> type) {
        if (zaebali.isEmpty() || !zaebali.containsKey(type)) {
            return 0.0f;
        }
        return zaebali.get(type).floatValue();
    }

    public static void spawnBoss(LivingEntity entity) {
        entity.m_21204_().m_22178_(VPUtil.createAttributeMap(entity, Attributes.f_22276_, UUID.fromString("ee3a5be4-dfe5-4756-b32b-3e3206655f47"), (float)((Double)ConfigHandler.COMMON.bossHP.get() + 0.0), AttributeModifier.Operation.MULTIPLY_TOTAL, "vp:boss_health"));
        entity.m_21204_().m_22178_(VPUtil.createAttributeMap(entity, Attributes.f_22281_, UUID.fromString("c87d7c0e-8804-4ada-aa26-8109a1af8b31"), (float)((Double)ConfigHandler.COMMON.bossAttack.get() + 0.0), AttributeModifier.Operation.MULTIPLY_TOTAL, "vp:boss_damage"));
        entity.m_21204_().m_22178_(VPUtil.createAttributeMap(entity, Attributes.f_22284_, UUID.fromString("5cb61d4f-d008-40d9-8353-d2d2c302503a"), ((Integer)ConfigHandler.COMMON.armorCruel.get()).intValue(), AttributeModifier.Operation.ADDITION, "vp:boss_armor"));
        entity.m_21204_().m_22178_(VPUtil.createAttributeMap(entity, Attributes.f_22285_, UUID.fromString("fe739733-3069-41af-93af-321759771f52"), ((Integer)ConfigHandler.COMMON.armorCruel.get()).intValue(), AttributeModifier.Operation.ADDITION, "vp:boss_armor_toughness"));
        VPUtil.setHealth(entity, entity.m_21233_());
        entity.getPersistentData().m_128350_("VPShield", (float)((double)entity.m_21233_() * (Double)ConfigHandler.COMMON.shieldCruel.get()));
        entity.getPersistentData().m_128350_("VPOverShield", (float)((double)entity.m_21233_() * (Double)ConfigHandler.COMMON.overShieldCruel.get()));
        if (VPUtil.isNightmareBoss(entity)) {
            entity.m_21204_().m_22178_(VPUtil.createAttributeMap(entity, Attributes.f_22276_, UUID.fromString("534c53b9-3c22-4c34-bdcd-f255a9694b34"), 10.0f, AttributeModifier.Operation.MULTIPLY_TOTAL, "vp:nightmare.hp"));
            entity.m_21204_().m_22178_(VPUtil.createAttributeMap(entity, Attributes.f_22281_, UUID.fromString("1d665861-143f-4906-9ab0-e511ad377783"), 10.0f, AttributeModifier.Operation.MULTIPLY_TOTAL, "vp:nightmare.attack"));
            entity.m_21153_(entity.m_21233_());
            entity.getPersistentData().m_128350_("VPShield", (float)((double)entity.m_21233_() * (Double)ConfigHandler.COMMON.shieldCruel.get()));
            entity.getPersistentData().m_128350_("VPOverShield", (float)((double)entity.m_21233_() * (Double)ConfigHandler.COMMON.overShieldCruel.get()));
            AABB boundingBox = entity.m_20191_();
            AABB scaledBoundingBox = boundingBox.m_82377_(boundingBox.m_82362_(), boundingBox.m_82376_(), boundingBox.m_82385_());
            entity.m_20011_(scaledBoundingBox);
        }
        entity.m_6210_();
    }

    public static void vzlomatJopu(float value) {
        Attribute attribute = (Attribute)BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation("generic.max_health"));
        if (attribute instanceof RangedAttribute) {
            RangedAttribute ranged = (RangedAttribute)attribute;
            VzlomJopiMixin vzlom = (VzlomJopiMixin)attribute;
            if (ranged.m_147362_() != (double)value) {
                vzlom.vzlomatJopu(value);
            }
        }
    }

    public static boolean isPoisonedByNightmare(Player player) {
        if (player.m_21023_(MobEffects.f_19614_)) {
            for (LivingEntity entity : VPUtil.getEntitiesAround(player, 30.0, 30.0, 30.0, false)) {
                if (!VPUtil.isNightmareBoss(entity)) continue;
                return true;
            }
        }
        return false;
    }

    public static void updateStats(Player player) {
        List<ItemStack> list = VPUtil.getVestigeList(player);
        for (ItemStack itemStack : list) {
            Item item = itemStack.m_41720_();
            if (!(item instanceof Vestige)) continue;
            Vestige vestige = (Vestige)item;
            vestige.init(itemStack);
            vestige.applyBonus(itemStack, player);
        }
    }

    public static void nightmareDamageEvent(LivingEntity boss, Player player, LivingDamageEvent event) {
        List<MobEffectInstance> list;
        Random random = new Random();
        float attack = (float)boss.m_21051_(Attributes.f_22281_).m_22135_();
        int type = boss.getPersistentData().m_128451_("VPBossType");
        if (boss.m_21223_() <= boss.m_21233_() * 0.5f) {
            VPUtil.dealParagonDamage((LivingEntity)player, boss, event.getAmount() * 0.1f, 0, true);
        }
        if (type == 1) {
            VPUtil.setHealDebt((LivingEntity)player, VPUtil.getHealDebt((LivingEntity)player) + player.m_21233_() * 2.0f);
            float stack = player.getPersistentData().m_128457_("VPIgnis");
            if (((double)player.m_21223_() < (double)player.m_21233_() * 0.3 || player.m_21233_() <= 5.0f) && random.nextDouble() < VPUtil.getChance(0.2, player)) {
                VPUtil.deadInside((LivingEntity)player);
                return;
            }
            player.getPersistentData().m_128350_("VPIgnis", Math.min(99.0f, stack + 5.0f));
            player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22276_, UUID.fromString("4ed92da8-dd60-41a2-9540-cc8816af92e2"), 1.0f, AttributeModifier.Operation.ADDITION, "vp:ignis_hp"));
            player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22284_, UUID.fromString("39f598b3-b75c-422f-93fc-8e65dade8730"), 1.0f, AttributeModifier.Operation.ADDITION, "vp:ignis_armor"));
            player.m_21204_().m_22178_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22276_, UUID.fromString("4ed92da8-dd60-41a2-9540-cc8816af92e2"), -player.m_21233_() * (stack / 100.0f), AttributeModifier.Operation.ADDITION, "vp:ignis_hp"));
            player.m_21204_().m_22178_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22284_, UUID.fromString("39f598b3-b75c-422f-93fc-8e65dade8730"), (float)(-player.m_21230_()) * (stack / 100.0f), AttributeModifier.Operation.ADDITION, "vp:ignis_armor"));
            player.getPersistentData().m_128356_("VPIgnisTime", System.currentTimeMillis() + 60000L);
            player.m_21153_(player.m_21233_());
        }
        if (type == 2) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 255, 255));
            player.m_7292_(new MobEffectInstance(VPUtil.getRandomEffect(false), 255, 255));
            VPUtil.updateStats(player);
        }
        if (type == 3 && !(list = VPUtil.getEffectsHas((LivingEntity)player, true)).isEmpty()) {
            MobEffectInstance effectInstance = list.get(random.nextInt(list.size() - 1));
            boss.m_7292_(effectInstance);
            player.m_21195_(effectInstance.m_19544_());
        }
        if (type == 4 && random.nextDouble() < VPUtil.getChance(0.3, player)) {
            player.f_19802_ = 0;
            float damage = attack;
            int shield = 1;
            if (player.m_20071_()) {
                damage *= 30.0f;
                shield = 5;
            }
            player.m_6469_(boss.m_269291_().m_269109_(), damage);
            boss.getPersistentData().m_128405_("VPFreezeShield", shield);
        }
        if (type == 5 && (!player.m_20096_() && !player.m_20069_() || !boss.m_20096_() && !boss.m_20069_())) {
            VPUtil.dealParagonDamage((LivingEntity)player, boss, attack * 0.05f, 0, true);
        }
        if (type == 6 && (VPUtil.getShield((LivingEntity)player) > 0.0f || VPUtil.getOverShield((LivingEntity)player) > 0.0f)) {
            event.setAmount(event.getAmount() * 8.0f);
        }
        double brightness = (double)(player.m_20193_().m_45517_(LightLayer.BLOCK, boss.m_20183_()) + player.m_20193_().m_45517_(LightLayer.SKY, boss.m_20183_())) / 2.0;
        if (type == 7) {
            boolean somebodyHelp = false;
            for (LivingEntity livingEntity : VPUtil.getEntities(player, 20.0, false)) {
                if (!(livingEntity instanceof Player)) continue;
                somebodyHelp = true;
            }
            if (!somebodyHelp) {
                event.setAmount(event.getAmount() * 10.0f);
            }
            if (brightness <= 7.0) {
                player.f_19802_ = 0;
                float damage = attack * 2.0f;
                if (!somebodyHelp) {
                    damage *= 10.0f;
                }
                player.m_6469_(boss.m_269291_().m_269341_(), damage);
                VPUtil.dealParagonDamage((LivingEntity)player, boss, 50.0f, 0, true);
            }
        }
    }

    public static void boostEntity(LivingEntity livingEntity, float amount, float shields, float overShields) {
        livingEntity.m_21204_().m_22178_(VPUtil.createAttributeMap(livingEntity, Attributes.f_22276_, UUID.randomUUID(), amount, AttributeModifier.Operation.MULTIPLY_TOTAL, "vp:boss7:1"));
        livingEntity.m_21204_().m_22178_(VPUtil.createAttributeMap(livingEntity, Attributes.f_22284_, UUID.randomUUID(), amount, AttributeModifier.Operation.MULTIPLY_TOTAL, "vp:boss7:5"));
        livingEntity.m_21204_().m_22178_(VPUtil.createAttributeMap(livingEntity, Attributes.f_22285_, UUID.randomUUID(), amount, AttributeModifier.Operation.MULTIPLY_TOTAL, "vp:boss7:6"));
        livingEntity.m_21204_().m_22178_(VPUtil.createAttributeMap(livingEntity, Attributes.f_22281_, UUID.randomUUID(), amount, AttributeModifier.Operation.MULTIPLY_TOTAL, "vp:boss7:4"));
        livingEntity.m_21204_().m_22178_(VPUtil.createAttributeMap(livingEntity, Attributes.f_22279_, UUID.randomUUID(), VPUtil.scaleDown(amount, 2.0f), AttributeModifier.Operation.MULTIPLY_TOTAL, "vp:boss7:7"));
        livingEntity.m_21153_(livingEntity.m_21233_());
        if (shields > 0.0f) {
            livingEntity.getPersistentData().m_128350_("VPShieldInit", shields);
            VPUtil.addShield(livingEntity, shields, true);
        }
        if (overShields > 0.0f) {
            livingEntity.getPersistentData().m_128350_("VPOverShield", overShields);
            livingEntity.getPersistentData().m_128350_("VPOverShieldMax", overShields);
        }
        livingEntity.getPersistentData().m_128379_("VPEmpowered", true);
        VPUtil.syncEntity((Entity)livingEntity);
    }

    public static void nightmareTickEvent(LivingEntity entity) {
        boolean rage;
        Random random = new Random();
        float slow = 1.0f;
        boolean bl = rage = (double)entity.m_21223_() < (double)entity.m_21233_() * 0.5;
        if (rage) {
            slow = 1.0f;
        }
        if ((double)entity.m_21223_() < (double)entity.m_21233_() * 0.15) {
            slow = 0.2f;
        }
        if (rage && entity.getPersistentData().m_128454_("VPTick") < System.currentTimeMillis()) {
            entity.getPersistentData().m_128356_("VPTick", System.currentTimeMillis() + 1000L);
            entity.m_8119_();
        }
        if (VPUtil.getOverShield(entity) > 0.0f) {
            VPUtil.setHealth(entity, entity.m_21233_());
        }
        if (entity.f_19797_ > 24000) {
            VPUtil.despawn(entity);
        }
        if (entity instanceof Monster) {
            Monster monster = (Monster)entity;
            if (monster.m_5448_() == null || !(monster.m_5448_() instanceof Player)) {
                ((MobEntityVzlom)monster).setTarget((LivingEntity)monster.m_20193_().m_45930_((Entity)monster, 45.0));
            }
            if (monster.m_5448_() != null) {
                LivingEntity target = monster.m_5448_();
                if (entity.getPersistentData().m_128454_("VPGhost") > System.currentTimeMillis()) {
                    entity.f_19794_ = true;
                    VPUtil.suckToPos((Entity)entity, new BlockPos((int)target.m_20185_(), (int)target.m_20186_(), (int)target.m_20189_()), 10.0);
                } else {
                    entity.f_19794_ = false;
                }
                if ((float)entity.f_19797_ % (20.0f * slow) == 0.0f) {
                    target = monster.m_5448_();
                    if (!monster.m_217066_(target)) {
                        entity.getPersistentData().m_128405_("VPReach", entity.getPersistentData().m_128451_("VPReach") + 1);
                    } else {
                        entity.getPersistentData().m_128405_("VPReach", 0);
                        if (entity.getPersistentData().m_128454_("VPGhost") > 0L) {
                            monster.m_7327_((Entity)target);
                            entity.f_19794_ = false;
                            entity.getPersistentData().m_128356_("VPGhost", 0L);
                        }
                    }
                }
            }
        }
        if (entity.getPersistentData().m_128451_("VPReach") >= 13) {
            entity.getPersistentData().m_128405_("VPReach", 0);
            entity.getPersistentData().m_128356_("VPGhost", System.currentTimeMillis() + 13000L);
        }
        if ((double)entity.m_21223_() < (double)entity.m_21233_() * 0.5) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 255, 255));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 255, 255));
        }
        if ((float)entity.f_19797_ % (100.0f * slow) == 0.0f) {
            VPUtil.clearEffects(entity, false);
        }
        if (!entity.m_142038_()) {
            entity.m_146915_(true);
        }
        float attack = (float)(100.0 * (Double)ConfigHandler.COMMON.damageCruel.get());
        if (entity.m_21204_().m_22171_(Attributes.f_22281_)) {
            attack = (float)entity.m_21051_(Attributes.f_22281_).m_22135_();
        }
        int type = entity.getPersistentData().m_128451_("VPBossType");
        if (entity.f_19797_ % 2 == 0) {
            VPUtil.nightmareAura(type, entity);
        }
        if (type == 1 && (float)entity.f_19797_ % (20.0f * slow) == 0.0f) {
            VPUtil.spawnCircleParticles((Entity)entity, 60, ParticleTypes.f_123744_, 5.0, 0.5);
            VPUtil.spawnCircleParticles((Entity)entity, 30, ParticleTypes.f_123744_, 3.0, 1.0);
            VPUtil.spawnCircleParticles((Entity)entity, 10, ParticleTypes.f_123744_, 2.0, 1.5);
        }
        if (type == 2) {
            if ((float)entity.f_19797_ % (40.0f * slow) == 0.0f) {
                int count = 0;
                for (LivingEntity livingEntity : VPUtil.getEntitiesAround(entity, 20.0, 20.0, 20.0, false)) {
                    if (!(livingEntity instanceof Player)) continue;
                    ++count;
                }
                entity.getPersistentData().m_128350_("VPAcsHeal", (float)(count * 30));
            }
            if ((float)entity.f_19797_ % (100.0f * slow) == 0.0f) {
                CloudEntity cloudEntity = new CloudEntity(entity.m_20193_(), entity);
                cloudEntity.m_6021_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                VPUtil.teleportRandomly((Entity)cloudEntity, 20);
                entity.m_20193_().m_7967_((Entity)cloudEntity);
            }
        }
        if (type == 3) {
            if ((float)entity.f_19797_ % (200.0f * slow) == 0.0f) {
                VPUtil.regenOverShield(entity, VPUtil.getOverShield(entity) * 0.1f);
                if (random.nextDouble() < 0.2) {
                    VPUtil.spawnCircleParticles((Entity)entity, 30, ParticleTypes.f_123759_, 30.0, 0.5);
                    for (LivingEntity livingEntity : VPUtil.getEntitiesAround(entity, 20.0, 20.0, 20.0, false)) {
                        livingEntity.f_19802_ = 0;
                        livingEntity.m_6469_(entity.m_269291_().m_269318_(), attack * 40.0f);
                    }
                    VPUtil.play(entity, SoundEvents.f_12442_);
                    VPUtil.play(entity, SoundEvents.f_12447_);
                    VPUtil.play(entity, SoundEvents.f_12442_);
                    VPUtil.play(entity, SoundEvents.f_12442_);
                    VPUtil.play(entity, SoundEvents.f_12442_);
                    VPUtil.play(entity, SoundEvents.f_12442_);
                }
            }
            for (LivingEntity livingEntity : VPUtil.getEntitiesAround(entity, 20.0, 20.0, 20.0, false)) {
                Player player;
                if (!(livingEntity instanceof Player) || !(player = (Player)livingEntity).getPersistentData().m_128471_("VPAttacked")) continue;
                player.getPersistentData().m_128379_("VPAttacked", false);
                player.f_19802_ = 0;
                player.m_6469_(VPUtil.randomizeDamageType(player), (float)random.nextInt());
                entity.getPersistentData().m_128356_("VPDef", System.currentTimeMillis() + 10000L);
            }
            if ((float)entity.f_19797_ % (200.0f * slow) == 0.0f && entity.getPersistentData().m_128454_("VPDef") == 0L) {
                entity.getPersistentData().m_128356_("VPDef", System.currentTimeMillis());
            }
        }
        if (type == 4) {
            if (entity.getPersistentData().m_128451_("VPFreezeShield") > 0) {
                VPUtil.spawnSphere((Entity)entity, (ParticleOptions)ParticleTypes.f_175821_, 20, 3.0f, 0.0f);
            }
            if ((float)entity.f_19797_ % (50.0f * slow) == 0.0f && random.nextDouble() < 0.3) {
                entity.getPersistentData().m_128356_("VPBlizzard", System.currentTimeMillis() + 10000L);
            }
        }
        if (type == 5) {
            double x = 5.0;
            double y = 5.0;
            double z = 5.0;
            for (Entity element : entity.m_20193_().m_45976_(LivingEntity.class, new AABB(entity.m_20185_() + x, entity.m_20186_() + y, entity.m_20189_() + z, entity.m_20185_() - x, entity.m_20186_() - y, entity.m_20189_() - z))) {
                if (!(element instanceof Projectile)) continue;
                Projectile projectile = (Projectile)element;
                if (element instanceof BlackHole || element instanceof VortexEntity || element instanceof CloudEntity) continue;
                projectile.m_20256_(projectile.m_20184_().m_82548_());
                projectile.m_5602_((Entity)entity);
            }
        }
        if (type == 6) {
            if ((float)entity.f_19797_ % (60.0f * slow) == 0.0f) {
                VPUtil.regenOverShield(entity, VPUtil.getOverShield(entity) * 0.05f);
            }
            for (LivingEntity livingEntity : VPUtil.getEntitiesAround(entity, 5.0, 5.0, 5.0, false)) {
                Player player;
                if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_7500_()) continue;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 255, 255));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 255, 255));
                player.getPersistentData().m_128356_("VPForbidden", System.currentTimeMillis() + 1000L);
            }
        }
        if (type == 7) {
            Entity monster;
            Monster boss;
            int amount = 0;
            for (LivingEntity livingEntity : VPUtil.getEntitiesAround(entity, 40.0, 40.0, 40.0, false)) {
                if (!livingEntity.getPersistentData().m_128471_("VPSummoned")) continue;
                ++amount;
            }
            if (entity instanceof Monster && (boss = (Monster)entity).m_5448_() != null && boss.m_5448_().getPersistentData().m_128471_("VPSummoned")) {
                boss.m_6710_(null);
                Player player = boss.m_20193_().m_45930_((Entity)boss, 40.0);
                if (player != null) {
                    boss.m_6710_((LivingEntity)player);
                }
            }
            float shield = 3000.0f;
            float overShield = 1000.0f;
            if ((float)entity.f_19797_ % (600.0f * slow) == 0.0f && amount < 20) {
                Level level = entity.m_20193_();
                for (int i = 0; i < random.nextInt(15) + 5; ++i) {
                    int count;
                    monster = VPUtil.getRandomMonster().m_20615_(level);
                    if (!(monster instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)monster;
                    for (count = 0; (VPUtil.isBoss(livingEntity) || livingEntity instanceof HunterKiller) && count < 100; ++count) {
                        LivingEntity livingEntity1;
                        monster = VPUtil.getRandomMonster().m_20615_(level);
                        if (!(monster instanceof LivingEntity)) continue;
                        livingEntity = livingEntity1 = (LivingEntity)monster;
                    }
                    if (count >= 100) continue;
                    livingEntity.m_6021_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                    VPUtil.teleportRandomly((Entity)livingEntity, 10);
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 100000, 255));
                    VPUtil.boostEntity(livingEntity, 10.0f, shield, overShield);
                    livingEntity.getPersistentData().m_128379_("VPSummoned", true);
                    livingEntity.m_21153_(livingEntity.m_21233_());
                    level.m_7967_((Entity)livingEntity);
                }
            }
            if ((float)entity.f_19797_ % (200.0f * slow) == 0.0f) {
                for (LivingEntity livingEntity : VPUtil.getEntitiesAround(entity, 20.0, 20.0, 20.0, false)) {
                    Monster boss2;
                    if (!livingEntity.getPersistentData().m_128471_("VPSummoned")) continue;
                    livingEntity.m_5634_(livingEntity.m_21233_() * 0.1f);
                    livingEntity.getPersistentData().m_128350_("VPShieldInit", VPUtil.getShield(livingEntity) + shield);
                    VPUtil.addShield(livingEntity, shield, false);
                    VPUtil.regenOverShield(livingEntity, overShield);
                    if (!(livingEntity instanceof Monster)) continue;
                    monster = (Monster)livingEntity;
                    if (!(entity instanceof Monster) || (boss2 = (Monster)entity).m_5448_() == null) continue;
                    monster.m_6710_(boss2.m_5448_());
                }
            }
        }
        BlockPos pos = VPUtil.randomPos((Entity)entity, 20);
        boolean lift = false;
        BlockPos position = VPUtil.randomPos((Entity)entity, 15);
        ServerLevel serverLevel = null;
        ArrayList<LivingEntity> lightList = new ArrayList<LivingEntity>();
        for (LivingEntity livingEntity : VPUtil.getEntitiesAround(entity, 30.0, 30.0, 30.0, false)) {
            Player player;
            if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_7500_()) {
                double x = player.m_20185_();
                double y = player.m_20186_();
                double z = player.m_20189_();
                if (type == 1 && (float)entity.f_19797_ % (80.0f * slow) == 0.0f) {
                    player.m_20254_(entity.m_20094_() + 10000);
                    player.m_6469_(entity.m_269291_().m_269233_(), attack * 0.6f);
                }
                if (type == 2 && (float)entity.f_19797_ % (200.0f * slow) == 0.0f) {
                    VPUtil.spawnParticle((Entity)player, (ParticleOptions)ParticleTypes.f_123796_, x, y, z, 0.0, 0.0, 0.0);
                }
                if (type == 4) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 255, 255));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 255, 255));
                    player.m_146924_(true);
                    player.m_146917_(player.m_146891_());
                    if ((float)entity.f_19797_ % (40.0f * slow) == 0.0f && random.nextInt(3) == 2) {
                        VPUtil.play((LivingEntity)player, SoundEvents.f_12478_);
                    }
                    if (entity.getPersistentData().m_128454_("VPBlizzard") > System.currentTimeMillis() && entity.f_19797_ % 20 == 0) {
                        player.f_19802_ = 0;
                        player.m_6469_(entity.m_269291_().m_269109_(), attack * 10.0f);
                        player.getPersistentData().m_128356_("VPForbidden", System.currentTimeMillis() + 1000L);
                    }
                }
                if ((float)entity.f_19797_ % (40.0f * slow) == 0.0f && type == 5) {
                    if (random.nextDouble() < 0.5) {
                        if (!player.m_7500_() && player.m_150110_().f_35935_) {
                            VPUtil.clearEffects((LivingEntity)player, true);
                            if (random.nextDouble() < 0.5) {
                                VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.WIND1.get());
                            } else {
                                VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.WIND2.get());
                            }
                            player.m_150110_().f_35936_ = false;
                            player.m_150110_().f_35935_ = false;
                            player.m_6885_();
                            if (player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                PacketHandler.sendToClient(new PlayerFlyPacket(2), serverPlayer);
                            }
                            player.f_19802_ = 0;
                            player.m_6469_(entity.m_269291_().m_268989_(), attack * 8.0f);
                        }
                    } else if (pos != null) {
                        VPUtil.clearEffects((LivingEntity)player, true);
                        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.WIND3.get());
                        VPUtil.suckToPos((Entity)player, pos, 10.0);
                    }
                    if (random.nextDouble() < 0.3) {
                        if (random.nextDouble() < 0.5) {
                            VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.WIND1.get());
                        } else {
                            VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.WIND2.get());
                        }
                        VPUtil.liftEntity((LivingEntity)player, 8.0);
                        lift = true;
                    }
                }
                if ((float)entity.f_19797_ % (20.0f * slow) == 0.0f && type == 6) {
                    if (position != null && livingEntity.m_20238_(position.m_252807_()) <= 5.0) {
                        lightList.add(livingEntity);
                    }
                    entity.getPersistentData().m_128356_("VPBossL", System.currentTimeMillis() + (long)(random.nextInt(10) * 1000));
                    Level level = player.m_20193_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel1;
                        serverLevel = serverLevel1 = (ServerLevel)level;
                        if (random.nextDouble() < 0.2) {
                            lightList.add(livingEntity);
                            VPUtil.spawnLightning(serverLevel, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
                        }
                    }
                }
                if ((float)entity.f_19797_ % (200.0f * slow) == 0.0f && random.nextDouble() < 0.5 && type == 6) {
                    entity.m_6021_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                }
                if (entity.getPersistentData().m_128454_("VPBlizzard") > System.currentTimeMillis() && entity.f_19797_ % 20 == 0) {
                    VPUtil.spawnSphere((Entity)player, (ParticleOptions)ParticleTypes.f_175821_, 20, 4.0f, 2.0f);
                    VPUtil.spawnSphere((Entity)player, (ParticleOptions)ParticleTypes.f_175821_, 20, 2.0f, 1.0f);
                    VPUtil.play(entity, SoundEvents.f_144202_);
                }
            }
            if ((float)entity.f_19797_ % (2.0f * slow) == 0.0f && entity.getPersistentData().m_128454_("VPBossL") > System.currentTimeMillis() && serverLevel != null) {
                if (position != null) {
                    VPUtil.spawnLightning(serverLevel, position.m_123341_(), position.m_123342_(), position.m_123343_());
                }
                if (!lightList.isEmpty()) {
                    for (LivingEntity living : lightList) {
                        if (living == entity) continue;
                        living.f_19802_ = 0;
                        living.m_6469_(entity.m_269291_().m_269548_(), attack * 0.5f);
                        VPUtil.stealShields(living, entity, 15.0f, true);
                    }
                    entity.getPersistentData().m_128350_("VPAcsHeal", entity.getPersistentData().m_128457_("VPAcsHeal") + (float)lightList.size());
                }
            }
            if (!lift) continue;
            VPUtil.liftEntity(entity, 8.0);
        }
    }

    public static void spawnCircleParticles(Entity entity, int particleCount, SimpleParticleType type, double radius, double height) {
        Vec3 entityPosition = entity.m_20182_();
        Random random = new Random();
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * random.nextDouble();
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double x = entityPosition.f_82479_ + xOffset;
            double y = entityPosition.f_82480_ + height;
            double z = entityPosition.f_82481_ + zOffset;
            double numba = random.nextDouble();
            double velocityX = xOffset * 0.1;
            double velocityY = numba * 0.1;
            double velocityZ = zOffset * 0.1;
            VPUtil.spawnParticle(entity, (ParticleOptions)type, x, y, z, velocityX, velocityY, velocityZ);
        }
    }

    public static void spawnAura(Entity entity, int particleCount, SimpleParticleType type, double radius) {
        Vec3 entityPosition = entity.m_20182_();
        Random random = new Random();
        double speed = 1.0;
        if (type == ParticleTypes.f_175830_ || type == ParticleTypes.f_123757_) {
            speed = 4.0;
            particleCount *= 2;
        }
        radius += (double)entity.m_20205_();
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * random.nextDouble();
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double x = entityPosition.f_82479_ + xOffset;
            double y = entityPosition.f_82480_ + 0.5;
            double z = entityPosition.f_82481_ + zOffset;
            if (type == ParticleTypes.f_123786_) {
                y += 6.0;
            }
            double numba = random.nextDouble() * speed;
            double velocityX = xOffset * 0.01;
            double velocityY = numba * 0.1;
            double velocityZ = zOffset * 0.01;
            VPUtil.spawnParticle(entity, (ParticleOptions)type, x, y, z, velocityX * numba, velocityY + 1.0, velocityZ * numba);
        }
    }

    public static void spawnSphere(Entity entity, ParticleOptions type, int count, float radius, float speed) {
        Vec3 entityPos = entity.m_20182_();
        Random random = new Random();
        for (int i = 0; i < count; ++i) {
            double theta = Math.PI * 2 * random.nextDouble();
            double phi = Math.acos(2.0 * random.nextDouble() - 1.0);
            double xOffset = (double)radius * Math.sin(phi) * Math.cos(theta);
            double yOffset = (double)radius * Math.sin(phi) * Math.sin(theta);
            double zOffset = (double)radius * Math.cos(phi);
            double xSpeed = xOffset * (double)speed;
            double ySpeed = yOffset * (double)speed;
            double zSpeed = zOffset * (double)speed;
            VPUtil.spawnParticle(entity, type, entityPos.f_82479_ + xOffset, entityPos.f_82480_ + yOffset + (double)(entity.m_20206_() / 2.0f), entityPos.f_82481_ + zOffset, xSpeed, ySpeed, zSpeed);
        }
    }

    public static void nightmareAura(int type, LivingEntity entity) {
        SimpleParticleType particleType = null;
        Random random = new Random();
        double radius = 2.0;
        switch (type) {
            case 1: {
                particleType = ParticleTypes.f_123744_;
                break;
            }
            case 2: {
                particleType = ParticleTypes.f_175826_;
                break;
            }
            case 3: {
                particleType = ParticleTypes.f_123809_;
                break;
            }
            case 4: {
                particleType = ParticleTypes.f_175821_;
                break;
            }
            case 5: {
                particleType = ParticleTypes.f_123796_;
                break;
            }
            case 6: {
                particleType = ParticleTypes.f_175830_;
                break;
            }
            case 7: {
                particleType = random.nextDouble() < 0.5 ? ParticleTypes.f_123745_ : ParticleTypes.f_123746_;
            }
        }
        VPUtil.spawnAura((Entity)entity, 30, particleType, radius);
    }

    public static void setLuck(Player player) {
        player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> {
            int luck = cap.getPearls();
            if (VPUtil.hasVestige((Item)ModItems.CHAOS.get(), player)) {
                luck += 7;
            }
            player.getPersistentData().m_128405_("VPPearlsLuck", luck);
        });
    }

    public static int getLuck(Player player) {
        return player.getPersistentData().m_128451_("VPPearlsLuck");
    }

    public static double getChance(double chance, Player player) {
        double multiplier = 1.2;
        double newChance = chance + Math.log1p((double)VPUtil.getLuck(player) * multiplier / 100.0) * (1.0 - chance);
        if (chance >= 100.0) {
            newChance = chance;
        }
        return Math.min(newChance, chance * 3.0);
    }

    public static void spawnGuardianParticle(LivingEntity livingEntity, LivingEntity target) {
        double d5 = 0.5;
        double d0 = target.m_20185_() - livingEntity.m_20185_();
        double d1 = target.m_20227_(0.5) - livingEntity.m_20188_();
        double d2 = target.m_20189_() - livingEntity.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        d0 /= d3;
        d1 /= d3;
        d2 /= d3;
        double d4 = livingEntity.m_217043_().m_188500_();
        while (d4 < d3) {
            livingEntity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, livingEntity.m_20185_() + d0 * (d4 += 1.8 - d5 + livingEntity.m_217043_().m_188500_() * (1.7 - d5)), livingEntity.m_20188_() + d1 * d4, livingEntity.m_20189_() + d2 * d4, 0.0, 0.0, 0.0);
        }
    }

    public static boolean isHalloween() {
        LocalDate today = LocalDate.now();
        return today.getMonthValue() == 10 && today.getDayOfMonth() == 31;
    }

    public static boolean isEmpoweredMob(LivingEntity livingEntity) {
        return livingEntity.getPersistentData().m_128471_("VPEmpowered");
    }

    public static boolean curseVestige(ItemStack stack, int curse, Player player) {
        if (stack.m_41784_().m_128451_("VPCursed") <= 0) {
            if (Math.random() < 0.05) {
                curse = 6;
                Vestige.increaseStars(stack, player);
            }
            stack.m_41784_().m_128405_("VPCursed", curse);
            return true;
        }
        return false;
    }

    public static int getVestigeCurse(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPCursed");
    }

    public static boolean isEnchantable(ItemStack stack) {
        return stack.m_41720_() instanceof ArmorItem || stack.m_41720_() instanceof TieredItem || stack.m_41720_() instanceof BowItem;
    }

    public static void dropStack(ItemStack stack, LivingEntity livingEntity) {
        ItemEntity itemEntity = new ItemEntity(livingEntity.m_20193_(), livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), stack);
        livingEntity.m_20193_().m_7967_((Entity)itemEntity);
        SoundEvent sound = null;
        SimpleParticleType particle = null;
        if (stack.m_41720_() instanceof CorruptFragment) {
            sound = (SoundEvent)SoundRegistry.DROP_CORRUPT1.get();
            particle = ParticleTypes.f_123784_;
        } else if (stack.m_41720_() instanceof CorruptItem) {
            sound = (SoundEvent)SoundRegistry.DROP_CORRUPT2.get();
            particle = ParticleTypes.f_123744_;
        } else if (stack.m_41720_() instanceof ChaosOrb) {
            sound = (SoundEvent)SoundRegistry.DROP_CHAOS.get();
            particle = ParticleTypes.f_175828_;
        } else if (stack.m_41720_() instanceof CelestialMirror) {
            sound = (SoundEvent)SoundRegistry.DROP_MIRROR.get();
            particle = ParticleTypes.f_175826_;
        }
        if (sound != null) {
            VPUtil.play(livingEntity, sound);
            VPUtil.spawnSphere((Entity)livingEntity, (ParticleOptions)particle, 40, 2.0f, 0.1f);
        }
    }

    public static boolean hasCurse(Player player, int curse) {
        List<ItemStack> list = VPUtil.getVestigeList(player);
        for (ItemStack stack : list) {
            if (VPUtil.getVestigeCurse(stack) != curse) continue;
            return true;
        }
        return false;
    }

    public static float getCurseMultiplier(Player player, int curse) {
        List<ItemStack> list = VPUtil.getVestigeList(player);
        for (ItemStack stack : list) {
            Item item;
            if (VPUtil.getVestigeCurse(stack) != curse || !((item = stack.m_41720_()) instanceof Vestige)) continue;
            Vestige vestige = (Vestige)item;
            if (curse <= 0) continue;
            float multiplier = 0.0f;
            if (curse == 1) {
                multiplier = -0.9f;
                if (Vestige.isStellar(stack)) {
                    multiplier = -0.75f;
                }
                if (Vestige.isDoubleStellar(stack)) {
                    multiplier = -0.45f;
                }
                if (Vestige.isTripleStellar(stack)) {
                    multiplier = -0.35f;
                }
            } else if (curse == 2) {
                multiplier = 80.0f;
                if (Vestige.isStellar(stack)) {
                    multiplier = 65.0f;
                }
                if (Vestige.isDoubleStellar(stack)) {
                    multiplier = 50.0f;
                }
                if (Vestige.isTripleStellar(stack)) {
                    multiplier = 40.0f;
                }
            } else if (curse == 3) {
                multiplier = 0.01f;
                if (Vestige.isStellar(stack)) {
                    multiplier = 0.005f;
                }
                if (Vestige.isDoubleStellar(stack)) {
                    multiplier = 0.001f;
                }
                if (Vestige.isTripleStellar(stack)) {
                    multiplier = 1.0E-4f;
                }
            } else if (curse == 4) {
                multiplier = 1.4f;
                if (Vestige.isStellar(stack)) {
                    multiplier = 1.7f;
                }
                if (Vestige.isDoubleStellar(stack)) {
                    multiplier = 2.1f;
                }
                if (Vestige.isTripleStellar(stack)) {
                    multiplier = 2.6f;
                }
            } else if (curse == 5) {
                multiplier = 1.5f;
                if (Vestige.isStellar(stack)) {
                    multiplier = 2.25f;
                }
                if (Vestige.isDoubleStellar(stack)) {
                    multiplier = 3.5f;
                }
                if (Vestige.isTripleStellar(stack)) {
                    multiplier = 4.5f;
                }
            } else if (curse == 6) {
                multiplier = 0.6f;
                if (Vestige.isDoubleStellar(stack)) {
                    multiplier = 0.5f;
                }
                if (Vestige.isTripleStellar(stack)) {
                    multiplier = 0.4f;
                }
            }
            return multiplier;
        }
        return 0.0f;
    }

    public static int scaleDown(int number, int cap) {
        if (number <= cap) {
            return number;
        }
        double scaled = (double)cap + Math.log(number - cap + 1);
        return (int)Math.round(scaled);
    }

    public static float scaleDown(float number, float cap) {
        if (number <= cap) {
            return number;
        }
        return (float)((double)cap + Math.log(number - cap + 1.0f));
    }

    public static double scaleDown(double number, double cap) {
        if (number <= cap) {
            return number;
        }
        System.out.println(number);
        return cap + Math.log(number - cap + 1.0);
    }

    public static void bindEntity(LivingEntity entity, long time) {
        VPUtil.antiTp(entity, time);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> {
                cap.setBindTime(System.currentTimeMillis() + time);
                cap.setBindX(entity.m_20185_());
                cap.setBindY(entity.m_20186_());
                cap.setBindZ(entity.m_20189_());
            });
        } else {
            entity.getPersistentData().m_128347_("VPDevourerX", entity.m_20185_());
            entity.getPersistentData().m_128347_("VPDevourerY", entity.m_20186_());
            entity.getPersistentData().m_128347_("VPDevourerZ", entity.m_20189_());
        }
    }

    public static void antiTp(LivingEntity entity, long time) {
        if (time == -1L) {
            entity.getPersistentData().m_128356_("VPAntiTP", 0L);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketHandler.sendToClient(new PlayerFlyPacket(11), serverPlayer);
            }
            return;
        }
        entity.getPersistentData().m_128356_("VPAntiTP", System.currentTimeMillis() + time);
        VPUtil.syncEntity((Entity)entity);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> cap.setAntiTp(System.currentTimeMillis() + time));
        }
    }

    public static void antiResurrect(LivingEntity entity, long time) {
        if (time == -1L) {
            entity.getPersistentData().m_128356_("VPDeath", 0L);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketHandler.sendToClient(new PlayerFlyPacket(10), serverPlayer);
            }
            return;
        }
        entity.getPersistentData().m_128356_("VPDeath", System.currentTimeMillis() + time);
        VPUtil.syncEntity((Entity)entity);
    }

    public static boolean canResurrect(Entity entity) {
        return entity.getPersistentData().m_128454_("VPDeath") < System.currentTimeMillis();
    }

    public static boolean canTeleport(Entity entity) {
        if (entity.getPersistentData().m_128454_("VPAntiTP") > System.currentTimeMillis() || VPUtil.isEvent(entity)) {
            return false;
        }
        AtomicBoolean teleport = new AtomicBoolean(true);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> {
                if (cap.getAntiTp() > System.currentTimeMillis()) {
                    teleport.set(false);
                }
            });
        }
        return teleport.get();
    }

    public static void bindTick(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> {
                if (cap.getBindTime() > System.currentTimeMillis()) {
                    BlockPos pos = new BlockPos((int)cap.getBindX(), (int)cap.getBindY(), (int)cap.getBindZ());
                    VPUtil.suckToPos((Entity)player, pos, 1.0);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        PacketHandler.sendToClient(new PlayerFlyPacket(301), serverPlayer);
                    }
                }
            });
        } else if (livingEntity.getPersistentData().m_128459_("VPDevourerX") != 0.0) {
            if (livingEntity.getPersistentData().m_128454_("VPAntiTP") < System.currentTimeMillis()) {
                livingEntity.getPersistentData().m_128347_("VPDevourerX", 0.0);
                livingEntity.getPersistentData().m_128347_("VPDevourerY", 0.0);
                livingEntity.getPersistentData().m_128347_("VPDevourerZ", 0.0);
                return;
            }
            BlockPos pos = new BlockPos((int)livingEntity.getPersistentData().m_128459_("VPDevourerX"), (int)livingEntity.getPersistentData().m_128459_("VPDevourerY"), (int)livingEntity.getPersistentData().m_128459_("VPDevourerZ"));
            VPUtil.suckToPos((Entity)livingEntity, pos, 1.0);
        }
    }

    public static String addMysteryLoot(String base, String id, String rarity) {
        String[] drops;
        int index = VPUtil.rarityToIndex(rarity);
        String[] segments = base.split(">");
        if (segments.length != 4) {
            throw new IllegalArgumentException("Invalid base string format");
        }
        String[] parts = segments[index].split("<", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid segment format at index " + index);
        }
        String chance = parts[0];
        Object dropList = parts[1].trim();
        for (String drop : drops = ((String)dropList).split(",")) {
            if (!drop.trim().equals(id)) continue;
            return base;
        }
        dropList = ((String)dropList).isEmpty() ? id : (String)dropList + "," + id;
        segments[index] = chance + "<" + (String)dropList;
        StringBuilder sb = new StringBuilder();
        for (String seg : segments) {
            sb.append(seg).append(">");
        }
        return sb.toString();
    }

    public static String removeMysteryLoot(String base, String id, String rarity) {
        int index = VPUtil.rarityToIndex(rarity);
        String[] segments = base.split(">");
        if (segments.length != 4) {
            throw new IllegalArgumentException("Invalid base string format ");
        }
        String[] parts = segments[index].split("<", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid segment format at index " + index);
        }
        String chance = parts[0];
        String dropList = parts[1].trim();
        String[] drops = dropList.split(",");
        StringBuilder newDropList = new StringBuilder();
        for (String drop : drops) {
            String trimmed = drop.trim();
            if (trimmed.equals(id)) continue;
            if (newDropList.length() > 0) {
                newDropList.append(",");
            }
            newDropList.append(trimmed);
        }
        segments[index] = chance + "<" + newDropList.toString();
        StringBuilder sb = new StringBuilder();
        for (String seg : segments) {
            sb.append(seg).append(">");
        }
        return sb.toString();
    }

    private static int rarityToIndex(String rarity) {
        switch (rarity.toLowerCase()) {
            case "common": {
                return 0;
            }
            case "rare": {
                return 1;
            }
            case "mythic": {
                return 2;
            }
            case "legendary": {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown rarity: " + rarity);
    }

    public static boolean strictOptimization() {
        if (ConfigHandler.COMMON_SPEC.isLoaded()) {
            return (Boolean)ConfigHandler.COMMON.strictOptimization.get();
        }
        return false;
    }

    public static String getOs(Player player) {
        return osMap.get(player.m_20148_());
    }

    public static void giveNightmareDrop(LivingEntity entity, Player player) {
        if (entity.getPersistentData().m_128471_("VPNDrop")) {
            return;
        }
        entity.getPersistentData().m_128379_("VPNDrop", true);
        Random random = new Random();
        for (LivingEntity livingEntity : VPUtil.getEntitiesAround(entity, 20.0, 20.0, 20.0, false)) {
            if (!(livingEntity instanceof Player)) continue;
            Player killer = (Player)livingEntity;
            int min = (Integer)ConfigHandler.COMMON.nightmareLootMin.get();
            int max = (Integer)ConfigHandler.COMMON.nightmareLoot.get();
            int amount = random.nextInt(Math.max(1, max - min)) + min;
            for (int i = 0; i < amount; ++i) {
                VPUtil.dropEntityLoot(entity, killer, false);
            }
            min = (Integer)ConfigHandler.COMMON.nightmareFragsMin.get();
            max = (Integer)ConfigHandler.COMMON.nightmareFrags.get();
            amount = random.nextInt(Math.max(1, max - min)) + min;
            VPUtil.giveStack(new ItemStack((ItemLike)ModItems.STELLAR.get(), amount), killer);
            if (random.nextDouble() < VPUtil.getChance((Double)ConfigHandler.COMMON.nightmareRefresherChance.get(), player)) {
                VPUtil.giveStack(new ItemStack((ItemLike)ModItems.REFRESHER.get()), killer);
            }
            if (random.nextDouble() < VPUtil.getChance((Double)ConfigHandler.COMMON.nightmareBoxChance.get(), player)) {
                min = (Integer)ConfigHandler.COMMON.nightmareBoxesMin.get();
                max = (Integer)ConfigHandler.COMMON.nightmareBoxes.get();
                VPUtil.giveStack(new ItemStack((ItemLike)ModItems.BOX_EGGS.get(), random.nextInt(Math.max(1, max - min)) + min), killer);
                VPUtil.giveStack(new ItemStack((ItemLike)ModItems.BOX.get(), random.nextInt(Math.max(1, max - min)) + min), killer);
                VPUtil.giveStack(new ItemStack((ItemLike)ModItems.BOX_SAPLINGS.get(), random.nextInt(Math.max(1, max - min)) + min), killer);
            }
            VPUtil.giveStack(new ItemStack((ItemLike)ModItems.NIGHTMARESHARD.get()), player);
        }
        player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> cap.addNightmareChallenge(entity.getPersistentData().m_128451_("VPBossType"), player));
    }

    public static void setRoflanEbalo(LivingEntity entity, long time) {
        if (entity == null) {
            return;
        }
        if (time == -1L) {
            roflan.put(entity.m_20148_(), 0L);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketHandler.sendToClient(new PlayerFlyPacket(9), serverPlayer);
            }
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            PacketHandler.sendToClient(new PlayerFlyPacket(12), serverPlayer);
        }
        roflan.put(entity.m_20148_(), System.currentTimeMillis() + time);
    }

    public static boolean isRoflanEbalo(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        if (roflan.containsKey(entity.m_20148_())) {
            return roflan.get(entity.m_20148_()) - System.currentTimeMillis() > 0L;
        }
        return false;
    }

    public static int getSoulIntegrity(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AtomicInteger soul = new AtomicInteger();
            player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> soul.set(cap.getSoulIntegrity()));
            return soul.get();
        }
        return entity.getPersistentData().m_128451_("VPSoulIntegrity");
    }

    public static int getMaxSoulIntegrity(LivingEntity entity) {
        if (!VPUtil.isBoss(entity) && !(entity instanceof Player)) {
            return 100;
        }
        AtomicInteger maxSoul = new AtomicInteger(100);
        maxSoul.addAndGet((int)(Math.log10(entity.m_21233_()) * 100.0));
        if (VPUtil.isBoss(entity)) {
            maxSoul.set(maxSoul.get() * 2);
            if (VPUtil.isNightmareBoss(entity)) {
                maxSoul.set(maxSoul.get() * 4);
            }
        } else if (entity instanceof Player) {
            ItemStack stack;
            Player player = (Player)entity;
            player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> {
                maxSoul.addAndGet((int)((double)cap.getAdvancements() * 0.1));
                maxSoul.addAndGet(cap.getAllLore().split(",").length * 25);
            });
            if (VPUtil.hasStellarVestige((Item)ModItems.SOULBLIGHTER.get(), player) && (stack = VPUtil.getVestigeStack(SoulBlighter.class, player)).m_41784_().m_128441_("entityData")) {
                maxSoul.addAndGet((int)Math.log10(stack.m_41784_().m_128457_("VPMaxHealth") * 100.0f));
            }
            maxSoul.set(maxSoul.get() * 4);
            if (VPUtil.hasVestige((Item)ModItems.NIGHTMARE_DEVOURER.get(), player)) {
                maxSoul.set(maxSoul.get() * 2);
            }
        }
        return maxSoul.get();
    }

    public static void modifySoulIntegrity(LivingEntity entity, int number) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> {
                cap.setSoulIntegrity(Math.min(VPUtil.getMaxSoulIntegrity(entity), cap.getSoulIntegrity() + number));
                cap.sync(player);
            });
        } else {
            entity.getPersistentData().m_128405_("VPSoulIntegrity", Math.min(VPUtil.getMaxSoulIntegrity(entity), entity.getPersistentData().m_128451_("VPSoulIntegrity") + number));
            if (entity.getPersistentData().m_128451_("VPSoulIntegrity") <= 0) {
                VPUtil.deadInside(entity);
            }
            VPUtil.syncEntity((Entity)entity);
        }
    }

    public static void modifySoulIntegrity(LivingEntity entity, Player modifier, int number) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (VPUtil.hasVestige((Item)ModItems.SOULBLIGHTER.get(), player)) {
                VPUtil.addRadiance(SoulBlighter.class, 10, player);
            }
            player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> {
                cap.setSoulIntegrity(Math.min(VPUtil.getMaxSoulIntegrity(entity), cap.getSoulIntegrity() + number));
                if (number < 0) {
                    player.getPersistentData().m_128356_("VPSoulShow", System.currentTimeMillis() + 120000L);
                }
                cap.sync(player);
                if (cap.getSoulIntegrity() <= 0) {
                    VPUtil.deadInside((LivingEntity)player, modifier);
                }
            });
        } else {
            entity.getPersistentData().m_128405_("VPSoulIntegrity", Math.min(VPUtil.getMaxSoulIntegrity(entity), entity.getPersistentData().m_128451_("VPSoulIntegrity") + number));
            if (entity.getPersistentData().m_128451_("VPSoulIntegrity") <= 0) {
                VPUtil.deadInside(entity, modifier);
            }
            VPUtil.syncEntity((Entity)entity);
        }
    }

    public static void printTrack(String message, Player player) {
        if (player != null && player.m_150109_() != null && player.m_21206_().m_41720_() instanceof TestItem) {
            player.m_213846_((Component)Component.m_237113_((String)("IsClient: " + player.m_9236_().f_46443_ + " " + message)));
        }
    }

    public static void setHealDebt(LivingEntity entity, float amount) {
        entity.getPersistentData().m_128350_("VPHealDebt", amount);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (VPUtil.hasVestige((Item)ModItems.CHAOS.get(), player)) {
                Vestige vestige;
                ItemStack stack = VPUtil.getVestigeStack(Chaos.class, player);
                Item item = stack.m_41720_();
                if (item instanceof Vestige && (vestige = (Vestige)item).isUltimateActive(stack)) {
                    for (LivingEntity livingEntity : VPUtil.getEntities(player, 30.0, false)) {
                        livingEntity.getPersistentData().m_128350_("VPHealDebt", amount * 0.3f);
                    }
                }
                VPUtil.addRadiance(Chaos.class, 1, player);
            }
            if (VPUtil.hasVestige((Item)ModItems.LYRA.get(), player) && amount <= 0.0f) {
                VPUtil.addRadiance(Lyra.class, 15, player);
            }
        }
    }

    public static float getHealDebt(LivingEntity entity) {
        return entity.getPersistentData().m_128457_("VPHealDebt");
    }

    public static void saveNbt(UUID uuid, CompoundTag tag) {
        temporaryData.put(uuid, tag);
    }

    public static CompoundTag getTemporaryData(UUID uuid) {
        if (temporaryData.containsKey(uuid)) {
            return temporaryData.get(uuid);
        }
        return new CompoundTag();
    }

    public static void updatePowerList(Player player) {
        for (int i = 0; i < PlayerCapabilityVP.totalVestiges; ++i) {
            AtomicDouble power = new AtomicDouble((double)ConfigHandler.COMMON.powerScale(i));
            if (power.get() < 100.0) {
                player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> {
                    power.addAndGet((double)cap.getCommonChallenges() * (Double)ConfigHandler.COMMON.powerBoost.get());
                    if (power.addAndGet((double)cap.getStellarChallenges() * (Double)ConfigHandler.COMMON.powerBoost.get() * 2.0) > 100.0) {
                        power.set(100.0);
                    }
                });
            }
            powerList.add(i, power.get());
        }
    }

    public static double getPower(int challenge, Player player) {
        if (powerList.isEmpty()) {
            VPUtil.updatePowerList(player);
        }
        if (challenge == 666) {
            return 100.0;
        }
        return powerList.get(challenge - 1);
    }

    public static double scalePower(double number, int challenge, Player player) {
        return number * (VPUtil.getPower(challenge, player) / 100.0);
    }

    public static float scalePower(float number, int challenge, Player player) {
        return (float)((double)number * (VPUtil.getPower(challenge, player) / 100.0));
    }

    public static int scalePower(int number, int challenge, Player player) {
        return (int)((double)number * (VPUtil.getPower(challenge, player) / 100.0));
    }

    public static int getRadianceSpecial() {
        return 5;
    }

    public static int getRadianceUltimate() {
        return 10;
    }

    public static void addRadiance(Class clazz, int number, Player player) {
        ItemStack stack = VPUtil.getVestigeStack(clazz, player);
        Item item = stack.m_41720_();
        if (item instanceof Vestige) {
            Vestige vestige = (Vestige)item;
            int used = player.getPersistentData().m_128451_("VPRadianceUsed");
            if (player.getPersistentData().m_128454_("VPRadianceTime") + 100L > System.currentTimeMillis()) {
                number /= 2 * used;
                player.getPersistentData().m_128405_("VPRadianceUsed", used + 1);
            } else {
                player.getPersistentData().m_128356_("VPRadianceTime", System.currentTimeMillis());
                player.getPersistentData().m_128405_("VPRadianceUsed", 1);
            }
            vestige.addRadiance(number, stack);
        }
    }
}

