package fun.wich.mixin;

import fun.wich.SunkenSkeletonMod;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1453;
import net.minecraft.class_1937;
import net.minecraft.class_3414;

@Mixin(class_1453.class)
public class ParrotEntityMixin {
	@Shadow
	@Final
	static Map<class_1299<?>, class_3414> MOB_SOUNDS;
	@Shadow private static class_3414 getSound(class_1299<?> imitate) { return null; }
	@Unique
	private static final Predicate<class_1308> CAN_IMITATE_NEW = new Predicate<>(){
		@Override
		public boolean test(class_1308 mobEntity) {
			if (mobEntity == null) return false;
			class_1299<?> type = mobEntity.method_5864();
			if (!MOB_SOUNDS.containsKey(type)) {
				if (type == SunkenSkeletonMod.SUNKEN_SKELETON) MOB_SOUNDS.put(SunkenSkeletonMod.SUNKEN_SKELETON, SunkenSkeletonMod.ENTITY_PARROT_IMITATE_SUNKEN_SKELETON);
			}
			return MOB_SOUNDS.containsKey(type);
		}
	};
	@Inject(method="imitateNearbyMob", at=@At("HEAD"), cancellable=true)
	private static void TryImitations(class_1937 world, class_1297 parrot, CallbackInfoReturnable<Boolean> cir) {
		class_1308 mobEntity;
		if (parrot.method_5805() && !parrot.method_5701() && world.field_9229.method_43048(2) == 0) {
			List<class_1308> list = world.method_8390(class_1308.class, parrot.method_5829().method_1014(20.0), CAN_IMITATE_NEW);
			if (!list.isEmpty() && !(mobEntity = list.get(world.field_9229.method_43048(list.size()))).method_5701()) {
				class_3414 soundEvent = getSound(mobEntity.method_5864());
				world.method_43128(null, parrot.method_23317(), parrot.method_23318(), parrot.method_23321(), soundEvent, parrot.method_5634(), 0.7f, class_1453.method_6580(world.field_9229));
				cir.setReturnValue(true);
			}
		}
	}
}
