/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.api.client;

import com.teamresourceful.resourcefulconfig.api.client.ResourcefulConfigScreenBuilder;
import com.teamresourceful.resourcefulconfig.api.loader.Configurator;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.client.ConfigScreen;
import com.teamresourceful.resourcefulconfig.client.ConfigScreenContext;
import com.teamresourceful.resourcefulconfig.client.ConfigsScreen;
import com.teamresourceful.resourcefulconfig.common.config.Configurations;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.Optionull;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ResourcefulConfigScreen {
    public static ResourcefulConfigScreenBuilder make(ResourcefulConfig config) {
        return new ResourcefulConfigScreenBuilder(config);
    }

    public static ResourcefulConfigScreenBuilder make(Configurator configurator, Class<?> clazz) {
        ResourcefulConfig config = Objects.requireNonNull(configurator.getConfig(clazz), "Config not found for class: " + clazz.getName());
        return ResourcefulConfigScreen.make(config);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion=">1.21.7")
    public static Screen get(@Nullable Screen parent, Configurator configurator, Class<?> clazz) {
        return (Screen)Optionull.map((Object)configurator.getConfig(clazz), c -> ResourcefulConfigScreen.get(parent, c));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion=">1.21.7")
    public static Screen get(@Nullable Screen parent, ResourcefulConfig config) {
        return new ConfigScreen(parent, config, new ConfigScreenContext());
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion=">1.21.7")
    public static Screen get(@Nullable Screen parent, ResourcefulConfig config, Function<String, List<String>> termCollector) {
        return new ConfigScreen(parent, config, new ConfigScreenContext("", termCollector));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion=">1.21.7")
    public static Screen get(@Nullable Screen parent, String mod) {
        return new ConfigsScreen(parent, mod);
    }

    public static Function<@Nullable Screen, Screen> getFactory(String mod) {
        Set<String> configs = Configurations.INSTANCE.getConfigsForMod(mod);
        if (configs.size() != 1) {
            long nonHiddenCount = configs.stream().map(Configurations.INSTANCE::getConfig).filter(it -> !it.info().isHidden()).count();
            if (nonHiddenCount != 1L) {
                return screen -> new ConfigsScreen((Screen)screen, mod);
            }
        }
        if (configs.isEmpty()) {
            return screen -> new ConfigsScreen((Screen)screen, mod);
        }
        ResourcefulConfig config = Configurations.INSTANCE.getConfig(configs.iterator().next());
        return config == null ? Function.identity() : screen -> ResourcefulConfigScreen.make(config).withParent((Screen)screen).build();
    }
}

