/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.api.types;

import com.teamresourceful.resourcefulconfig.api.patching.ConfigPatchEvent;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfigButton;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfigElement;
import com.teamresourceful.resourcefulconfig.api.types.elements.ResourcefulConfigEntryElement;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.api.types.info.ResourcefulConfigInfo;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface ResourcefulConfig {
    default public int version() {
        return 0;
    }

    @NotNull
    default public List<ResourcefulConfigElement> elements() {
        return List.of();
    }

    @NotNull
    public LinkedHashMap<String, ResourcefulConfig> categories();

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion=">1.21.5")
    default public LinkedHashMap<String, ResourcefulConfigEntry> entries() {
        LinkedHashMap<String, ResourcefulConfigEntry> entries = new LinkedHashMap<String, ResourcefulConfigEntry>();
        for (ResourcefulConfigElement element : this.elements()) {
            if (!(element instanceof ResourcefulConfigEntryElement)) continue;
            ResourcefulConfigEntryElement entry = (ResourcefulConfigEntryElement)element;
            entries.put(entry.id(), entry.entry());
        }
        return entries;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion=">1.21.5")
    default public List<ResourcefulConfigButton> buttons() {
        ArrayList<ResourcefulConfigButton> buttons = new ArrayList<ResourcefulConfigButton>();
        for (ResourcefulConfigElement element : this.elements()) {
            if (!(element instanceof ResourcefulConfigButton)) continue;
            ResourcefulConfigButton button = (ResourcefulConfigButton)element;
            buttons.add(button);
        }
        return buttons;
    }

    @NotNull
    public ResourcefulConfigInfo info();

    public String id();

    public void save();

    public void load(Consumer<ConfigPatchEvent> var1);
}

