/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.base;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public interface MultiLineLabel {
    public static final MultiLineLabel EMPTY = new MultiLineLabel(){

        @Override
        public void renderLeftAligned(GuiGraphics guiGraphics, int left, int top, int lineHeight, int color) {
        }

        @Override
        @Nullable
        public Style getStyleAtLeftAligned(int i, int j, int k, double d, double e) {
            return null;
        }

        @Override
        public int getLineCount() {
            return 0;
        }

        @Override
        public int getWidth() {
            return 0;
        }
    };

    public static MultiLineLabel create(Font font, Component ... components) {
        return MultiLineLabel.create(font, Integer.MAX_VALUE, Integer.MAX_VALUE, components);
    }

    public static MultiLineLabel create(Font font, int i, Component ... components) {
        return MultiLineLabel.create(font, i, Integer.MAX_VALUE, components);
    }

    public static MultiLineLabel create(Font font, Component component, int i) {
        return MultiLineLabel.create(font, i, Integer.MAX_VALUE, component);
    }

    public static MultiLineLabel create(final Font font, final int maxWidth, final int maxRows, final Component ... components) {
        return components.length == 0 ? EMPTY : new MultiLineLabel(){
            @Nullable
            private List<TextAndWidth> cachedTextAndWidth;
            @Nullable
            private Language splitWithLanguage;

            @Override
            public void renderLeftAligned(GuiGraphics guiGraphics, int left, int top, int lineHeight, int color) {
                int y = top;
                for (TextAndWidth line : this.getSplitMessage()) {
                    guiGraphics.drawString(font, line.text(), left, y, color);
                    y += lineHeight;
                }
            }

            @Override
            @Nullable
            public Style getStyleAtLeftAligned(int left, int top, int lineHeight, double mouseX, double mouseY) {
                if (mouseX >= (double)left) {
                    List<TextAndWidth> lines = this.getSplitMessage();
                    int lineIndex = Mth.floor((double)((mouseY - (double)top) / (double)lineHeight));
                    if (lineIndex >= 0 && lineIndex < lines.size()) {
                        TextAndWidth line = lines.get(lineIndex);
                        return font.getSplitter().componentStyleAtWidth(line.text, Mth.floor((double)(mouseX - (double)left)));
                    }
                }
                return null;
            }

            private List<TextAndWidth> getSplitMessage() {
                Language language = Language.getInstance();
                if (this.cachedTextAndWidth == null || language != this.splitWithLanguage) {
                    this.splitWithLanguage = language;
                    ArrayList lines = new ArrayList();
                    for (Component component : components) {
                        lines.addAll(font.getSplitter().splitLines((FormattedText)component, maxWidth, Style.EMPTY));
                    }
                    this.cachedTextAndWidth = new ArrayList<TextAndWidth>();
                    int ix = Math.min(lines.size(), maxRows);
                    List list2 = lines.subList(0, ix);
                    for (int i = 0; i < list2.size(); ++i) {
                        FormattedText line = (FormattedText)list2.get(i);
                        FormattedCharSequence lineText = Language.getInstance().getVisualOrder(line);
                        if (i == list2.size() - 1 && ix == maxRows && ix != lines.size()) {
                            FormattedText formattedText2 = font.substrByWidth(line, font.width(line) - font.width((FormattedText)CommonComponents.ELLIPSIS));
                            FormattedText formattedText3 = FormattedText.composite((FormattedText[])new FormattedText[]{formattedText2, CommonComponents.ELLIPSIS});
                            this.cachedTextAndWidth.add(new TextAndWidth(Language.getInstance().getVisualOrder(formattedText3), font.width(formattedText3)));
                            continue;
                        }
                        this.cachedTextAndWidth.add(new TextAndWidth(lineText, font.width(lineText)));
                    }
                }
                return this.cachedTextAndWidth;
            }

            @Override
            public int getLineCount() {
                return this.getSplitMessage().size();
            }

            @Override
            public int getWidth() {
                return Math.min(maxWidth, this.getSplitMessage().stream().mapToInt(TextAndWidth::width).max().orElse(0));
            }
        };
    }

    public void renderLeftAligned(GuiGraphics var1, int var2, int var3, int var4, int var5);

    @Nullable
    public Style getStyleAtLeftAligned(int var1, int var2, int var3, double var4, double var6);

    public int getLineCount();

    public int getWidth();

    public record TextAndWidth(FormattedCharSequence text, int width) {
    }
}

