/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.base;

import com.teamresourceful.resourcefulconfig.client.components.base.MultiLineLabel;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractStringWidget;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.SingleKeyCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiLineTextWidget
extends AbstractStringWidget {
    private OptionalInt maxWidth = OptionalInt.empty();
    private OptionalInt maxRows = OptionalInt.empty();
    private final SingleKeyCache<CacheKey, MultiLineLabel> cache = Util.singleKeyCache(cacheKey -> cacheKey.maxRows.isPresent() ? MultiLineLabel.create(font, cacheKey.maxWidth, cacheKey.maxRows.getAsInt(), cacheKey.message) : MultiLineLabel.create(font, cacheKey.message, cacheKey.maxWidth));
    private boolean allowHoverComponents = false;
    @Nullable
    private Consumer<Style> componentClickHandler = null;

    public MultiLineTextWidget(Component component, Font font) {
        this(0, 0, component, font);
    }

    public MultiLineTextWidget(int i, int j, Component component, Font font) {
        super(i, j, 0, 0, component, font);
        this.active = true;
    }

    public MultiLineTextWidget setColor(int i) {
        super.setColor(i);
        return this;
    }

    public MultiLineTextWidget setMaxWidth(int i) {
        this.maxWidth = OptionalInt.of(i);
        return this;
    }

    public MultiLineTextWidget setMaxRows(int i) {
        this.maxRows = OptionalInt.of(i);
        return this;
    }

    public MultiLineTextWidget configureStyleHandling(boolean bl, @Nullable Consumer<Style> consumer) {
        this.allowHoverComponents = bl;
        this.componentClickHandler = consumer;
        return this;
    }

    public int getWidth() {
        return ((MultiLineLabel)this.cache.getValue((Object)this.getFreshCacheKey())).getWidth();
    }

    public int getHeight() {
        return ((MultiLineLabel)this.cache.getValue((Object)this.getFreshCacheKey())).getLineCount() * 9;
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Style style;
        MultiLineLabel multiLineLabel = (MultiLineLabel)this.cache.getValue((Object)this.getFreshCacheKey());
        int left = this.getX();
        int top = this.getY();
        int color = this.getColor();
        multiLineLabel.renderLeftAligned(graphics, left, top, 9, color);
        if (this.allowHoverComponents && graphics.containsPointInScissor(mouseX, mouseY) && (style = this.getComponentStyleAt(mouseX, mouseY)) != null) {
            graphics.renderComponentHoverEffect(this.getFont(), style, mouseX, mouseY);
        }
    }

    @Nullable
    private Style getComponentStyleAt(double mouseX, double mouseY) {
        MultiLineLabel multiLineLabel = (MultiLineLabel)this.cache.getValue((Object)this.getFreshCacheKey());
        int left = this.getX();
        int top = this.getY();
        return multiLineLabel.getStyleAtLeftAligned(left, top, 9, mouseX, mouseY);
    }

    public void onClick(double mouseX, double mouseY) {
        Style style;
        if (this.componentClickHandler != null && (style = this.getComponentStyleAt(mouseX, mouseY)) != null) {
            this.componentClickHandler.accept(style);
            return;
        }
        super.onClick(mouseX, mouseY);
    }

    public void playDownSound(@NotNull SoundManager manager) {
    }

    private CacheKey getFreshCacheKey() {
        return new CacheKey(this.getMessage(), this.maxWidth.orElse(Integer.MAX_VALUE), this.maxRows);
    }

    record CacheKey(Component message, int maxWidth, OptionalInt maxRows) {
    }
}

