/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.header;

import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfigCategory;
import com.teamresourceful.resourcefulconfig.client.ConfigScreenContext;
import com.teamresourceful.resourcefulconfig.client.UIConstants;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.ContainerWidget;
import com.teamresourceful.resourcefulconfig.client.components.base.SpriteButton;
import com.teamresourceful.resourcefulconfig.client.components.options.types.StringOptionWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.renderer.RenderType;

public class HeaderControlsWidget
extends ContainerWidget {
    private final LinearLayout layout = LinearLayout.horizontal().spacing(5);
    protected final StringOptionWidget searchWidget;

    public HeaderControlsWidget(int width, ResourcefulConfig config, ConfigScreenContext context, Runnable onSearchUpdate) {
        super(0, 0, width, 0);
        boolean willGoBack = config instanceof ResourcefulConfigCategory;
        this.layout.addChild((LayoutElement)SpriteButton.builder(12, 12).padding(2).sprite(!willGoBack ? ModSprites.CROSS : ModSprites.CHEVRON_LEFT).onPress(() -> Minecraft.getInstance().screen.onClose()).tooltip(!willGoBack ? UIConstants.CLOSE : UIConstants.BACK).build());
        this.searchWidget = new StringOptionWidget(context::getQuery, name -> {
            if (context.setQuery((String)name)) {
                onSearchUpdate.run();
            }
            return true;
        }, false);
        this.searchWidget.setWidth(this.width - 20 - 16 - 5);
        this.searchWidget.setPlaceholder("Search...", -9276296);
        this.layout.addChild((LayoutElement)this.searchWidget);
        this.layout.arrangeElements();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget(x$0);
        });
        this.height = this.layout.getHeight() + 20;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blitSprite(RenderType::guiTextured, ModSprites.CONTAINER, this.getX(), this.getY(), this.width, this.height);
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void positionUpdated() {
        this.layout.setPosition(this.getX() + 10, this.getY() + 10);
    }
}

