/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options;

import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.client.components.base.ContainerWidget;
import com.teamresourceful.resourcefulconfig.client.components.base.ListWidget;
import com.teamresourceful.resourcefulconfig.client.components.base.MultiLineTextWidget;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.layouts.EqualSpacingLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class OptionItem
extends ContainerWidget
implements ListWidget.Item {
    protected static final int PADDING = 10;
    private final Component title;
    private final Component description;
    private final List<AbstractWidget> widgets;

    public OptionItem(ResourcefulConfigEntry entry, List<AbstractWidget> widgets) {
        this((Component)entry.options().title().toComponent(), (Component)entry.options().comment().toComponent(), widgets);
    }

    public OptionItem(Component title, Component description, List<AbstractWidget> widgets) {
        super(0, 0, 0, 0);
        this.title = title.copy().withColor(-329226);
        this.description = description;
        this.widgets = widgets;
        this.init();
    }

    public void init() {
        this.clear();
        Font font = Minecraft.getInstance().font;
        int half = (int)((float)this.width * 0.5f);
        EqualSpacingLayout layout = new EqualSpacingLayout(this.width - 20, 0, EqualSpacingLayout.Orientation.HORIZONTAL);
        LinearLayout titleDesc = LinearLayout.vertical().spacing(4);
        titleDesc.addChild((LayoutElement)new StringWidget(half, 9, this.title, font).alignLeft());
        titleDesc.addChild((LayoutElement)new MultiLineTextWidget(this.description, font).setMaxWidth(half).setColor(-9276296).configureStyleHandling(true, OptionItem::handleStyle));
        LinearLayout options = LinearLayout.horizontal().spacing(4);
        for (AbstractWidget widget : this.widgets) {
            options.addChild((LayoutElement)widget);
        }
        layout.addChild((LayoutElement)titleDesc);
        layout.addChild((LayoutElement)options, settings -> settings.alignVerticallyMiddle().alignHorizontallyRight());
        layout.arrangeElements();
        layout.setPosition(this.getX() + 10, this.getY() + 10);
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget(x$0);
        });
        this.height = layout.getHeight() + 20;
    }

    @Override
    protected void positionUpdated() {
        this.init();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.getChildAt(mouseX, mouseY).isEmpty()) {
            this.setFocused(null);
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void setItemWidth(int width) {
        boolean changed = this.width != width;
        this.setWidth(width);
        if (!changed) {
            return;
        }
        this.init();
    }

    private static void handleStyle(@NotNull Style style) {
        ClickEvent event = style.getClickEvent();
        Minecraft mc = Minecraft.getInstance();
        if (event != null) {
            ClickEvent clickEvent = event;
            Objects.requireNonNull(clickEvent);
            ClickEvent clickEvent2 = clickEvent;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClickEvent.CopyToClipboard.class, ClickEvent.OpenUrl.class}, (Object)clickEvent2, n)) {
                case 0: {
                    ClickEvent.CopyToClipboard clipboard = (ClickEvent.CopyToClipboard)clickEvent2;
                    mc.keyboardHandler.setClipboard(clipboard.value());
                    break;
                }
                case 1: {
                    ClickEvent.OpenUrl link = (ClickEvent.OpenUrl)clickEvent2;
                    Screen screen = Minecraft.getInstance().screen;
                    if (screen == null) {
                        return;
                    }
                    ConfirmLinkScreen.confirmLinkNow((Screen)screen, (URI)link.uri());
                    break;
                }
            }
        }
    }
}

