/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.text;

import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.text.utils.TextBoxStringUtils;
import com.teamresourceful.resourcefulconfig.client.utils.ListenableState;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextBox
extends BaseWidget {
    protected static final int PADDING = 4;
    protected final Font font;
    protected final ListenableState<String> state;
    protected int textColor;
    private boolean shiftPressed;
    private int maxLength;
    private int displayPos;
    private int cursorPos;
    private int highlightPos;
    protected int placeholderColor;
    protected String placeholder;

    public TextBox(int width, int height, ListenableState<@NotNull String> state) {
        super(width, height);
        this.font = Minecraft.getInstance().font;
        this.textColor = -1;
        this.maxLength = Short.MAX_VALUE;
        this.placeholderColor = -1;
        this.placeholder = "";
        this.state = state;
        this.setCursorPosition(this.state.get().length());
        this.setHighlightPos(this.cursorPos);
        this.displayPos = 0;
    }

    public String getValue() {
        return this.state.get();
    }

    public void setValue(String text) {
        if (text.length() > this.maxLength) {
            this.state.set(text.substring(0, this.maxLength));
        } else {
            this.state.set(text);
        }
        this.moveCursorTo(this.state.get().length());
        this.setHighlightPos(this.cursorPos);
    }

    public String getHighlighted() {
        int min = Math.min(this.cursorPos, this.highlightPos);
        int max = Math.max(this.cursorPos, this.highlightPos);
        return this.state.get().substring(min, max);
    }

    public void insertText(String textToWrite) {
        String string;
        int l;
        int min = Math.min(this.cursorPos, this.highlightPos);
        int max = Math.max(this.cursorPos, this.highlightPos);
        int k = this.maxLength - this.state.get().length() - (min - max);
        if (k < (l = (string = TextBoxStringUtils.filterText(textToWrite)).length())) {
            string = string.substring(0, k);
            l = k;
        }
        String string2 = new StringBuilder(this.state.get()).replace(min, max, string).toString();
        this.state.set(string2);
        this.setCursorPosition(min + l);
        this.setHighlightPos(this.cursorPos);
    }

    private void deleteText(int count) {
        if (this.state.get().isEmpty()) {
            return;
        }
        if (Screen.hasControlDown()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteChars(this.getWordPosition(count) - this.cursorPos);
            }
        } else {
            this.deleteChars(count);
        }
    }

    public void deleteChars(int num) {
        if (!this.state.get().isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                int k;
                int i = this.getCursorPos(num);
                int j = Math.min(i, this.cursorPos);
                if (j != (k = Math.max(i, this.cursorPos))) {
                    String string = new StringBuilder(this.state.get()).delete(j, k).toString();
                    this.state.set(string);
                    this.moveCursorTo(j);
                }
            }
        }
    }

    public int getWordPosition(int numWords) {
        return this.getWordPosition(numWords, this.cursorPos);
    }

    private int getWordPosition(int n, int pos) {
        int i = pos;
        boolean bl = n < 0;
        int j = Math.abs(n);
        String value = this.state.get();
        for (int k = 0; k < j; ++k) {
            if (!bl) {
                int l = value.length();
                if ((i = value.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (i < l && value.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (i > 0 && value.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && value.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    private int getCursorPos(int delta) {
        return Util.offsetByCodepoints((String)this.state.get(), (int)this.cursorPos, (int)delta);
    }

    public void moveCursorTo(int pos) {
        this.setCursorPosition(pos);
        if (!this.shiftPressed) {
            this.setHighlightPos(this.cursorPos);
        }
    }

    public void setCursorPosition(int pos) {
        this.cursorPos = Mth.clamp((int)pos, (int)0, (int)this.state.get().length());
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isVisible() || !this.isFocused()) {
            return false;
        }
        this.shiftPressed = Screen.hasShiftDown();
        if (Screen.isSelectAll((int)keyCode)) {
            this.moveCursorTo(this.state.get().length());
            this.setHighlightPos(0);
            return true;
        }
        if (Screen.isCopy((int)keyCode)) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getHighlighted());
            return true;
        }
        if (Screen.isPaste((int)keyCode)) {
            this.insertText(Minecraft.getInstance().keyboardHandler.getClipboard());
            return true;
        }
        if (Screen.isCut((int)keyCode)) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getHighlighted());
            this.insertText("");
            return true;
        }
        return switch (keyCode) {
            case 259 -> {
                this.shiftPressed = false;
                this.deleteText(-1);
                this.shiftPressed = Screen.hasShiftDown();
                yield true;
            }
            case 261 -> {
                this.shiftPressed = false;
                this.deleteText(1);
                this.shiftPressed = Screen.hasShiftDown();
                yield true;
            }
            case 262 -> {
                int pos = Screen.hasControlDown() ? this.getWordPosition(1) : this.getCursorPos(1);
                this.moveCursorTo(pos);
                yield true;
            }
            case 263 -> {
                int pos = Screen.hasControlDown() ? this.getWordPosition(-1) : this.getCursorPos(-1);
                this.moveCursorTo(pos);
                yield true;
            }
            case 268 -> {
                this.moveCursorTo(0);
                yield true;
            }
            case 269 -> {
                this.moveCursorTo(this.state.get().length());
                yield true;
            }
            default -> false;
        };
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (!this.isVisible() || !this.isFocused()) {
            return false;
        }
        if (!TextBoxStringUtils.isAllowedChatCharacter(codePoint)) {
            return false;
        }
        this.insertText(Character.toString(codePoint));
        return true;
    }

    public void onClick(double mouseX, double mouseY) {
        int relativeX = Mth.floor((double)mouseX) - this.getX() - 4;
        String string = TextBoxStringUtils.plainHeadByWidth(this.font, this.state.get().substring(this.displayPos), this.width - 8);
        this.moveCursorTo(TextBoxStringUtils.plainHeadByWidth(this.font, string, relativeX).length() + this.displayPos);
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isVisible()) {
            boolean showPlaceholder;
            String value = this.state.get();
            boolean bl = showPlaceholder = value.isEmpty() && !this.placeholder.isEmpty() && !this.isFocused();
            if (showPlaceholder) {
                value = this.placeholder;
            }
            int textColor = showPlaceholder ? this.placeholderColor : this.textColor;
            int displayCursorDiff = this.cursorPos - this.displayPos;
            int displayHighlightDiff = this.highlightPos - this.displayPos;
            String truncatedValue = TextBoxStringUtils.plainHeadByWidth(this.font, value.substring(this.displayPos), this.width - 8);
            boolean cursorVisible = displayCursorDiff >= 0 && displayCursorDiff <= truncatedValue.length();
            boolean showCursor = this.isFocused() && cursorVisible && System.currentTimeMillis() / 500L % 2L == 0L;
            int l = this.getX() + 4;
            int m = this.getY() + (this.height - 8) / 2;
            int n = l;
            if (displayHighlightDiff > truncatedValue.length()) {
                displayHighlightDiff = truncatedValue.length();
            }
            if (!truncatedValue.isEmpty()) {
                String string2 = cursorVisible ? truncatedValue.substring(0, displayCursorDiff) : truncatedValue;
                graphics.drawString(this.font, TextBoxStringUtils.format(string2), l, m, textColor, false);
                n = l + TextBoxStringUtils.width(this.font, string2) + 1;
            }
            boolean bl3 = this.cursorPos < value.length() || value.length() >= this.maxLength;
            int o = n;
            if (!cursorVisible) {
                o = displayCursorDiff > 0 ? l + this.width : l;
            } else if (bl3) {
                o = n - 1;
                --n;
            }
            if (!truncatedValue.isEmpty() && cursorVisible && displayCursorDiff < truncatedValue.length()) {
                graphics.drawString(this.font, TextBoxStringUtils.format(truncatedValue.substring(displayCursorDiff)), n, m, textColor, false);
            }
            if (showCursor) {
                graphics.fill(RenderType.gui(), o - 1, m - 1, o, m + 1 + 9, -3092272);
            }
            if (displayHighlightDiff != displayCursorDiff) {
                int p = l + TextBoxStringUtils.width(this.font, truncatedValue.substring(0, displayHighlightDiff));
                this.renderHighlight(graphics, o, m - 1, p - 1, m + 1 + 9);
            }
        }
    }

    private void renderHighlight(GuiGraphics graphics, int minX, int minY, int maxX, int maxY) {
        int x1 = Mth.clamp((int)Math.min(minX, maxX), (int)this.getX(), (int)(this.getX() + this.width - 4));
        int x2 = Mth.clamp((int)Math.max(minX, maxX), (int)this.getX(), (int)(this.getX() + this.width - 4));
        int y1 = Math.min(minY, maxY);
        int y2 = Math.max(minY, maxY);
        graphics.fill(RenderType.guiTextHighlight(), x1, y1, x2, y2, -16776961);
    }

    @Nullable
    public ComponentPath nextFocusPath(@NotNull FocusNavigationEvent event) {
        return this.visible ? super.nextFocusPath(event) : null;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.visible && mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height);
    }

    public void setHighlightPos(int position) {
        int length = this.state.get().length();
        this.highlightPos = Mth.clamp((int)position, (int)0, (int)length);
        if (this.displayPos > length) {
            this.displayPos = length;
        }
        int textWidth = this.width - 8;
        String string = TextBoxStringUtils.plainHeadByWidth(this.font, this.state.get().substring(this.displayPos), textWidth);
        int k = string.length() + this.displayPos;
        if (this.highlightPos == this.displayPos) {
            this.displayPos -= TextBoxStringUtils.plainTailByWidth(this.font, this.state.get(), textWidth).length();
        }
        if (this.highlightPos > k) {
            this.displayPos += this.highlightPos - k;
        } else if (this.highlightPos <= this.displayPos) {
            this.displayPos -= this.displayPos - this.highlightPos;
        }
        this.displayPos = Mth.clamp((int)this.displayPos, (int)0, (int)length);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setTextColor(int color) {
        this.textColor = color;
    }

    public void setPlaceholder(String placeholder, int color) {
        this.placeholder = placeholder;
        this.placeholderColor = color;
    }
}

