/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.text.multiline;

import com.teamresourceful.resourcefulconfig.client.components.options.text.multiline.MultilineStringView;
import com.teamresourceful.resourcefulconfig.client.components.options.text.utils.TextBoxStringUtils;
import com.teamresourceful.resourcefulconfig.client.utils.ListenableState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

class MultilineTextState {
    protected final Font font;
    protected final List<MultilineStringView> lines;
    protected final ListenableState<String> state;
    protected String value;
    protected int cursor;
    protected int selectCursor;
    protected boolean selecting;
    protected int lastWidth;

    public MultilineTextState(ListenableState<String> state) {
        this.font = Minecraft.getInstance().font;
        this.lines = new ArrayList<MultilineStringView>();
        this.state = state;
        this.setValue(this.state.get());
        this.state.registerListener(this::setValue);
    }

    public void setValue(@NotNull String string) {
        if (string.equals(this.value)) {
            return;
        }
        this.value = string;
        this.selectCursor = this.cursor = this.value.length();
        this.reflowDisplayLines();
        if (this.state.get().equals(this.value)) {
            return;
        }
        this.state.set(string);
    }

    public String value() {
        return this.value;
    }

    protected void insertText(String string) {
        if (!string.isEmpty() || this.hasSelection()) {
            MultilineStringView selection = this.selection();
            this.value = new StringBuilder(this.value).replace(selection.start(), selection.end(), string).toString();
            this.selectCursor = this.cursor = selection.start() + string.length();
            this.reflowDisplayLines();
            this.state.set(this.value);
        }
    }

    protected void deleteText(int i) {
        if (!this.hasSelection()) {
            this.selectCursor = Mth.clamp((int)(this.cursor + i), (int)0, (int)this.value.length());
        }
        this.insertText("");
    }

    public int cursor() {
        return this.cursor;
    }

    protected MultilineStringView selection() {
        return new MultilineStringView(-1, Math.min(this.selectCursor, this.cursor), Math.max(this.selectCursor, this.cursor));
    }

    public int getLineAtCursor() {
        for (int i = 0; i < this.lines.size(); ++i) {
            MultilineStringView stringView = this.lines.get(i);
            if (this.cursor < stringView.start() || this.cursor > stringView.end()) continue;
            return i;
        }
        return -1;
    }

    protected void seekCursor(Whence whence, int i) {
        switch (whence) {
            case ABSOLUTE: {
                this.cursor = i;
                break;
            }
            case RELATIVE: {
                this.cursor += i;
                break;
            }
            case END: {
                this.cursor = this.value.length() + i;
            }
        }
        this.cursor = Mth.clamp((int)this.cursor, (int)0, (int)this.value.length());
        if (!this.selecting && !Screen.hasShiftDown()) {
            this.selectCursor = this.cursor;
        }
    }

    protected void moveCursorY(int direction) {
        if (direction != 0) {
            int j = TextBoxStringUtils.width(this.font, this.value.substring(this.getCursorLineView().start(), this.cursor)) + 2;
            MultilineStringView stringView = this.getCursorLineView(direction);
            int k = this.font.plainSubstrByWidth(this.value.substring(stringView.start(), stringView.end()), j).length();
            this.seekCursor(Whence.ABSOLUTE, stringView.start() + k);
        }
    }

    public List<MultilineStringView> lines(int width) {
        if (this.lastWidth != width) {
            this.lastWidth = width;
            this.reflowDisplayLines();
        }
        return this.lines;
    }

    public boolean hasSelection() {
        return this.selectCursor != this.cursor;
    }

    protected MultilineStringView getCursorLineView() {
        return this.getCursorLineView(0);
    }

    private MultilineStringView getCursorLineView(int i) {
        int line = this.getLineAtCursor();
        if (line < 0) {
            throw new IllegalStateException("Cursor is not within text (cursor = " + this.cursor + ", length = " + this.value.length() + ")");
        }
        return this.lines.get(Mth.clamp((int)(line + i), (int)0, (int)(this.lines.size() - 1)));
    }

    protected int getPreviousWordStart() {
        int i;
        if (this.value.isEmpty()) {
            return 0;
        }
        for (i = Mth.clamp((int)this.cursor, (int)0, (int)(this.value.length() - 1)); i > 0 && Character.isWhitespace(this.value.charAt(i - 1)); --i) {
        }
        while (i > 0 && !Character.isWhitespace(this.value.charAt(i - 1))) {
            --i;
        }
        return i;
    }

    protected int getNextWordStart() {
        int start;
        if (this.value.isEmpty()) {
            return 0;
        }
        for (start = Mth.clamp((int)this.cursor, (int)0, (int)(this.value.length() - 1)); start < this.value.length() && !Character.isWhitespace(this.value.charAt(start)); ++start) {
        }
        while (start < this.value.length() && Character.isWhitespace(this.value.charAt(start))) {
            ++start;
        }
        return start;
    }

    private void reflowDisplayLines() {
        this.lines.clear();
        if (this.value.isEmpty()) {
            this.lines.add(MultilineStringView.EMPTY);
        } else {
            String[] lines = this.value.split("\n", Integer.MAX_VALUE);
            int x = 0;
            for (int i = 0; i < lines.length; ++i) {
                int index = i;
                String line = lines[i];
                int xOffset = x;
                if (line.isEmpty()) {
                    this.lines.add(new MultilineStringView(index, xOffset, xOffset));
                } else {
                    TextBoxStringUtils.split(this.font, line, this.lastWidth, (style, start, end) -> this.lines.add(new MultilineStringView(index, xOffset + start, xOffset + end)));
                }
                x += line.length() + 1;
            }
        }
    }
}

