/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.utils;

import com.mojang.logging.LogUtils;
import com.teamresourceful.resourcefulconfig.common.utils.neoforge.ModUtilsImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.reflect.Array;
import java.nio.file.Path;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

public final class ModUtils {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Contract(pure=true)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigPath() {
        return ModUtilsImpl.getConfigPath();
    }

    @Contract(pure=true)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDev() {
        return ModUtilsImpl.isDev();
    }

    @Contract(pure=true)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String modid) {
        return ModUtilsImpl.isModLoaded(modid);
    }

    public static void log(String message) {
        LOGGER.info("[ResourcefulConfig] {}", (Object)message);
    }

    public static void log(String message, Throwable throwable) {
        LOGGER.info("[ResourcefulConfig] {}", (Object)message, (Object)throwable);
    }

    public static void debug(String message) {
        LOGGER.debug("[ResourcefulConfig] {}", (Object)message);
    }

    public static Enum<?>[] getEnumConstants(Class<?> clazz) {
        if (clazz.isEnum()) {
            return (Enum[])clazz.getEnumConstants();
        }
        if (clazz.getSuperclass().isEnum()) {
            return (Enum[])clazz.getSuperclass().getEnumConstants();
        }
        return new Enum[0];
    }

    public static <T> T[] castArray(Object[] array, Class<T> clazz) {
        Object[] newArray = (Object[])Array.newInstance(clazz, array.length);
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = clazz.cast(array[i]);
        }
        return newArray;
    }
}

