/*
 * Decompiled with CFR 0.152.
 */
package com.bleudev.ppl_utils;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;

public class PlatformHelper {
    private static <T> Optional<T> getModInfo(String modId, Function<ModMetadata, T> getter) {
        try {
            return FabricLoader.getInstance().getModContainer(modId).map(c -> getter.apply(c.getMetadata()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static String getModVersion(String modId) {
        return PlatformHelper.getModInfo(modId, m -> m.getVersion().getFriendlyString()).orElse("0.0.0");
    }

    public static String getModVersion(String modId, String before) {
        String v;
        int i = (v = PlatformHelper.getModVersion(modId)).indexOf(before);
        return v.substring(0, i == -1 ? v.length() : i);
    }

    public static String getModName(String modId) {
        return PlatformHelper.getModInfo(modId, ModMetadata::getName).orElse("Unknown");
    }

    public static List<String> getModAuthors(String modId) {
        return PlatformHelper.getModInfo(modId, m -> m.getAuthors().stream().map(Person::getName).toList()).orElse(List.of());
    }
}

