package com.bleudev.ppl_utils.mixin.client;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static com.bleudev.ppl_utils.client.ClientCallbacks.shouldRenderChatMessage;

import net.minecraft.class_303;
import net.minecraft.class_338;

@Mixin(class_338.class)
public class ChatHudMixin {
    @Inject(method = "addVisibleMessage", at = @At("HEAD"), cancellable = true)
    private void cancelRenderingOfSomeMessages(class_303 message, CallbackInfo ci) {
        if (!shouldRenderChatMessage(message)) ci.cancel();
    }
}
