package com.bleudev.ppl_utils.client;

import com.bleudev.ppl_utils.client.compat.modmenu.PplUtilsConfig;
import com.bleudev.ppl_utils.client.custom.Keys;
import com.bleudev.ppl_utils.client.custom.debug.WorldBorderDebugHudEntry;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_11631;
import net.minecraft.class_124;
import net.minecraft.class_2561;

import static com.bleudev.ppl_utils.PplUtilsConst.*;
import static com.bleudev.ppl_utils.client.ClientCallbacks.executeLobby;
import static com.bleudev.ppl_utils.util.RegistryUtils.getIdentifier;
import static com.bleudev.ppl_utils.util.TextUtils.link;
import static net.minecraft.class_155.field_29703;

public class PplUtilsClient implements ClientModInitializer {
    int beta_mode_message_ticks;
    boolean cached_join_leave_rendering = PplUtilsConfig.do_join_leave_messages_rendering;

    @Override
    public void onInitializeClient() {
        PplUtilsConfig.initialize();
        Keys.initialize();

        beta_mode_message_ticks = 0;

        LOGGER.debug("Register {} debug hud entry", getIdentifier("world_border"));
        class_11631.method_72763(getIdentifier("world_border"), new WorldBorderDebugHudEntry());

        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            LOGGER.info("Try send beta mode message");
            if (BETA_MODE_ENABLED && client.field_1724 != null && beta_mode_message_ticks == 0) {
                client.field_1724.method_7353(
                    class_2561.method_43471("chat.message.join.beta")
                        .method_27693("\n")
                        .method_10852(link(ISSUES_PAGE))
                        .method_27692(class_124.field_1065),
                    false);
                beta_mode_message_ticks = 10 * field_29703;
                LOGGER.info("Successfully sent beta mode message");
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (beta_mode_message_ticks > 0) beta_mode_message_ticks--;

            while (Keys.LOBBY_KEY.method_1436()) executeLobby();

            if (cached_join_leave_rendering != PplUtilsConfig.do_join_leave_messages_rendering)
                client.field_1705.method_1743().method_1817();
            cached_join_leave_rendering = PplUtilsConfig.do_join_leave_messages_rendering;
        });
    }
}
