package com.bleudev.ppl_utils.mixin.client;

import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_340;

import static com.bleudev.ppl_utils.util.LangUtils.round;

@Mixin(class_340.class)
public class DebugHudMixin {
    @Inject(method = "getLeftText", at = @At("RETURN"), cancellable = true)
    private void addWorldBorderDebugHudEntry(@NotNull CallbackInfoReturnable<List<String>> cir) {
        var l = new ArrayList<>(cir.getReturnValue());

        class_310 client = class_310.method_1551();
        if (client.field_1687 != null)
            l.add("World border: " + round(client.field_1687.method_8621().method_11965(), 3));

        cir.setReturnValue(l);
    }
}
