/*
 * Decompiled with CFR 0.152.
 */
package com.bleudev.ppl_utils;

import com.bleudev.ppl_utils.PplUtilsConst;
import com.google.gson.FormattingStyle;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.Strictness;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_8144;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataStorageHelper {
    private static final String PATH = "ppl_utils_data.json";
    private static StorageData data = new StorageData(0L, 0L);

    @NotNull
    private static Path getFullpath() {
        return FabricLoader.getInstance().getConfigDir().resolve(PATH);
    }

    public static void save() {
        try {
            Files.writeString(DataStorageHelper.getFullpath(), (CharSequence)Objects.requireNonNull(data.toJsonString()), new OpenOption[0]);
        }
        catch (IOException e) {
            PplUtilsConst.LOGGER.error(e.getLocalizedMessage());
        }
    }

    public static void save(StorageData data) {
        DataStorageHelper.data = data;
        DataStorageHelper.save();
    }

    public static void load() {
        if (Files.exists(DataStorageHelper.getFullpath(), new LinkOption[0])) {
            try {
                data = StorageData.fromJsonString(Files.readString(DataStorageHelper.getFullpath()));
            }
            catch (IOException e) {
                PplUtilsConst.LOGGER.error(e.getLocalizedMessage());
            }
        }
    }

    public static StorageData getData() {
        return data;
    }

    public record StorageData(long startRestartTime, long restartTime) {
        @Nullable
        private String toJsonString() {
            JsonObject object = new JsonObject();
            object.addProperty("startRestartTime", (Number)this.startRestartTime);
            object.addProperty("restartTime", (Number)this.restartTime);
            try {
                StringWriter stringWriter = new StringWriter();
                JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
                jsonWriter.setFormattingStyle(FormattingStyle.PRETTY);
                jsonWriter.setStrictness(Strictness.LENIENT);
                Streams.write((JsonElement)object, (JsonWriter)jsonWriter);
                return stringWriter.toString();
            }
            catch (IOException ignored) {
                return null;
            }
        }

        @NotNull
        private static StorageData fromJsonString(String jsonString) {
            JsonObject object = JsonParser.parseString((String)jsonString).getAsJsonObject();
            return new StorageData((Long)class_8144.method_49078((Object)object.get("startRestartTime"), JsonElement::getAsLong, (Object)0L), (Long)class_8144.method_49078((Object)object.get("restartTime"), JsonElement::getAsLong, (Object)0L));
        }
    }
}

