/*
 * Decompiled with CFR 0.152.
 */
package com.bleudev.ppl_utils;

import com.bleudev.ppl_utils.ClientCallbacks;
import com.bleudev.ppl_utils.DataStorageHelper;
import com.bleudev.ppl_utils.PplUtilsConst;
import com.bleudev.ppl_utils.config.PplUtilsConfig;
import com.bleudev.ppl_utils.custom.Keys;
import com.bleudev.ppl_utils.custom.debug.hud.WorldBorderDebugHudEntry;
import com.bleudev.ppl_utils.util.RegistryUtils;
import com.bleudev.ppl_utils.util.ServerUtils;
import com.bleudev.ppl_utils.util.TextUtils;
import com.bleudev.ppl_utils.util.helper.RestartHelper;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_11631;
import net.minecraft.class_11632;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class PepelandUtils
implements ClientModInitializer {
    int beta_mode_message_ticks;
    private RestartHelper restartHelper;

    public void onInitializeClient() {
        PplUtilsConfig.initialize();
        Keys.initialize();
        DataStorageHelper.load();
        DataStorageHelper.save();
        this.beta_mode_message_ticks = 0;
        this.restartHelper = new RestartHelper();
        PplUtilsConst.LOGGER.debug("Register {} debug hud entry", (Object)RegistryUtils.getIdentifier("world_border"));
        class_11631.method_72763((class_2960)RegistryUtils.getIdentifier("world_border"), (class_11632)new WorldBorderDebugHudEntry());
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            PplUtilsConst.LOGGER.info("Try send beta mode message");
            if (PplUtilsConst.BETA_MODE_ENABLED && client.field_1724 != null && this.beta_mode_message_ticks == 0) {
                client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"chat.message.join.beta").method_27693("\n").method_10852((class_2561)TextUtils.link("https://github.com/bleudev/ppl_utils/issues")).method_27692(class_124.field_1065), false);
                this.beta_mode_message_ticks = 12000;
                PplUtilsConst.LOGGER.info("Successfully sent beta mode message");
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> this.restartHelper.onDisconnect());
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (this.beta_mode_message_ticks > 0) {
                --this.beta_mode_message_ticks;
            }
            while (Keys.LOBBY_KEY.method_1436()) {
                ClientCallbacks.executeLobby(client);
            }
            if (client.field_1724 == null) {
                return;
            }
            this.restartHelper.update(client);
        });
        ClientReceiveMessageEvents.CHAT.register((text, signedMessage, gameProfile, parameters, instant) -> {
            if (!ServerUtils.isClientOnPepeland()) {
                return;
            }
            String content = text.getString().replaceAll("<[^< >]+> *", "");
            content = content.replaceAll("\\[PPL[0-9]*]: ", "");
            try {
                if (content.contains("\u0420\u0435\u0441\u0442\u0430\u0440\u0442 \u0447\u0435\u0440\u0435\u0437")) {
                    long time = Long.parseLong(content.replaceAll("[^0-9]", ""));
                    RestartHelper.runRestartBar(time * (long)(content.contains("\u043c\u0438\u043d\u0443\u0442") ? 60000 : 1000));
                }
            }
            catch (NumberFormatException ignored) {
                PplUtilsConst.LOGGER.error("Unexpected number format exception while parsing \"{}\" string. Please report about it.", (Object)content);
            }
        });
    }
}

