/*
 * Decompiled with CFR 0.152.
 */
package com.bleudev.ppl_utils.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LangUtils {
    private static double precision(@NotNull BigDecimal d, int p) {
        return d.setScale(p, RoundingMode.DOWN).doubleValue();
    }

    public static double round(double x, int p) {
        return LangUtils.precision(new BigDecimal(x), p);
    }

    @NotNull
    public static <T> List<T> union(List<T> list1, List<T> list2, boolean unmodifiable) {
        ArrayList<T> a = new ArrayList<T>(list1);
        a.addAll(list2);
        if (unmodifiable) {
            return Collections.unmodifiableList(a);
        }
        return a.stream().toList();
    }

    @NotNull
    public static <T> List<T> unmodifiableUnion(List<T> list1, List<T> list2) {
        return LangUtils.union(list1, list2, true);
    }
}

