/*
 * Decompiled with CFR 0.152.
 */
package com.bleudev.ppl_utils.util;

import com.bleudev.ppl_utils.PplUtilsConst;
import com.bleudev.ppl_utils.mixin.client.PlayerListHudAccessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_642;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerUtils {
    public static boolean isClientOn(@NotNull class_310 client, String serverIp) {
        class_642 server = client.method_1558();
        if (server == null) {
            return false;
        }
        return Objects.equals(server.field_3761, serverIp);
    }

    public static boolean isClientOn(@NotNull class_310 client, @NotNull Collection<String> serverIps) {
        return serverIps.stream().anyMatch(n -> ServerUtils.isClientOn(client, n));
    }

    public static boolean isClientOnPepeland(@NotNull class_310 client) {
        return ServerUtils.isClientOn(client, PplUtilsConst.PEPELAND_IPS);
    }

    public static boolean isClientOnPepeland() {
        return ServerUtils.isClientOnPepeland(class_310.method_1551());
    }

    public static boolean isLobbyCommandWorking(@NotNull class_310 client) {
        if (!ServerUtils.isClientOn(client, PplUtilsConst.SUPPORTS_LOBBY_COMMAND_IPS)) {
            return false;
        }
        if (ServerUtils.isClientOnPepeland(client)) {
            return !PepelandWorlds.isInLobby(client);
        }
        return true;
    }

    public static void executeCommand(@NotNull class_310 client, @NotNull String command) {
        Objects.requireNonNull(client.method_1562()).method_45730(command);
    }

    public static void executeCommand(String command) {
        ServerUtils.executeCommand(class_310.method_1551(), command);
    }

    public static class PepelandWorlds {
        @Nullable
        private static PplWorld getCurrentWorld(@NotNull class_310 client) {
            class_2561 header = ((PlayerListHudAccessor)client.field_1705.method_1750()).ppl_utils$header();
            if (header == null) {
                return null;
            }
            String worldPlayerListName = "\u041c\u0438\u0440: ";
            for (String l : header.getString().split("\n")) {
                if (!l.contains(worldPlayerListName)) continue;
                return PplWorld.from(l.replace(worldPlayerListName, "").replaceAll("[^A-Za-z\u0410-\u042f\u0430-\u044f #0-9]", "").strip()).orElse(null);
            }
            return null;
        }

        public static boolean isInLobby(@NotNull class_310 client) {
            return PepelandWorlds.getCurrentWorld(client) == PplWorld.LOBBY;
        }

        private static enum PplWorld {
            LOBBY("\u041b\u043e\u0431\u0431\u0438");

            private final String tabName;

            private PplWorld(String tabName) {
                this.tabName = tabName;
            }

            @NotNull
            private static Optional<PplWorld> from(String tabName) {
                return Arrays.stream(PplWorld.values()).filter(o -> o.tabName.equals(tabName)).findFirst();
            }
        }
    }
}

