/*
 * Decompiled with CFR 0.152.
 */
package com.bleudev.ppl_utils.util.helper;

import com.bleudev.ppl_utils.DataStorageHelper;
import com.bleudev.ppl_utils.config.PplUtilsConfig;
import com.bleudev.ppl_utils.util.ServerUtils;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_2629;
import net.minecraft.class_310;
import net.minecraft.class_337;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestartHelper {
    private static final UUID rtUuid = UUID.randomUUID();
    private static long restartTime = 0L;
    private static long startRestartTime = 0L;
    private boolean added_boss_bar = false;

    public static void runRestartBar(long restartTime) {
        RestartHelper.restartTime = restartTime;
        startRestartTime = System.currentTimeMillis();
        DataStorageHelper.save(new DataStorageHelper.StorageData(startRestartTime, restartTime));
    }

    public void update(@NotNull class_310 client) {
        restartTime = DataStorageHelper.getData().restartTime();
        startRestartTime = DataStorageHelper.getData().startRestartTime();
        class_1259 bossBar = this.getBossBar();
        class_337 hud = client.field_1705.method_1740();
        if (bossBar == null) {
            if (this.added_boss_bar) {
                hud.method_1795(class_2629.method_34090((UUID)rtUuid));
                this.added_boss_bar = false;
            }
            return;
        }
        if (this.added_boss_bar) {
            hud.method_1795(class_2629.method_34096((class_1259)bossBar));
            hud.method_1795(class_2629.method_34094((class_1259)bossBar));
            hud.method_1795(class_2629.method_34097((class_1259)bossBar));
        } else {
            hud.method_1795(class_2629.method_34089((class_1259)bossBar));
            this.added_boss_bar = true;
        }
    }

    public void onDisconnect() {
        this.added_boss_bar = false;
    }

    @Contract(value=" -> new")
    @Nullable
    private class_1259 getBossBar() {
        long remainingTime = restartTime - System.currentTimeMillis() + startRestartTime;
        if (remainingTime <= 0L || !PplUtilsConfig.render_restart_bar || !ServerUtils.isClientOnPepeland()) {
            return null;
        }
        class_5250 text = class_2561.method_43471((String)"bossbar.ppl_utils.restart").method_10852(this.formatRemainingTime(remainingTime));
        class_1259 bossBar = new class_1259(this, rtUuid, (class_2561)text, PplUtilsConfig.restart_bar_color, PplUtilsConfig.restart_bar_style){};
        bossBar.method_5408(1.0f - (float)remainingTime / (float)restartTime);
        return bossBar;
    }

    @Contract(pure=true)
    @NotNull
    private class_2561 formatRemainingTime(long millis) {
        long secs = millis / 1000L % 60L;
        long mins = millis / 1000L / 60L;
        class_5250 ans = class_2561.method_43473();
        if (mins > 0L) {
            ans = ans.method_27693(" " + mins + " ").method_10852(this.getMinutesString(mins));
        }
        if (secs > 0L) {
            ans = ans.method_27693(" " + secs + " ").method_10852(this.getSecondsString(secs));
        }
        if (mins == 0L && secs == 0L) {
            return class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)"bossbar.ppl_utils.restart.now"));
        }
        return ans;
    }

    @NotNull
    private class_2561 getSecondsString(long secs) {
        if (secs == 1L) {
            return class_2561.method_43471((String)"bossbar.ppl_utils.restart.seconds.0");
        }
        if (secs < 11L || secs > 14L) {
            if (secs % 10L == 1L) {
                return class_2561.method_43471((String)"bossbar.ppl_utils.restart.seconds.1");
            }
            if (secs % 10L >= 2L && secs % 10L <= 4L) {
                return class_2561.method_43471((String)"bossbar.ppl_utils.restart.seconds.2");
            }
        }
        return class_2561.method_43471((String)"bossbar.ppl_utils.restart.seconds");
    }

    @NotNull
    private class_2561 getMinutesString(long mins) {
        if (mins == 1L) {
            return class_2561.method_43471((String)"bossbar.ppl_utils.restart.minutes.0");
        }
        if (mins < 11L || mins > 14L) {
            if (mins % 10L == 1L) {
                return class_2561.method_43471((String)"bossbar.ppl_utils.restart.minutes.1");
            }
            if (mins % 10L >= 2L && mins % 10L <= 4L) {
                return class_2561.method_43471((String)"bossbar.ppl_utils.restart.minutes.2");
            }
        }
        return class_2561.method_43471((String)"bossbar.ppl_utils.restart.minutes");
    }
}

