package com.bleudev.ppl_utils.client.util;

import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_8144;

public class PplUtilsJavaUtils {
    public static final List<String> SUPPORTS_LOBBY_COMMAND_IPS = List.of("play.pepeland.net");

    public static boolean isClientOnServerSupportsLobbyCommand(class_310 client) {
        final var server = client.method_1558();
        if (server == null) return false;
        return class_8144.method_49078(server.field_3761, SUPPORTS_LOBBY_COMMAND_IPS::contains, false);
    }
    public static boolean isClientOnServerSupportsLobbyCommand() {
        return isClientOnServerSupportsLobbyCommand(class_310.method_1551());
    }

    public static void executeCommand(@NotNull class_310 client, @NotNull String command) {
        Objects.requireNonNull(client.method_1562()).method_45730(command);
    }
    public static void executeCommand(String command) {
        executeCommand(class_310.method_1551(), command);
    }
}
