package com.bleudev.ppl_utils.mixin.client;

import com.bleudev.ppl_utils.client.compat.modmenu.PplUtilsConfig;
import com.bleudev.ppl_utils.util.ServerUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import net.minecraft.class_8662;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static com.bleudev.ppl_utils.client.ClientCallbacks.executeLobby;

@Mixin(class_433.class)
public abstract class GameMenuScreenMixin extends class_437 {
    protected GameMenuScreenMixin(class_2561 title) {
        super(title);
    }

    // Rendering
    @Unique
    private class_2960 getLobbyButtonTexture() {
        return PplUtilsConfig.lobby_button_style.getSprite();
    }

    @Unique
    private void drawLobbyButton() {
        var btn = class_8662.method_52723(class_2561.method_43471("text.ppl_utils.game_menu.lobby_button.tooltip"),
            button -> executeLobby(), true)
            .method_52727(getLobbyButtonTexture(), 13, 13)
            .method_52726(20, 20)
            .method_52724();
        btn.method_48229(this.field_22789 / 2 - 125, this.field_22790 / 4 + 32);
        if (PplUtilsConfig.lobby_button_tooltip_enabled) btn.method_47400(class_7919.method_47407(btn.method_25369()));
        this.method_37063(btn);
    }

    @Inject(method = "initWidgets", at = @At("RETURN"))
    private void addLobbyButton(CallbackInfo ci) {
        if (PplUtilsConfig.lobby_button_enabled && ServerUtils.isClientOnServerSupportsLobbyCommand()) drawLobbyButton();
    }
}
