/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcompatibilities;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.neoforged.fml.ModList;

public final class CompatManager<TOwner, TBase>
implements Iterable<TBase> {
    private final Multimap<String, TBase> mods;

    private CompatManager(TOwner owner, Builder<TOwner, TBase> builder) {
        HashMultimap mods = HashMultimap.create();
        ModList modList = ModList.get();
        builder.mods.forEach((modId, factory) -> {
            if (modList.isLoaded(modId)) {
                mods.put(modId, ((Function)factory.get()).apply(owner));
            }
        });
        this.mods = Multimaps.unmodifiableMultimap((Multimap)mods);
    }

    @Override
    public Iterator<TBase> iterator() {
        return this.mods.values().iterator();
    }

    @Override
    public Spliterator<TBase> spliterator() {
        return this.mods.values().spliterator();
    }

    public Stream<TBase> stream() {
        return this.mods.values().stream();
    }

    public static <TOwner, TBase> CompatManager<TOwner, TBase> create(TOwner owner, Consumer<Builder<TOwner, TBase>> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        return new CompatManager(owner, builder);
    }

    public static final class Builder<TOwner, TBase> {
        private final Multimap<String, Supplier<Function<TOwner, TBase>>> mods = HashMultimap.create();

        @CanIgnoreReturnValue
        public Builder<TOwner, TBase> owned(String modId, Supplier<Function<TOwner, TBase>> factory) {
            this.mods.put((Object)modId, factory);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder<TOwner, TBase> owned(String modId, Supplier<Function<TOwner, TBase>> factory, Supplier<Function<TOwner, TBase>> ... factories) {
            this.owned(modId, factory);
            for (Supplier<Function<TOwner, TBase>> other : factories) {
                this.owned(modId, other);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<TOwner, TBase> with(String modId, Supplier<Supplier<TBase>> factory) {
            return this.owned(modId, () -> arg_0 -> Builder.lambda$with$0((Supplier)factory, arg_0));
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder<TOwner, TBase> with(String modId, Supplier<Supplier<TBase>> factory, Supplier<Supplier<TBase>> ... factories) {
            this.with(modId, factory);
            for (Supplier<Supplier<TBase>> other : factories) {
                this.with(modId, other);
            }
            return this;
        }

        private static /* synthetic */ Object lambda$with$0(Supplier factory, Object owner) {
            return ((Supplier)factory.get()).get();
        }
    }
}

