/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.common.collect;

import app.simplecloud.relocate.google.common.annotations.GwtCompatible;
import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.google.common.collect.ElementTypesAreNonnullByDefault;
import app.simplecloud.relocate.google.common.collect.Ordering;
import app.simplecloud.relocate.google.common.collect.SortedIterable;
import java.util.Comparator;
import java.util.SortedSet;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class SortedIterables {
    private SortedIterables() {
    }

    public static boolean hasSameComparator(Comparator<?> comparator, Iterable<?> elements) {
        Comparator<Object> comparator2;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(elements);
        if (elements instanceof SortedSet) {
            comparator2 = SortedIterables.comparator((SortedSet)elements);
        } else if (elements instanceof SortedIterable) {
            comparator2 = ((SortedIterable)elements).comparator();
        } else {
            return false;
        }
        return comparator.equals(comparator2);
    }

    public static <E> Comparator<? super E> comparator(SortedSet<E> sortedSet) {
        Comparator<E> result2 = sortedSet.comparator();
        if (result2 == null) {
            result2 = Ordering.natural();
        }
        return result2;
    }
}

