/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc;

import app.simplecloud.relocate.google.common.base.MoreObjects;
import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.io.grpc.CallCredentials;
import app.simplecloud.relocate.io.grpc.ClientStreamTracer;
import app.simplecloud.relocate.io.grpc.Deadline;
import app.simplecloud.relocate.io.grpc.ExperimentalApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@CheckReturnValue
@Immutable
public final class CallOptions {
    public static final CallOptions DEFAULT;
    @Nullable
    private final Deadline deadline;
    @Nullable
    private final Executor executor;
    @Nullable
    private final String authority;
    @Nullable
    private final CallCredentials credentials;
    @Nullable
    private final String compressorName;
    private final Object[][] customOptions;
    private final List<ClientStreamTracer.Factory> streamTracerFactories;
    @Nullable
    private final Boolean waitForReady;
    @Nullable
    private final Integer maxInboundMessageSize;
    @Nullable
    private final Integer maxOutboundMessageSize;

    private CallOptions(Builder builder2) {
        this.deadline = builder2.deadline;
        this.executor = builder2.executor;
        this.authority = builder2.authority;
        this.credentials = builder2.credentials;
        this.compressorName = builder2.compressorName;
        this.customOptions = builder2.customOptions;
        this.streamTracerFactories = builder2.streamTracerFactories;
        this.waitForReady = builder2.waitForReady;
        this.maxInboundMessageSize = builder2.maxInboundMessageSize;
        this.maxOutboundMessageSize = builder2.maxOutboundMessageSize;
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1767")
    public CallOptions withAuthority(@Nullable String authority) {
        Builder builder2 = CallOptions.toBuilder(this);
        builder2.authority = authority;
        return builder2.build();
    }

    public CallOptions withCallCredentials(@Nullable CallCredentials credentials) {
        Builder builder2 = CallOptions.toBuilder(this);
        builder2.credentials = credentials;
        return builder2.build();
    }

    public CallOptions withCompression(@Nullable String compressorName) {
        Builder builder2 = CallOptions.toBuilder(this);
        builder2.compressorName = compressorName;
        return builder2.build();
    }

    public CallOptions withDeadline(@Nullable Deadline deadline) {
        Builder builder2 = CallOptions.toBuilder(this);
        builder2.deadline = deadline;
        return builder2.build();
    }

    public CallOptions withDeadlineAfter(long duration, TimeUnit unit) {
        return this.withDeadline(Deadline.after(duration, unit));
    }

    @Nullable
    public Deadline getDeadline() {
        return this.deadline;
    }

    public CallOptions withWaitForReady() {
        Builder builder2 = CallOptions.toBuilder(this);
        builder2.waitForReady = Boolean.TRUE;
        return builder2.build();
    }

    public CallOptions withoutWaitForReady() {
        Builder builder2 = CallOptions.toBuilder(this);
        builder2.waitForReady = Boolean.FALSE;
        return builder2.build();
    }

    @Nullable
    public String getCompressor() {
        return this.compressorName;
    }

    @Nullable
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1767")
    public String getAuthority() {
        return this.authority;
    }

    @Nullable
    public CallCredentials getCredentials() {
        return this.credentials;
    }

    public CallOptions withExecutor(@Nullable Executor executor2) {
        Builder builder2 = CallOptions.toBuilder(this);
        builder2.executor = executor2;
        return builder2.build();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2861")
    public CallOptions withStreamTracerFactory(ClientStreamTracer.Factory factory) {
        ArrayList<ClientStreamTracer.Factory> newList = new ArrayList<ClientStreamTracer.Factory>(this.streamTracerFactories.size() + 1);
        newList.addAll(this.streamTracerFactories);
        newList.add(factory);
        Builder builder2 = CallOptions.toBuilder(this);
        builder2.streamTracerFactories = Collections.unmodifiableList(newList);
        return builder2.build();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2861")
    public List<ClientStreamTracer.Factory> getStreamTracerFactories() {
        return this.streamTracerFactories;
    }

    public <T> CallOptions withOption(Key<T> key2, T value) {
        Preconditions.checkNotNull(key2, "key");
        Preconditions.checkNotNull(value, "value");
        Builder builder2 = CallOptions.toBuilder(this);
        int existingIdx = -1;
        for (int i2 = 0; i2 < this.customOptions.length; ++i2) {
            if (!key2.equals(this.customOptions[i2][0])) continue;
            existingIdx = i2;
            break;
        }
        builder2.customOptions = new Object[this.customOptions.length + (existingIdx == -1 ? 1 : 0)][2];
        System.arraycopy(this.customOptions, 0, builder2.customOptions, 0, this.customOptions.length);
        if (existingIdx == -1) {
            builder2.customOptions[this.customOptions.length] = new Object[]{key2, value};
        } else {
            builder2.customOptions[existingIdx] = new Object[]{key2, value};
        }
        return builder2.build();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1869")
    public <T> T getOption(Key<T> key2) {
        Preconditions.checkNotNull(key2, "key");
        for (int i2 = 0; i2 < this.customOptions.length; ++i2) {
            if (!key2.equals(this.customOptions[i2][0])) continue;
            return (T)this.customOptions[i2][1];
        }
        return (T)((Key)key2).defaultValue;
    }

    @Nullable
    public Executor getExecutor() {
        return this.executor;
    }

    public boolean isWaitForReady() {
        return Boolean.TRUE.equals(this.waitForReady);
    }

    Boolean getWaitForReady() {
        return this.waitForReady;
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2563")
    public CallOptions withMaxInboundMessageSize(int maxSize) {
        Preconditions.checkArgument(maxSize >= 0, "invalid maxsize %s", maxSize);
        Builder builder2 = CallOptions.toBuilder(this);
        builder2.maxInboundMessageSize = maxSize;
        return builder2.build();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2563")
    public CallOptions withMaxOutboundMessageSize(int maxSize) {
        Preconditions.checkArgument(maxSize >= 0, "invalid maxsize %s", maxSize);
        Builder builder2 = CallOptions.toBuilder(this);
        builder2.maxOutboundMessageSize = maxSize;
        return builder2.build();
    }

    @Nullable
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2563")
    public Integer getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    @Nullable
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2563")
    public Integer getMaxOutboundMessageSize() {
        return this.maxOutboundMessageSize;
    }

    private static Builder toBuilder(CallOptions other) {
        Builder builder2 = new Builder();
        builder2.deadline = other.deadline;
        builder2.executor = other.executor;
        builder2.authority = other.authority;
        builder2.credentials = other.credentials;
        builder2.compressorName = other.compressorName;
        builder2.customOptions = other.customOptions;
        builder2.streamTracerFactories = other.streamTracerFactories;
        builder2.waitForReady = other.waitForReady;
        builder2.maxInboundMessageSize = other.maxInboundMessageSize;
        builder2.maxOutboundMessageSize = other.maxOutboundMessageSize;
        return builder2;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("deadline", this.deadline).add("authority", this.authority).add("callCredentials", this.credentials).add("executor", this.executor != null ? this.executor.getClass() : null).add("compressorName", this.compressorName).add("customOptions", Arrays.deepToString((Object[])this.customOptions)).add("waitForReady", this.isWaitForReady()).add("maxInboundMessageSize", this.maxInboundMessageSize).add("maxOutboundMessageSize", this.maxOutboundMessageSize).add("streamTracerFactories", this.streamTracerFactories).toString();
    }

    static {
        Builder b = new Builder();
        b.customOptions = new Object[0][2];
        b.streamTracerFactories = Collections.emptyList();
        DEFAULT = b.build();
    }

    public static final class Key<T> {
        private final String debugString;
        private final T defaultValue;

        private Key(String debugString, T defaultValue) {
            this.debugString = debugString;
            this.defaultValue = defaultValue;
        }

        public T getDefault() {
            return this.defaultValue;
        }

        public String toString() {
            return this.debugString;
        }

        @Deprecated
        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1869")
        public static <T> Key<T> of(String debugString, T defaultValue) {
            Preconditions.checkNotNull(debugString, "debugString");
            return new Key<T>(debugString, defaultValue);
        }

        public static <T> Key<T> create(String debugString) {
            Preconditions.checkNotNull(debugString, "debugString");
            return new Key<Object>(debugString, null);
        }

        public static <T> Key<T> createWithDefault(String debugString, T defaultValue) {
            Preconditions.checkNotNull(debugString, "debugString");
            return new Key<T>(debugString, defaultValue);
        }
    }

    static class Builder {
        Deadline deadline;
        Executor executor;
        String authority;
        CallCredentials credentials;
        String compressorName;
        Object[][] customOptions;
        List<ClientStreamTracer.Factory> streamTracerFactories;
        Boolean waitForReady;
        Integer maxInboundMessageSize;
        Integer maxOutboundMessageSize;

        Builder() {
        }

        private CallOptions build() {
            return new CallOptions(this);
        }
    }
}

