/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.controller.api.impl.coroutines;

import app.simplecloud.droplet.api.auth.AuthCallCredentials;
import app.simplecloud.pubsub.PubSubClient;
import app.simplecloud.relocate.io.grpc.ManagedChannel;
import app.simplecloud.relocate.io.grpc.ManagedChannelBuilder;
import app.simplecloud.signs.plugin.relocate.controller.api.ControllerApi;
import app.simplecloud.signs.plugin.relocate.controller.api.GroupApi;
import app.simplecloud.signs.plugin.relocate.controller.api.ServerApi;
import app.simplecloud.signs.plugin.relocate.controller.api.impl.coroutines.GroupApiCoroutineImpl;
import app.simplecloud.signs.plugin.relocate.controller.api.impl.coroutines.ServerApiCoroutineImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lapp/simplecloud/signs/plugin/relocate/controller/api/impl/coroutines/ControllerApiCoroutineImpl;", "Lapp/simplecloud/signs/plugin/relocate/controller/api/ControllerApi$Coroutine;", "authSecret", "", "<init>", "(Ljava/lang/String;)V", "authCallCredentials", "Lapp/simplecloud/droplet/api/auth/AuthCallCredentials;", "managedChannel", "Lapp/simplecloud/relocate/io/grpc/ManagedChannel;", "groups", "Lapp/simplecloud/signs/plugin/relocate/controller/api/GroupApi$Coroutine;", "servers", "Lapp/simplecloud/signs/plugin/relocate/controller/api/ServerApi$Coroutine;", "pubSubClient", "Lapp/simplecloud/pubsub/PubSubClient;", "getGroups", "getServers", "getPubSubClient", "createManagedChannelFromEnv", "controller-api"})
public final class ControllerApiCoroutineImpl
implements ControllerApi.Coroutine {
    @NotNull
    private final AuthCallCredentials authCallCredentials;
    @NotNull
    private final ManagedChannel managedChannel;
    @NotNull
    private final GroupApi.Coroutine groups;
    @NotNull
    private final ServerApi.Coroutine servers;
    @NotNull
    private final PubSubClient pubSubClient;

    public ControllerApiCoroutineImpl(@NotNull String authSecret) {
        Intrinsics.checkNotNullParameter(authSecret, "authSecret");
        this.authCallCredentials = new AuthCallCredentials(authSecret);
        this.managedChannel = this.createManagedChannelFromEnv();
        this.groups = new GroupApiCoroutineImpl(this.managedChannel, this.authCallCredentials);
        this.servers = new ServerApiCoroutineImpl(this.managedChannel, this.authCallCredentials);
        String string = System.getenv("CONTROLLER_PUBSUB_HOST");
        if (string == null) {
            string = "localhost";
        }
        String string2 = System.getenv("CONTROLLER_PUBSUB_PORT");
        this.pubSubClient = new PubSubClient(string, string2 != null ? Integer.parseInt(string2) : 5817, this.authCallCredentials);
    }

    @Override
    @NotNull
    public GroupApi.Coroutine getGroups() {
        return this.groups;
    }

    @Override
    @NotNull
    public ServerApi.Coroutine getServers() {
        return this.servers;
    }

    @Override
    @NotNull
    public PubSubClient getPubSubClient() {
        return this.pubSubClient;
    }

    private final ManagedChannel createManagedChannelFromEnv() {
        String string = System.getenv("CONTROLLER_HOST");
        if (string == null) {
            string = "127.0.0.1";
        }
        String host = string;
        String string2 = System.getenv("CONTROLLER_PORT");
        int port = string2 != null ? Integer.parseInt(string2) : 5816;
        ManagedChannel managedChannel = ((ManagedChannelBuilder)ManagedChannelBuilder.forAddress(host, port).usePlaintext()).build();
        Intrinsics.checkNotNullExpressionValue(managedChannel, "build(...)");
        return managedChannel;
    }
}

