/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.brigadier.parser;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.brigadier.parser.CloudStringReader;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.brigadier.suggestion.TooltipSuggestion;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParseResult;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.SuggestionProvider;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class WrappedBrigadierParser<C, T>
implements ArgumentParser<C, T>,
SuggestionProvider<C> {
    public static final String COMMAND_CONTEXT_BRIGADIER_NATIVE_SENDER = "_cloud_brigadier_native_sender";
    private final Supplier<ArgumentType<T>> nativeType;
    private final @Nullable ParseFunction<T> parse;

    public WrappedBrigadierParser(ArgumentType<T> argumentType) {
        this(() -> argumentType);
    }

    public WrappedBrigadierParser(Supplier<ArgumentType<T>> argumentTypeSupplier) {
        this(argumentTypeSupplier, null);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public WrappedBrigadierParser(Supplier<ArgumentType<T>> argumentTypeSupplier, @Nullable ParseFunction<T> parse2) {
        Objects.requireNonNull(argumentTypeSupplier, "brigadierType");
        this.nativeType = argumentTypeSupplier;
        this.parse = parse2;
    }

    public final ArgumentType<T> nativeArgumentType() {
        return this.nativeType.get();
    }

    @Override
    public final @NonNull ArgumentParseResult<@NonNull T> parse(@NonNull app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        CloudStringReader reader2 = CloudStringReader.of(commandInput);
        try {
            Object result2 = this.parse != null ? this.parse.apply(this.nativeType.get(), reader2) : this.nativeType.get().parse((StringReader)reader2);
            return ArgumentParseResult.success(result2);
        }
        catch (CommandSyntaxException ex) {
            return ArgumentParseResult.failure(ex);
        }
    }

    @Override
    public final @NonNull CompletableFuture<@NonNull Iterable<@NonNull app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.Suggestion>> suggestionsFuture(@NonNull app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext<C> commandContext, @NonNull CommandInput input2) {
        CommandContext reverseMappedContext = new CommandContext(commandContext.getOrDefault(COMMAND_CONTEXT_BRIGADIER_NATIVE_SENDER, commandContext.sender()), input2.input(), Collections.emptyMap(), null, null, Collections.emptyList(), StringRange.at((int)input2.cursor()), null, null, false);
        return this.nativeType.get().listSuggestions(reverseMappedContext, new SuggestionsBuilder(input2.input(), input2.cursor())).thenApply(suggestions -> {
            ArrayList<TooltipSuggestion> cloud = new ArrayList<TooltipSuggestion>();
            for (Suggestion suggestion : suggestions.getList()) {
                String beforeSuggestion = input2.input().substring(input2.cursor(), suggestion.getRange().getStart());
                String afterSuggestion = input2.input().substring(suggestion.getRange().getEnd());
                if (beforeSuggestion.isEmpty() && afterSuggestion.isEmpty()) {
                    cloud.add(TooltipSuggestion.suggestion(suggestion.getText(), suggestion.getTooltip()));
                    continue;
                }
                cloud.add(TooltipSuggestion.suggestion(beforeSuggestion + suggestion.getText() + afterSuggestion, suggestion.getTooltip()));
            }
            return cloud;
        });
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    @FunctionalInterface
    public static interface ParseFunction<T> {
        public T apply(ArgumentType<T> var1, StringReader var2) throws CommandSyntaxException;
    }
}

