/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.parser.selector;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.data.SinglePlayerSelector;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.parser.PlayerParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.parser.selector.SelectorUtils;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.component.CommandComponent;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParseResult;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ParserDescriptor;
import java.util.concurrent.CompletableFuture;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SinglePlayerSelectorParser<C>
extends SelectorUtils.PlayerSelectorParser<C, SinglePlayerSelector> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, SinglePlayerSelector> singlePlayerSelectorParser() {
        return ParserDescriptor.of(new SinglePlayerSelectorParser<C>(), SinglePlayerSelector.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, SinglePlayerSelector> singlePlayerSelectorComponent() {
        return CommandComponent.builder().parser(SinglePlayerSelectorParser.singlePlayerSelectorParser());
    }

    public SinglePlayerSelectorParser() {
        super(true);
    }

    @Override
    @API(status=API.Status.INTERNAL, consumers={"app.simplecloud.signs.plugin.relocate.incendo.cloud.*"})
    public SinglePlayerSelector mapResult(final @NonNull String input2, @NonNull SelectorUtils.EntitySelectorWrapper wrapper) {
        final Player player = wrapper.singlePlayer();
        return new SinglePlayerSelector(){

            @Override
            public @NonNull Player single() {
                return player;
            }

            @Override
            public @NonNull String inputString() {
                return input2;
            }
        };
    }

    @Override
    protected @NonNull CompletableFuture<ArgumentParseResult<SinglePlayerSelector>> legacyParse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        String input2 = commandInput.peekString();
        final @Nullable Player player = Bukkit.getPlayer((String)input2);
        if (player == null) {
            return CompletableFuture.completedFuture(ArgumentParseResult.failure(new PlayerParser.PlayerParseException(input2, commandContext)));
        }
        final String pop = commandInput.readString();
        return ArgumentParseResult.successFuture(new SinglePlayerSelector(){

            @Override
            public @NonNull Player single() {
                return player;
            }

            @Override
            public @NonNull String inputString() {
                return pop;
            }
        });
    }
}

