/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.caption;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.Caption;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.CaptionProvider;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.CaptionRegistry;
import java.util.LinkedList;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.common.returnsreceiver.qual.This;

@API(status=API.Status.INTERNAL)
public final class CaptionRegistryImpl<C>
implements CaptionRegistry<C> {
    private final LinkedList<@NonNull CaptionProvider<C>> providers = new LinkedList();

    CaptionRegistryImpl() {
    }

    @Override
    public @NonNull String caption(@NonNull Caption caption, @NonNull C sender2) {
        for (CaptionProvider captionProvider : this.providers) {
            String result2 = captionProvider.provide(caption, sender2);
            if (result2 == null) continue;
            return result2;
        }
        throw new IllegalArgumentException(String.format("There is no caption stored with key '%s'", caption));
    }

    @Override
    public @This @NonNull CaptionRegistry<C> registerProvider(@NonNull CaptionProvider<C> provider) {
        this.providers.addFirst(provider);
        return this;
    }
}

