/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.execution;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.execution.ExecutionCoordinator;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.execution.ExecutionCoordinatorImpl;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.INTERNAL, consumers={"app.simplecloud.signs.plugin.relocate.incendo.cloud.*"})
final class ExecutionCoordinatorBuilderImpl<C>
implements ExecutionCoordinator.Builder<C> {
    private @Nullable Executor parsingExecutor;
    private @Nullable Executor suggestionsExecutor;
    private @Nullable Executor executionSchedulingExecutor;
    private boolean synchronizeExecution = false;

    ExecutionCoordinatorBuilderImpl() {
    }

    @Override
    public @NonNull ExecutionCoordinator.Builder<C> parsingExecutor(@NonNull Executor executor2) {
        Objects.requireNonNull(executor2, "executor");
        this.parsingExecutor = executor2;
        return this;
    }

    @Override
    public @NonNull ExecutionCoordinator.Builder<C> suggestionsExecutor(@NonNull Executor executor2) {
        Objects.requireNonNull(executor2, "executor");
        this.suggestionsExecutor = executor2;
        return this;
    }

    @Override
    public @NonNull ExecutionCoordinator.Builder<C> executionSchedulingExecutor(@NonNull Executor executor2) {
        Objects.requireNonNull(executor2, "executor");
        this.executionSchedulingExecutor = executor2;
        return this;
    }

    @Override
    public @NonNull ExecutionCoordinator.Builder<C> synchronizeExecution(boolean synchronizeExecution) {
        this.synchronizeExecution = synchronizeExecution;
        return this;
    }

    @Override
    public @NonNull ExecutionCoordinator<C> build() {
        return new ExecutionCoordinatorImpl(this.parsingExecutor, this.suggestionsExecutor, this.executionSchedulingExecutor, this.synchronizeExecution);
    }
}

